/**
 * @author Stefan Malär
 * @version v1.0
 * 
 * This file also contains the following plugins: URLEncode plugin, Deserialize plugin, JSON plugin, parseQuery plugin
 */

/** Prepare matawidget form for saving values when toggle buttons clicked and does visual enhancements
 *
 * @param formId ID of the form to be serialized and stored
 *
 * @return void
 */
function prepForm(formId){
    $j(".toggle").click(function(){
        setFormField(formId);
    });
    getFormField(formId);
    //hide unwanted fields
    $j("div#composeForm\\:composeFormBody > div > div:first-child").hide();
    $j("div#composeForm\\:messageObjectHeaderSendingApplication_Metawidget").parent().parent().hide();
    $j("div#composeForm\\:messageObjectReportHeaderSendingApplication_Metawidget").parent().parent().hide();
    //add CH.AHV für old AHV number
    $ahvid = $j("input[id*='composeForm:messageObjectHeaderObjectOtherPersonId0PersonIdCategory']");
    if($ahvid.val() == '') {
        $ahvid.val("CH.AHV");
    }
    //fix display of toggle buttons
    $plusSignContainer = $j(".add-toggle, .remove-toggle").parent().parent();
    $plusSignContainer.css("min-height", "5px");
    $plusSignContainer.children(".label").css("font-size", "1px").html("&nbsp;");
    addSwissAddressValidation();

   

}

/** Adds custom choice validation for eCH-0010:addSwissAddressValidation element
 *
 * @return void
 */
function addSwissAddressValidation(){
    $foreigenZip = $j("#composeForm\\:messageObjectHeaderObjectAddressForeignZipCode");
    $swissZip = $j("#composeForm\\:messageObjectHeaderObjectAddressSwissZipCode");
    $swissZip1 = $j("#composeForm\\:messageObjectHeaderObjectAddressSwissZipCodeAddOn");
    $swissZip2 = $j("#composeForm\\:messageObjectHeaderObjectAddressSwissZipCodeId");
    $errorString = $j("#choiceError").text();

    $foreigenZip.change(function(){
        if(($swissZip.val() != '') || ($swissZip1.val() != '') || ($swissZip2.val() != '')){
            alert($errorString);
            $foreigenZip.val("");
        }
    });

    $swissZip.change(function(){
        if($foreigenZip.val() != ''){
            alert($errorString);
            $swissZip.val("");
        }
    });

    $swissZip1.change(function(){
        if($foreigenZip.val() != ''){
            alert($errorString);
            $swissZip1.val("");
        }
    });

    $swissZip2.change(function(){
        if($foreigenZip.val() != ''){
            alert($errorString);
            $swissZip2.val("");
        }
    });;
}

/** Serialized the form content and stores it in a formfield in JSON format
 *
 * @param formId ID of the form to be serialized and stored
 *
 * @return boolean true
 */
function setFormField(formId){
    var formcontent = $j('#'+ formId).serialize();
    //console.log("formcontent:" + formcontent);
    formcontent = formcontent.replace(/javax.faces.ViewState/g, "oldState");
    formcontent = $j.parseQuery(UTF8.decode($j.URLDecode(formcontent)));
    //console.log("formcontent:" + formcontent);
    formInJson = $j.toJSON(formcontent);
    //console.log("formInJson:" + formInJson);
    $j("#temporaryFormData").val(formInJson);
    return false;

}




/** Get formfield in JSON format and insert data in a form
 *
 * @param formId ID of the form to be filled with stored data
 *
 * @return void
 */
function getFormField(formId){
    var formContent = $j("#temporaryFormData").val();
    $j("#temporaryFormData").val("");
    //console.log("formcontent form form1:" + formContent);
    if(formContent != ""){
        var formInJson = $j.evalJSON(formContent);
        //console.log("formcontent to deserialize:" + formInJson);
        $j('#'+formId).deserialize(formInJson, {
            overwrite: false
        });
    }


}


/**
 * UTF8 encoder/decoder
 *
 */

UTF8 = {
    encode: function(s){
        for(var c, i = -1, l = (s = s.split("")).length, o = String.fromCharCode; ++i < l;
        s[i] = (c = s[i].charCodeAt(0)) >= 127 ? o(0xc0 | (c >>> 6)) + o(0x80 | (c & 0x3f)) : s[i]
    );
        return s.join("");
    },
    decode: function(s){
        for(var a, b, i = -1, l = (s = s.split("")).length, o = String.fromCharCode, c = "charCodeAt"; ++i < l;
        ((a = s[i][c](0)) & 0x80) &&
            (s[i] = (a & 0xfc) == 0xc0 && ((b = s[i + 1][c](0)) & 0xc0) == 0x80 ?
            o(((a & 0x03) << 6) + (b & 0x3f)) : o(128), s[++i] = "")
    );
        return s.join("");
    }
};

/**
 * URLEncode plugin
 *
 * No copyright available
 * Downloaded from http://plugins.jquery.com/project/URLEncode
 * jquery.com is dual licensed the MIT and GPL licenses:
 * http://www.opensource.org/licenses/mit-license.php
 * http://www.gnu.org/licenses/gpl.html
 *
 */

jQuery.extend({
    URLEncode: function(c){
        var o = '';
        var x = 0;
        c = c.toString();
        var r = /(^[a-zA-Z0-9_.]*)/;
        while (x < c.length) {
            var m = r.exec(c.substr(x));
            if (m != null && m.length > 1 && m[1] != '') {
                o += m[1];
                x += m[1].length;
            }
            else {
                if (c[x] == ' ')
                    o += '+';
                else {
                    var d = c.charCodeAt(x);
                    var h = d.toString(16);
                    o += '%' + (h.length < 2 ? '0' : '') + h.toUpperCase();
                }
                x++;
            }
        }
        return o;
    },
    URLDecode: function(s){
        var o = s;
        var binVal, t;
        var r = /(%[^%]{2})/;
        while ((m = r.exec(o)) != null && m.length > 1 && m[1] != '') {
            b = parseInt(m[1].substr(1), 16);
            t = String.fromCharCode(b);
            o = o.replace(m[1], t);
        }
        return o;
    }
});

/**
 * This function sets the values of form element variables from an array
 * This is the reverse process of Mark Constable's serialize function
 * It is expected to be used as a call back for an ajax call that retrieves the form data
 * @param data : array or hash containing name,value pairs for elements in the form
 *
 * Examples
 *
 * 1. Deserialize from an array
 *    $('#form-id').deserialize([{'name':'firstname','value':'John'},{'name':'lastname','value':'Resig'}]);
 *
 * 2. Deserialize from a hash(object)
 *    $('#form-id').deserialize({'firstname':'John','lastname':'Resig'});
 *
 * 3. Deserialize multiple config for select/radio/checkbox
 *    $('#form-id').deserialize({'toppings':['capsicum','mushroom','extra_cheese'],'size':'medium'})
 * which will set the corresponding select/radio/checkbox config for toppings
 *
 * 3. Deserialize multiple config for select/radio/checkbox and with isPHPnaming = true
 *    $('#form-id').deserialize({'toppings':['capsicum','mushroom','extra_cheese'],'size':'medium'},{isPHPnaming:true})
 * which will set the corresponding select/radio/checkbox config for toppings, but will ignore select names ending with []
 *
 * @return         the jQuery Object
 * @author         Ashutosh Bijoor (bijoor@reach1to1.com)
 * @version        0.35
 */
jQuery.fn.deserialize = function(d,config) {
    var data= d;
    me  = this;

    if (d === undefined) {
        return me;
    }

    config = jQuery.extend({
        isPHPnaming	: false,
        overwrite	: true
    },config);
	
    // check if data is an array, and convert to hash, converting multiple entries of
    // same name to an array
    if (d.constructor == Array)	{
        data={};
        for(var i=0; i<d.length; i++) {
            if (typeof data[d[i].name] != 'undefined') {
                if (data[d[i].name].constructor!= Array) {
                    data[d[i].name]=[data[d[i].name],d[i].value];
                } else {
                    data[d[i].name].push(d[i].value);
                }
            } else {
                data[d[i].name]=d[i].value;
            }
        }
    }

    // now data is a hash. insert each parameter into the form
    jQuery('input,select,textarea',me)
    .each(function() {
        var p=this.name;
        var v = [];
			  
        // handle wierd PHP names if required
        if (config.isPHPnaming) {
            p=p.replace(/\[\]$/,'');
        }
        if(p && data[p] != undefined) {
            v = data[p].constructor == Array ? data[p] : [data[p]];
        }
        // Additional parameter overwrite
        if (config.overwrite === true || data[p]) {
            switch(this.type || this.tagName.toLowerCase()) {
                case "radio":
                case "checkbox":
                    this.checked=false;
                    for(var i=0;i<v.length;i++) {
                        this.checked|=(this.value!='' && v[i]==this.value);
                    }
                    break;
                case "select-multiple" || "select":
                    for( i=0;i<this.options.length;i++) {
                        this.options[i].selected=false;
                        for(var j=0;j<v.length;j++) {
                            this.options[i].selected|=(this.options[i].value!='' && this.options[i].value==v[j]);
                        }
                    }
                    break;
                case "button":
                case "submit":
                    this.value=v.length>0?v.join(','):this.value;
                    break;
                default:
                    this.value=v.join(',');
            }
        }
    });
    return me;
};


/*
 * jQuery JSON Plugin
 * version: 1.0 (2008-04-17)
 *
 * This document is licensed as free software under the terms of the
 * MIT License: http://www.opensource.org/licenses/mit-license.php
 *
 * Brantley Harris technically wrote this plugin, but it is based somewhat
 * on the JSON.org website's http://www.json.org/json2.js, which proclaims:
 * "NO WARRANTY EXPRESSED OR IMPLIED. USE AT YOUR OWN RISK.", a sentiment that
 * I uphold.  I really just cleaned it up.
 *
 * It is also based heavily on MochiKit's serializeJSON, which is 
 * copywrited 2005 by Bob Ippolito.
 */
 
(function($) {   
    function toIntegersAtLease(n)
    // Format integers to have at least two digits.
    {
        return n < 10 ? '0' + n : n;
    }

    Date.prototype.toJSON = function(date)
    // Yes, it polutes the Date namespace, but we'll allow it here, as
    // it's damned usefull.
    {
        return this.getUTCFullYear()   + '-' +
            toIntegersAtLease(this.getUTCMonth()) + '-' +
            toIntegersAtLease(this.getUTCDate());
    };

    var escapeable = /["\\\x00-\x1f\x7f-\x9f]/g;
    var meta = {    // table of character substitutions
        '\b': '\\b',
        '\t': '\\t',
        '\n': '\\n',
        '\f': '\\f',
        '\r': '\\r',
        '"' : '\\"',
        '\\': '\\\\'
    };
        
    $.quoteString = function(string)
    // Places quotes around a string, inteligently.
    // If the string contains no control characters, no quote characters, and no
    // backslash characters, then we can safely slap some quotes around it.
    // Otherwise we must also replace the offending characters with safe escape
    // sequences.
    {
        if (escapeable.test(string))
        {
            return '"' + string.replace(escapeable, function (a)
            {
                var c = meta[a];
                if (typeof c === 'string') {
                    return c;
                }
                c = a.charCodeAt();
                return '\\u00' + Math.floor(c / 16).toString(16) + (c % 16).toString(16);
            }) + '"';
        }
        return '"' + string + '"';
    };
    
    $.toJSON = function(o, compact)
    {
        var type = typeof(o);
        
        if (type == "undefined")
            return "undefined";
        else if (type == "number" || type == "boolean")
            return o + "";
        else if (o === null)
            return "null";
        
        // Is it a string?
        if (type == "string")
        {
            return $.quoteString(o);
        }
        
        // Does it have a .toJSON function?
        if (type == "object" && typeof o.toJSON == "function")
            return o.toJSON(compact);
        
        // Is it an array?
        if (type != "function" && typeof(o.length) == "number")
        {
            var ret = [];
            for (var i = 0; i < o.length; i++) {
                ret.push( $.toJSON(o[i], compact) );
            }
            if (compact)
                return "[" + ret.join(",") + "]";
            else
                return "[" + ret.join(", ") + "]";
        }
        
        // If it's a function, we have to warn somebody!
        if (type == "function") {
            throw new TypeError("Unable to convert object of type 'function' to json.");
        }
        
        // It's probably an object, then.
        var ret = [];
        for (var k in o) {
            var name;
            type = typeof(k);
            
            if (type == "number")
                name = '"' + k + '"';
            else if (type == "string")
                name = $.quoteString(k);
            else
                continue;  //skip non-string or number keys
            
            var val = $.toJSON(o[k], compact);
            if (typeof(val) != "string") {
                // skip non-serializable values
                continue;
            }
            
            if (compact)
                ret.push(name + ":" + val);
            else
                ret.push(name + ": " + val);
        }
        return "{" + ret.join(", ") + "}";
    };
    
    $.compactJSON = function(o)
    {
        return $.toJSON(o, true);
    };
    
    $.evalJSON = function(src)
    // Evals JSON that we know to be safe.
    {
        return eval("(" + src + ")");
    };
    
    $.secureEvalJSON = function(src)
    // Evals JSON in a way that is *more* secure.
    {
        var filtered = src;
        filtered = filtered.replace(/\\["\\\/bfnrtu]/g, '@');
        filtered = filtered.replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g, ']');
        filtered = filtered.replace(/(?:^|:|,)(?:\s*\[)+/g, '');
        
        if (/^[\],:{}\s]*$/.test(filtered))
            return eval("(" + src + ")");
        else
            throw new SyntaxError("Error parsing JSON, source is not valid.");
    };
})(jQuery);


/**
 * A simple querystring parser.
 * Example usage: var q = $.parseQuery(); q.fooreturns  "bar" if query contains "?foo=bar"; multiple values are added to an array. 
 * Values are unescaped by default and plus signs replaced with spaces, or an alternate processing function can be passed in the params object .
 * http://actingthemaggot.com/jquery
 *
 * Copyright (c) 2008 Michael Manning (http://actingthemaggot.com)
 * Dual licensed under the MIT (MIT-LICENSE.txt)
 * and GPL (GPL-LICENSE.txt) licenses.
 **/
jQuery.parseQuery = function(qs,options) {
    var q = (typeof qs === 'string'?qs:window.location.search), o = {
        'f':function(v){
            return unescape(v).replace(/\+/g,' ');
        }
    }, options = (typeof qs === 'object' && typeof options === 'undefined')?qs:options, o = jQuery.extend({}, o, options), params = {};
    jQuery.each(q.match(/^\??(.*)$/)[1].split('&'),function(i,p){
        p = p.split('=');
        p[1] = o.f(p[1]);
        params[p[0]] = params[p[0]]?((params[p[0]] instanceof Array)?(params[p[0]].push(p[1]),params[p[0]]):[params[p[0]],p[1]]):p[1];
    });
    return params;
}

function createDatePicker(locale) {
    $j(".datepicker").datepicker({
        dateFormat: 'dd.mm.yy',
        changeMonth: true,
        changeYear: true,
        showOn: 'both',
        maxDate: '0',
        buttonImage: '../img/dtpick.gif',
        buttonImageOnly: true
    });

    $j.datepicker.setDefaults($j.datepicker.regional[locale])
}

function changeInputSize() {
    $j('input').each(function() {
        var length = $j(this).attr("maxlength");
        if (length > -1 && length < 40) {
            $j(this).attr("size", length);
        }
    });
}

//AJAX RichFaces fix
//see http://blogs.developerforce.com/developer-relations/2011/03/visualforce-rerender-and-internet-explorer-9.html
//see https://issues.jboss.org/browse/RF-9485
//error was new XMLSerializer().serializeToString IE9 "no such interface"
/*$j(document).ready(function() {
	if(Sarissa._SARISSA_IS_IE && parseFloat(navigator.appVersion.substring(navigator.appVersion.indexOf("MSIE")+5)) >=9) {  
		 
		  window.XMLSerializer = function(){};      
		 
		  window.XMLSerializer.prototype.serializeToString=function(oNode){return oNode.xml;};    
		 
		}
});*/

function reloadOnce() {
	if(!window.location.hash) { 
        window.location = window.location + '#loaded'; 
        window.location.reload(); 
    } 
}