/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.utils;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="directoryUtilities")
public class DirectoryUtilities {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DirectoryUtilities.class);

    public boolean verifyAccessRights(File location) {
        boolean status;
        Path path = location.toPath();
        boolean isReadable = Files.isReadable(path);
        boolean isWritable = Files.isWritable(path);
        if (isReadable && isWritable) {
            log.debug("Directory {} is accessible to read and write", (Object)location);
            status = true;
        } else {
            if (!isReadable) {
                log.error("Directory {} is not readable", (Object)location);
            }
            if (!isWritable) {
                log.error("Directory {} is not writable", (Object)location);
            }
            status = false;
            log.error("System will exit.");
            System.exit(0);
        }
        return status;
    }

    public boolean verifyDirectorySize(File location, long minSize) {
        boolean status = false;
        long freeSpace = location.getFreeSpace() / 1024L;
        log.debug("Directory {} size is {} Kilo bytes", (Object)location, (Object)freeSpace);
        if (freeSpace < minSize) {
            log.error("Free space of directory {} is not enough (required size: {}). System will terminate.", (Object)location, (Object)minSize);
            System.exit(0);
        } else {
            status = true;
        }
        return status;
    }
}

