/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.util;

import ch.admin.smclient2.web.util.PartialDateHandler;
import jakarta.faces.convert.ConverterException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public abstract class PartialDateHandler {
    static final String[] PARTIAL_DATE_PATTERNS = new String[]{"yyyy", "MM.yyyy", "dd.MM.yyyy"};
    static final String[] PARTIAL_DATE_FIELDNAMES = new String[]{"year", "yearMonth", "yearMonthDay"};
    private static SimpleDateFormat[] DATE_PROPERTY_FORMAT_MAP = new SimpleDateFormat[]{new SimpleDateFormat(PARTIAL_DATE_PATTERNS[0]), new SimpleDateFormat(PARTIAL_DATE_PATTERNS[1]), new SimpleDateFormat(PARTIAL_DATE_PATTERNS[2])};

    Date validateDate(String dateString) throws ConverterException, ParseException {
        if (StringUtils.isBlank((CharSequence)dateString)) {
            return null;
        }
        this.checkRightFormat(dateString);
        this.checkRightLength(dateString);
        Date result = this.parseDate(dateString);
        return result;
    }

    private void checkRightFormat(String dateString) {
        DateFormat pattern = this.getDateFormater(dateString);
        if (pattern == null) {
            throw new ConverterException();
        }
    }

    private void checkRightLength(String dateString) {
        String dateFormat = this.getDateFormat(dateString);
        if (dateString.length() < dateFormat.length()) {
            throw new ConverterException();
        }
    }

    private Date parseDate(String dateString) throws ParseException {
        DateFormat dateFormat = this.getDateFormater(dateString);
        Date result = null;
        try {
            dateFormat.setLenient(false);
            result = dateFormat.parse(dateString);
        }
        catch (java.text.ParseException ex) {
            throw new ParseException(dateFormat);
        }
        return result;
    }

    private DateFormat getDateFormater(String dateString) {
        return DATE_PROPERTY_FORMAT_MAP[this.getConvertKey(dateString)];
    }

    DateFormat getDateFormaterByFieldName(String fieldName) {
        return DATE_PROPERTY_FORMAT_MAP[this.getConvertKeyByFieldName(fieldName)];
    }

    private String getDateFormat(String dateString) {
        return PARTIAL_DATE_PATTERNS[this.getConvertKey(dateString)];
    }

    String getFieldName(String dateString) {
        return PARTIAL_DATE_FIELDNAMES[this.getConvertKey(dateString)];
    }

    int getConvertKey(String value) {
        return StringUtils.countMatches((CharSequence)value, (CharSequence)".");
    }

    int getConvertKeyByFieldName(String fieldName) {
        return Arrays.asList(PARTIAL_DATE_FIELDNAMES).indexOf(fieldName);
    }
}

