/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.util;

import ch.admin.smclient2.web.compatibility.SmClientBundle;
import jakarta.faces.model.SelectItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.springframework.stereotype.Controller;

@Controller
public class ListItemUtil {
    public List<SelectItem> getListItems(String prefix) {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        ResourceBundle bundle = SmClientBundle.getBundle();
        Set<String> keySet = bundle.keySet();
        prefix = (String)prefix + ".";
        for (String key : keySet) {
            if (!key.startsWith((String)prefix)) continue;
            SelectItem item = this.getSelectItem(key, bundle);
            result.add(item);
        }
        Collections.sort(result, new /* Unavailable Anonymous Inner Class!! */);
        return result;
    }

    private SelectItem getSelectItem(String key, ResourceBundle bundle) {
        String label = key;
        String selItemKey = key.substring(key.lastIndexOf(".") + 1);
        try {
            label = bundle.getString(key);
        }
        catch (Exception e) {
            label = selItemKey;
        }
        return new SelectItem((Object)selItemKey, label);
    }

    public List<SelectItem> getListItemsFull(String prefix) {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        ResourceBundle bundle = SmClientBundle.getBundle();
        Set<String> keySet = bundle.keySet();
        prefix = (String)prefix + ".";
        for (String key : keySet) {
            if (!key.startsWith((String)prefix)) continue;
            String shortKey = key.substring(((String)prefix).length());
            SelectItem item = this.getSelectItemFull(key, shortKey, bundle);
            result.add(item);
        }
        Collections.sort(result, new /* Unavailable Anonymous Inner Class!! */);
        return result;
    }

    private SelectItem getSelectItemFull(String key, String shortKey, ResourceBundle bundle) {
        String label;
        try {
            label = bundle.getString(key);
        }
        catch (Exception e) {
            label = key;
        }
        return new SelectItem((Object)shortKey, label);
    }
}

