/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.service;

import ch.admin.smclient.model.Domain;
import ch.admin.smclient.model.Mandant;
import ch.admin.smclient.service.DomainParameters;
import ch.admin.smclient.service.DomainRepository;
import ch.admin.smclient.service.MandantRepository;
import ch.admin.smclient.service.repository.FileRepository;
import ch.admin.smclient2.web.service.DeletedMessageCheck;
import ch.admin.smclient2.web.service.NewMessageCheck;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import lombok.Generated;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="schedulerStarter")
public class SchedulerStarter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchedulerStarter.class);
    @Autowired
    protected NewMessageCheck newMessageCheck;
    @Autowired
    protected DeletedMessageCheck deletedMessageCheck;
    @Autowired
    private FileRepository fileRepository;
    @Autowired
    private MandantRepository mandantRepository;
    @Autowired
    private DomainRepository domainRepository;
    private final Scheduler scheduler;
    @Value(value="${smclient.delete-message-check.interval:21600}")
    public int checkInterval = 21600;

    public SchedulerStarter(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @EventListener
    @Transactional
    public void observe(ApplicationStartedEvent event) throws IOException, SchedulerException {
        log.info("================================================================");
        log.info("The application was started. Schedule the jobs for all mandants.");
        log.info("================================================================");
        List mandanten = this.mandantRepository.findAllActive();
        Date startTime = new Date(System.currentTimeMillis() + Long.parseLong(System.getProperty("ch.admin.smclient.startupWaitMillis", "30000")));
        for (Mandant mandant : mandanten) {
            int interval = this.fileRepository.getFileChangeInterval(mandant.getSedexId());
            Collection domains = this.getConfiguredDomains(mandant.getSedexId());
            for (DomainParameters params : domains) {
                this.scheduleMessageCheckTask(mandant.getSedexId(), params, startTime, interval);
                startTime.setTime(startTime.getTime() + Long.parseLong(System.getProperty("ch.admin.smclient.intervalBetweenJobs", "11000")));
            }
            this.scheduleDeleteMessageCheck(mandant.getSedexId(), startTime);
        }
    }

    @PreDestroy
    public void onApplicationScopeDestroy() {
    }

    private Collection<DomainParameters> getConfiguredDomains(String sedexId) {
        EnumSet<DomainParameters> result = EnumSet.noneOf(DomainParameters.class);
        List domains = this.domainRepository.findAll(sedexId);
        for (Domain domain : domains) {
            try {
                DomainParameters configuredDomain = DomainParameters.valueOfName((String)domain.getName());
                result.add(configuredDomain);
            }
            catch (IllegalArgumentException e) {
                log.warn("Domain '{}' not available, possible values are: {}", (Object)domain.getName(), (Object)Arrays.deepToString(DomainParameters.values()));
            }
            result.add(DomainParameters.STANDARD);
        }
        return result;
    }

    public void scheduleMessageCheckTask(String sedexId, DomainParameters params, Date startTime, int interval) throws SchedulerException {
        String domainName = params.getName();
        log.info("Schedule job for sedexId: {}, domainName: {}, startTime: {}, interval: {}s", new Object[]{sedexId, domainName, startTime, interval});
        JobDetail job = JobBuilder.newJob(NewMessageCheck.class).withIdentity("newMessageCheck-job-" + sedexId + "-" + domainName).usingJobData("sedexId", sedexId).usingJobData("domainName", domainName).build();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity("trigger-newMessageCheck-job-" + sedexId + "-" + domainName).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(interval).repeatForever()).startAt(startTime).build();
        this.scheduler.scheduleJob(job, trigger);
    }

    public void scheduleDeleteMessageCheck(String sedexId, Date startTime) throws SchedulerException {
        log.info("Scheduling job for deletion of message for sedexId: {}, startTime: {}, interval: {}s", new Object[]{sedexId, startTime, this.checkInterval});
        JobDetail job = JobBuilder.newJob(DeletedMessageCheck.class).withIdentity("Delete Message Job for " + sedexId).usingJobData("sedexId", sedexId).build();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity("Trigger for delete message task").withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(this.checkInterval).repeatForever()).startAt(startTime).build();
        this.scheduler.scheduleJob(job, trigger);
    }
}

