/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.service;

import ch.admin.smclient.model.Domain;
import ch.admin.smclient.model.Message;
import ch.admin.smclient.model.validate.message.MessageDefinition;
import ch.admin.smclient.process.basic.ProcessBroker;
import ch.admin.smclient.process.event.RemoveFromAllCacheEvent;
import ch.admin.smclient.service.DomainParameters;
import ch.admin.smclient.service.DomainRepository;
import ch.admin.smclient.service.MessageContentHandler;
import ch.admin.smclient.service.MessageHandler;
import ch.admin.smclient.service.MessageService;
import ch.admin.smclient.service.ProductVersion;
import ch.admin.smclient.service.RepositoryVersionInfo;
import ch.admin.smclient.service.Triage;
import ch.admin.smclient.service.exceptions.SmClientShutdownException;
import ch.admin.smclient.service.postfach.MailboxFolder;
import ch.admin.smclient.service.repository.DirectoryRepository;
import ch.admin.smclient.service.repository.FileRepository;
import ch.admin.smclient.util.ZipTool;
import ch.admin.smclient2.web.service.CacheManager;
import ch.admin.smclient2.web.service.Monitor;
import ch.admin.smclient2.web.service.NewMessageCheck;
import ch.admin.smclient2.web.utils.DirectoryUtilities;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component(value="newMessageCheck")
public class NewMessageCheck
implements Job {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewMessageCheck.class);
    private static final Monitor monitor = new Monitor();
    @Autowired
    private DirectoryRepository directoryRepository;
    @Autowired
    private ProcessBroker processBroker;
    @Autowired
    private Triage triage;
    @Autowired
    private ProductVersion productVersion;
    @Autowired
    private MessageService messageService;
    @Autowired
    private FileRepository fileRepository;
    @Autowired
    private MessageHandler messageHandler;
    @Autowired
    private DomainRepository domainRepository;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private DirectoryUtilities directoryUtilities;
    @Autowired
    private RepositoryVersionInfo repositoryVersionInfo;
    @Autowired
    private ApplicationContext applicationContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        String sedexId = jobExecutionContext.getJobDetail().getJobDataMap().getString("sedexId");
        String domainName = jobExecutionContext.getJobDetail().getJobDataMap().getString("domainName");
        log.info("Execute job for sedexId: {}, domainName: {}", (Object)sedexId, (Object)domainName);
        DomainParameters params = DomainParameters.valueOfName((String)domainName);
        log.info("Restored domainParameters: {}", (Object)params);
        try {
            Object object;
            List filesToProcess;
            File location;
            Domain domain;
            block45: {
                Triage.Status triageAndDomainCheck;
                boolean fileWritable3;
                block41: {
                    MDC.put((String)"sedexId", (String)sedexId);
                    log.info("i-0500 | Keep alive for sM-Client version {} and domain {}", (Object)this.productVersion.getProductVersion(), (Object)domainName);
                    this.checkRepositoryVersionMatchSedexId(sedexId);
                    domain = this.getDomain(domainName);
                    this.verifyFolders(sedexId, domain);
                    if (params.hasOutbox()) {
                        location = this.directoryRepository.getSmclientOutbox(sedexId, domain);
                        this.verifyDirectoryAccessAndSize(location);
                        log.debug("Domain [{}] checks outbox in [{}] with extensions {}", new Object[]{params.getName(), location, params.getSendExtentions()});
                        filesToProcess = this.getBatchList(location, sedexId, params.getSendExtentions());
                        for (Object file : filesToProcess) {
                            object = monitor.get((Object)((File)file).getAbsoluteFile());
                            // MONITORENTER : object
                            fileWritable3 = ch.admin.smclient.util.file.FileUtils.isFileWritable((File)file);
                            if (fileWritable3 && !this.cacheManager.hasBeenRead(sedexId, params, (File)file)) {
                                boolean messageServiceShouldPickupMessage;
                                triageAndDomainCheck = this.accept((File)file, sedexId, params, true);
                                if (triageAndDomainCheck == Triage.Status.IGNORED) {
                                    log.debug("{} not for this poller {} or not accepted by triage", file, (Object)params.getName());
                                    // MONITOREXIT : object
                                    continue;
                                }
                                if (triageAndDomainCheck == Triage.Status.ENVL_MISSING) {
                                    log.info("{} not ready to be parsed, probably envelope is missing, will be processed next time", file);
                                    this.removeFromCache((File)file);
                                    // MONITOREXIT : object
                                    continue;
                                }
                                boolean bl = messageServiceShouldPickupMessage = !params.hasInitialMessageId((File)file) || this.messageService.shouldPickupMessage((File)file, sedexId, params.getSendProcessName());
                                if (messageServiceShouldPickupMessage && triageAndDomainCheck == Triage.Status.OK) {
                                    log.info("i-0120 | new message found: '{}' in domain {}", file, (Object)domainName);
                                    this.processBroker.startSendProcess(sedexId, (File)file, params.getSendProcessName());
                                    this.removeFromCache((File)file);
                                }
                                if (!messageServiceShouldPickupMessage) {
                                    log.info("i-0121 | ignoring message '{}' because it was already handled by this smclient", file);
                                }
                            } else if (fileWritable3) {
                                log.info("File {} has already been tested by {}:{}", new Object[]{file, sedexId, params});
                            }
                            // MONITOREXIT : object
                        }
                    }
                    if (!params.hasReceipt()) break block41;
                    location = this.directoryRepository.getReceiptLocation(sedexId, domain);
                    this.verifyDirectoryAccessAndSize(location);
                    log.debug("Domain [{}] checks receipt in [{}] with extensions {}", new Object[]{params.getName(), location, params.getSendExtentions()});
                    filesToProcess = this.getBatchList(location, sedexId, new String[]{".xml"});
                    int ignored = 0;
                    for (File file : filesToProcess) {
                        block43: {
                            block44: {
                                boolean fileWritable2;
                                block42: {
                                    Object fileWritable3 = monitor.get((Object)file.getAbsoluteFile());
                                    // MONITORENTER : fileWritable3
                                    fileWritable2 = ch.admin.smclient.util.file.FileUtils.isFileWritable((File)file);
                                    if (!fileWritable2 || this.cacheManager.hasBeenRead(sedexId, params, file)) break block42;
                                    this.cacheManager.put(sedexId, params, file);
                                    if (this.accept(file, sedexId, params, false) != Triage.Status.OK) break block43;
                                    break block44;
                                }
                                if (fileWritable2) {
                                    log.info("File {} has already been tested by {}:{}", new Object[]{file, sedexId, params});
                                    ++ignored;
                                }
                                // MONITOREXIT : fileWritable3
                                continue;
                            }
                            log.info("i-0120 | new message found: '{}' in domain {}", (Object)file, (Object)domainName);
                            this.processBroker.continueProcess(sedexId, file, params.getSendProcessName());
                            this.removeFromCache(file);
                        }
                        // MONITOREXIT : fileWritable3
                    }
                    if (!filesToProcess.isEmpty() && ignored >= filesToProcess.size()) {
                        log.error("sM-Client is blocked for {} and domain {} on the folder {} with files {}", new Object[]{sedexId, domain, location, filesToProcess});
                    }
                }
                if (!params.hasInbox()) break block45;
                location = this.directoryRepository.getAdapterInbox(sedexId, domain);
                this.verifyDirectoryAccessAndSize(location);
                log.debug("Domain [{}] checks inbox in [{}] with extensions {}", new Object[]{params.getName(), location, params.getSendExtentions()});
                filesToProcess = this.getBatchList(location, sedexId, params.getReceiveExtentions());
                for (Object file : filesToProcess) {
                    block47: {
                        block48: {
                            block46: {
                                log.info("Process file: {}", file);
                                object = monitor.get((Object)((File)file).getAbsoluteFile());
                                // MONITORENTER : object
                                fileWritable3 = ch.admin.smclient.util.file.FileUtils.isFileWritable((File)file);
                                if (!fileWritable3 || this.cacheManager.hasBeenRead(sedexId, params, (File)file)) break block46;
                                this.cacheManager.put(sedexId, params, (File)file);
                                triageAndDomainCheck = this.accept((File)file, sedexId, params, false);
                                if (triageAndDomainCheck != Triage.Status.IGNORED) break block47;
                                break block48;
                            }
                            if (fileWritable3) {
                                log.info("File {} has already been tested by {}:{}", new Object[]{file, sedexId, params});
                            }
                            // MONITOREXIT : object
                            continue;
                        }
                        log.debug("The file {} is not accepted for poller of domain {} or not accepted by triage.", file, (Object)domainName);
                        // MONITOREXIT : object
                        continue;
                    }
                    if (triageAndDomainCheck == Triage.Status.ENVL_MISSING) {
                        log.info("The file {} is not ready to be parsed, probably envelope is missing, will be processed next time.", file);
                        this.removeFromCache((File)file);
                        // MONITOREXIT : object
                        continue;
                    }
                    if (this.messageService.shouldPickupMessage((File)file, sedexId, params.getReceiveProcessName()) || params.equals((Object)DomainParameters.ELM)) {
                        if (triageAndDomainCheck == Triage.Status.OK) {
                            log.info("i-0120 | new message found: '{}' in domain {}", file, (Object)domainName);
                            this.processBroker.startReceiveProcess(sedexId, (File)file, params);
                            this.removeFromCache((File)file);
                        }
                    } else {
                        log.info("i-0121 | ignoring message '{}' because it was already handled by this smclient", file);
                    }
                    // MONITOREXIT : object
                }
            }
            if (params != DomainParameters.ELM) return;
            location = this.directoryRepository.getAdapterFailedToTransmit(sedexId, domain);
            this.verifyDirectoryAccessAndSize(location);
            log.debug("Domain [{}] checks failed to transmit in [{}] with extensions {}", new Object[]{params.getName(), location, params.getSendExtentions()});
            filesToProcess = this.getBatchList(location, sedexId, params.getSendExtentions());
            for (Object file : filesToProcess) {
                log.info("Process file: {}", file);
                object = monitor.get((Object)((File)file).getAbsoluteFile());
                // MONITORENTER : object
                if (this.accept((File)file, sedexId, params, false) == Triage.Status.OK) {
                    log.info("i-0120 | new message found: '{}'", file);
                    this.processBroker.continueElmProcess(sedexId, (File)file, params.getSendProcessName());
                }
                // MONITOREXIT : object
            }
            location = this.directoryRepository.getAdapterSent(sedexId, domain);
            this.verifyDirectoryAccessAndSize(location);
            log.debug("Domain [{}] checks sent in [{}] with extensions {}", new Object[]{params.getName(), location, params.getSendExtentions()});
            filesToProcess = this.getBatchList(location, sedexId, params.getSendExtentions());
            Iterator iterator = filesToProcess.iterator();
            while (iterator.hasNext()) {
                Object file;
                file = (File)iterator.next();
                log.info("Process file: {}", file);
                object = monitor.get((Object)((File)file).getAbsoluteFile());
                // MONITORENTER : object
                if (this.accept((File)file, sedexId, params, false) == Triage.Status.OK) {
                    log.info("i-0120 | new message found: '{}'", file);
                    this.processBroker.continueElmProcess(sedexId, (File)file, params.getSendProcessName());
                }
                // MONITOREXIT : object
            }
            return;
        }
        catch (SmClientShutdownException e) {
            log.info("The process has been interrupted, the files will be reprocessed after restarting the smclient. ");
            return;
        }
        catch (IOException e) {
            log.error("unexpected IO error while check for new messages.", (Throwable)e);
            return;
        }
        catch (Exception e) {
            log.error("Unexpected error while check for new messages.", (Throwable)e);
            return;
        }
        finally {
            MDC.remove((String)"sedexId");
        }
    }

    private void verifyFolders(String sedexId, Domain domain) {
        String key_path_fa_in = MailboxFolder.INBOX.getLocationKey();
        File file_path_fa_in = this.directoryRepository.getDirectoryLocation(sedexId, key_path_fa_in, domain);
        if (file_path_fa_in != null) {
            this.verifyDirectoryAccessAndSize(file_path_fa_in);
        } else {
            this.stopApplication();
        }
        String key_path_fa_sent = MailboxFolder.SENT.getLocationKey();
        File file_path_fa_sent = this.directoryRepository.getDirectoryLocation(sedexId, key_path_fa_sent, domain);
        if (file_path_fa_sent != null) {
            this.verifyDirectoryAccessAndSize(file_path_fa_sent);
        } else {
            this.stopApplication();
        }
        String key_path_fa_failed_to_send = MailboxFolder.FAILED_TO_SEND.getLocationKey();
        File file_path_fa_failed_to_send = this.directoryRepository.getDirectoryLocation(sedexId, key_path_fa_failed_to_send, domain);
        if (file_path_fa_failed_to_send != null) {
            this.verifyDirectoryAccessAndSize(file_path_fa_failed_to_send);
        } else {
            this.stopApplication();
        }
        String key_path_fa_failed_to_tx = MailboxFolder.FAILED_TO_TRANSMIT.getLocationKey();
        File file_path_fa_failed_to_tx = this.directoryRepository.getDirectoryLocation(sedexId, key_path_fa_failed_to_tx, domain);
        if (file_path_fa_failed_to_tx != null) {
            this.verifyDirectoryAccessAndSize(file_path_fa_failed_to_tx);
        } else {
            this.stopApplication();
        }
        String key_path_fa_failed = MailboxFolder.FAILED.getLocationKey();
        File file_path_fa_failed = this.directoryRepository.getDirectoryLocation(sedexId, key_path_fa_failed, domain);
        if (file_path_fa_failed != null) {
            this.verifyDirectoryAccessAndSize(file_path_fa_failed);
        } else {
            this.stopApplication();
        }
        String key_path_exported = MailboxFolder.EXPORTED.getLocationKey();
        File file_path_exported = this.directoryRepository.getDirectoryLocation(sedexId, key_path_exported);
        if (file_path_exported != null) {
            this.verifyDirectoryAccessAndSize(file_path_exported);
        } else {
            this.stopApplication();
        }
        String key_path_adapter_out = MailboxFolder.ADAPTER_OUTBOX.getLocationKey();
        File file_path_adapter_out = this.directoryRepository.getDirectoryLocation(sedexId, key_path_adapter_out, domain);
        if (file_path_adapter_out != null) {
            this.verifyDirectoryAccessAndSize(file_path_adapter_out);
        } else {
            this.stopApplication();
        }
    }

    private void stopApplication() {
        log.error("Folder verification failed. The system process will terminate.");
        System.exit(0);
    }

    private void checkRepositoryVersionMatchSedexId(String sedexId) {
        if (this.repositoryVersionInfo == null) {
            log.error("OK if in test");
            return;
        }
        if (!this.repositoryVersionInfo.checkSedexIdMatchesVersionName(sedexId)) {
            log.warn("w-0120 | for tenant {} there is a mismatch between type of sedexId and type of repository {} (either TEST/PROD or PROD/TEST - should be either TEST/TEST or PROD/PROD)", (Object)sedexId, (Object)this.repositoryVersionInfo.getVersionName(sedexId));
        }
    }

    private void verifyDirectoryAccessAndSize(File location) {
        this.directoryUtilities.verifyAccessRights(location);
        this.directoryUtilities.verifyDirectorySize(location, this.fileRepository.getMinimalDirectorySize());
    }

    private void removeFromCache(File file) {
        log.info("Publish event to remove the file from the cache: {}", (Object)file);
        this.applicationContext.publishEvent((Object)new RemoveFromAllCacheEvent(file));
    }

    private Domain getDomain(String name) throws IOException {
        try {
            return this.domainRepository.findByName(name);
        }
        catch (Exception e) {
            log.error("Domain {} is not configured in the database", (Object)name);
            throw new IOException("Domain " + name + " is not configured in the database", e);
        }
    }

    private List<File> getBatchList(File location, String sedexId, String[] extensions) {
        SuffixFileFilter suffixFileFilter = new SuffixFileFilter(extensions, IOCase.INSENSITIVE);
        IOFileFilter notEnvlFileFilter = FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.prefixFileFilter((String)"envl_"));
        Collection files = FileUtils.listFiles((File)location, (IOFileFilter)FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{suffixFileFilter, notEnvlFileFilter}), (IOFileFilter)TrueFileFilter.INSTANCE);
        ArrayList temp = new ArrayList(files);
        this.sortFiles(temp);
        int toIndex = Math.min(temp.size(), this.fileRepository.getMessageBatchPickupSize(sedexId));
        return temp.subList(0, toIndex);
    }

    private void sortFiles(List<File> temp) {
        int i;
        Object[] fileInfos = new FileInfo[temp.size()];
        for (i = 0; i < temp.size(); ++i) {
            fileInfos[i] = new FileInfo(this, temp.get(i));
        }
        Arrays.sort(fileInfos);
        for (i = 0; i < temp.size(); ++i) {
            temp.set(i, ((FileInfo)fileInfos[i]).file);
        }
    }

    public Triage.Status accept(File file, String sedexId, DomainParameters params, boolean forSending) {
        if (!ch.admin.smclient.util.file.FileUtils.isFileWritable((File)file) || ZipTool.isEnvelope((File)file)) {
            return Triage.Status.IGNORED;
        }
        String name = file.getName();
        File sedexHeader = MessageHandler.createEnvelopeFileLocation((File)file);
        if (params.isValidReceiveExtension(FilenameUtils.getExtension((String)name).toLowerCase()) || this.isSedexReceipt(file)) {
            List definitions;
            Message envelope = null;
            String namespace = null;
            String messageType = null;
            try {
                if (this.isSedexReceipt(file)) {
                    envelope = this.messageHandler.parseReceipt(file);
                } else if (sedexHeader.exists()) {
                    envelope = this.messageHandler.parseEnvelope(sedexHeader);
                } else if (DomainParameters.ECH0058V4 == params || DomainParameters.STANDARD == params) {
                    try (ZipFile zipFile = ((ZipFile.Builder)ZipFile.builder().setFile(file)).get();){
                        log.info("Let the message content handler read the contents of file: {}", (Object)file);
                        MessageContentHandler contentHandler = new MessageContentHandler(zipFile);
                        messageType = contentHandler.getMessageType();
                        namespace = contentHandler.getNamespaceURI();
                    }
                } else {
                    envelope = this.messageHandler.parseMessage(file, params.getSendProcessName());
                }
                if (messageType == null) {
                    if (envelope == null) {
                        log.info("The message was not parsed correctly {}. (see previous error in log)", (Object)file);
                        throw new Exception("Envelope is empty = The message was not parsed correctly. see previous error in log.");
                    }
                    messageType = envelope.getMessageType();
                }
                definitions = this.fileRepository.getMessageDefinition(sedexId, messageType);
            }
            catch (Exception e) {
                log.info("could not parse message {} so we could not determine rule. ({})", new Object[]{sedexHeader, e.getMessage(), e});
                Triage.Status result = this.defaultAccept(sedexId, params, sedexHeader, file, forSending);
                if (result == Triage.Status.OK) {
                    if (!sedexHeader.exists()) {
                        log.warn("File '{}' does not exist, but defaultAccept returned Status.OK.", (Object)sedexHeader);
                    } else if (!sedexHeader.delete()) {
                        log.warn("File '{}' can't be deleted. Will try to delete on shutdown.", (Object)sedexHeader);
                        sedexHeader.deleteOnExit();
                    }
                }
                return result;
            }
            String domain = null;
            if (definitions != null) {
                for (MessageDefinition definition : definitions) {
                    domain = definition.getDomain();
                    if (definition.hasDomainOnVersion()) {
                        if (StringUtils.isBlank((CharSequence)namespace)) {
                            Message messageObject;
                            if (envelope != null && StringUtils.isNotBlank((CharSequence)envelope.getSubMessageType())) {
                                messageObject = envelope;
                            } else {
                                Map parseMessageToSend;
                                try {
                                    parseMessageToSend = this.messageHandler.parseMessageToSend(file, params.getSendProcessName());
                                }
                                catch (Exception e) {
                                    log.info("Unable to read message {} to get its domain", (Object)file);
                                    return Triage.Status.IGNORED;
                                }
                                if (!parseMessageToSend.isEmpty()) {
                                    messageObject = (Message)parseMessageToSend.values().iterator().next();
                                } else {
                                    log.info("Unable to read message {} to get its domain", (Object)file);
                                    return Triage.Status.IGNORED;
                                }
                            }
                            namespace = messageObject.getParsedDocument().getRootElement().getNamespaceURI();
                        }
                        domain = definition.getDomain(namespace);
                    }
                    if (!StringUtils.equals((CharSequence)params.getName(), (CharSequence)domain)) continue;
                    return sedexHeader.exists() || !forSending ? this.executeTriageCheck(sedexId, sedexHeader, file, params) : Triage.Status.OK;
                }
                if (domain != null) {
                    log.info("domain {} (message type: {}) not for this poller ({}). message {} will be ignored", new Object[]{domain, envelope != null ? envelope.getMessageType() : messageType, params.getName(), file});
                    return Triage.Status.IGNORED;
                }
                if (!params.isIncludedInMessageList() && params.isValidReceiveExtension(FilenameUtils.getExtension((String)name))) {
                    return Triage.Status.OK;
                }
            }
            return this.defaultAccept(sedexId, params, sedexHeader, file, forSending);
        }
        if (StringUtils.containsIgnoreCase((CharSequence)name, (CharSequence)"receipt") && this.executeTriageCheck(sedexId, file, file, params) == Triage.Status.OK) {
            return Triage.Status.OK;
        }
        log.info("i-0122 | Ignoring message {} because not a zip file", (Object)name);
        return Triage.Status.IGNORED;
    }

    private boolean isSedexReceipt(File file) {
        String name = file.getName();
        boolean containsReceiptInName = StringUtils.containsIgnoreCase((CharSequence)name, (CharSequence)"receipt");
        boolean isXml = StringUtils.endsWithIgnoreCase((CharSequence)name, (CharSequence)".xml");
        return containsReceiptInName && isXml;
    }

    private Triage.Status executeTriageCheck(String sedexId, File sedexHeader, File file, DomainParameters domParam) {
        File messageFile = this.isSedexReceipt(file) ? file : sedexHeader;
        Triage.Status triageCheck = this.triage.shouldPickupMessage(sedexId, messageFile);
        if (triageCheck == Triage.Status.IGNORED) {
            log.info("i-0122 | Ignoring message {} in Domain {} because of triage configuration", (Object)file.getName(), (Object)domParam.getName());
        }
        return triageCheck;
    }

    private Triage.Status defaultAccept(String sedexId, DomainParameters params, File sedexHeader, File file, boolean forSending) {
        if (sedexHeader.exists() || !forSending) {
            Triage.Status triageCheck = this.executeTriageCheck(sedexId, sedexHeader, file, params);
            if (triageCheck == Triage.Status.ENVL_MISSING) {
                return triageCheck;
            }
            return triageCheck == Triage.Status.OK && DomainParameters.ECH0058V4.equals((Object)params) ? Triage.Status.OK : Triage.Status.IGNORED;
        }
        return DomainParameters.ECH0058V4.equals((Object)params) ? Triage.Status.OK : Triage.Status.IGNORED;
    }
}

