/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.service;

import ch.admin.smclient.model.Message;
import ch.admin.smclient.model.Property;
import ch.admin.smclient.service.postfach.MailboxService;
import ch.admin.smclient.service.repository.PropertyRepository;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="deletedMessageCheck")
public class DeletedMessageCheck
implements Job {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeletedMessageCheck.class);
    @Autowired
    private MailboxService mailboxService;
    @Autowired
    private PropertyRepository propertyRepository;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        int daysOld;
        String sedexId = jobExecutionContext.getJobDetail().getJobDataMap().getString("sedexId");
        log.info("Execute job for sedexId: {}", (Object)sedexId);
        try {
            Property keepTime = this.propertyRepository.findByName(sedexId, "keep.deleted.time");
            daysOld = Integer.parseInt(keepTime.getValue());
        }
        catch (Exception ex) {
            log.error("e-0409 | Can't load property keep.deleted.time for {}", (Object)sedexId, (Object)ex);
            throw new JobExecutionException("Can't load property keep.deleted.time ", (Throwable)ex);
        }
        log.debug("Deleting message older than {} days", (Object)daysOld);
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(new Date());
        cal.add(6, -daysOld);
        List toDelete = this.mailboxService.getMessageOlderThan(sedexId, cal.getTime());
        for (Message message : toDelete) {
            File messageLocation = new File(message.getFolder(), message.getFileName());
            log.debug("Deleting message from FileSystem {}", (Object)messageLocation.getAbsolutePath());
            FileUtils.deleteQuietly((File)messageLocation);
            this.mailboxService.completeDelete(message);
        }
    }
}

