/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.service;

import ch.admin.smclient.model.Pair;
import ch.admin.smclient.process.event.RemoveFromAllCacheEvent;
import ch.admin.smclient.process.event.RemoveFromCacheEvent;
import ch.admin.smclient.service.DomainParameters;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component(value="cacheManager")
public class CacheManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CacheManager.class);
    private final Map<Pair<String, DomainParameters>, List<File>> cache = Collections.synchronizedMap(new HashMap());

    public boolean hasBeenRead(String sedexId, DomainParameters params, File file) {
        Pair key = this.getKey(sedexId, params);
        List files = (List)this.cache.get(key);
        if (files == null || files.isEmpty()) {
            return false;
        }
        return files.contains(file.getAbsoluteFile());
    }

    private Pair<String, DomainParameters> getKey(String sedexId, DomainParameters params) {
        return new Pair((Object)sedexId, (Object)params);
    }

    public void put(String sedexId, DomainParameters params, File file) {
        Pair key = this.getKey(sedexId, params);
        List<File> files = (List<File>)this.cache.get(key);
        if (files == null) {
            files = Collections.synchronizedList(new ArrayList());
            this.cache.put(key, files);
        }
        files.add(file.getAbsoluteFile());
        log.debug("Put file {} in cache with key: {}", (Object)file, (Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener
    public void removeFromAllCache(RemoveFromAllCacheEvent event) {
        File file = event.getFile();
        Set entries = this.cache.entrySet();
        Map map = this.cache;
        synchronized (map) {
            for (Map.Entry entry : entries) {
                List files = (List)entry.getValue();
                boolean removed = files.remove(file.getAbsoluteFile());
                if (!removed) continue;
                log.debug("Removed file {} from cache with key: {}", (Object)file, entry.getKey());
            }
        }
    }

    @EventListener
    public void removeFromCache(RemoveFromCacheEvent event) {
        DomainParameters domainParameters;
        File file = event.getFile();
        String sedexId = event.getSedexId();
        List currentCache = (List)this.cache.get(this.getKey(sedexId, domainParameters = event.getDomParm()));
        if (currentCache != null) {
            currentCache.remove(file.getAbsoluteFile());
        }
    }
}

