/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.schema.reflect;

import ch.admin.smclient2.web.schema.MinOccursVisitor;
import ch.admin.smclient2.web.schema.reflect.Strategy;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.visitor.XSContentTypeVisitor;
import jakarta.xml.bind.annotation.XmlType;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;

public class PropertyIterator {
    private XSSchemaSet schemaSet;
    private final Strategy strategy;

    public PropertyIterator(XSSchemaSet schemaSet, Strategy strategy) {
        this.schemaSet = schemaSet;
        this.strategy = strategy;
    }

    public PropertyIterator(Strategy strategy) {
        this(null, strategy);
    }

    public Object iterate(Class theClass) throws Exception {
        Object newInstance = theClass.isEnum() ? theClass.getEnumConstants()[0] : theClass.newInstance();
        return this.iterate(newInstance);
    }

    public Object iterate(Object object) throws Exception {
        return this.iterate(object, true);
    }

    public Object iterate(Object object, boolean recurse) throws Exception {
        PropertyDescriptor[] properties;
        for (PropertyDescriptor property : properties = PropertyUtils.getPropertyDescriptors((Object)object)) {
            if (this.shouldStrategyExcute(object, property)) {
                this.executeStrategy(object, property);
            }
            if (!recurse) continue;
            this.recurseValue(property, object);
        }
        return object;
    }

    private boolean shouldStrategyExcute(Object object, PropertyDescriptor property) throws Exception {
        XSComplexType type;
        XmlType xmlType = object.getClass().getAnnotation(XmlType.class);
        if (xmlType != null && (type = this.schemaSet.getComplexType(xmlType.namespace(), xmlType.name())) != null) {
            MinOccursVisitor visitor = new MinOccursVisitor(property.getName());
            type.getContentType().visit((XSContentTypeVisitor)visitor);
            return this.strategy.shouldExecute(visitor);
        }
        return true;
    }

    private void executeStrategy(Object object, PropertyDescriptor property) throws Exception {
        this.strategy.execute(object, property);
    }

    private void recurseValue(PropertyDescriptor property, Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, Exception {
        Object value;
        Method readMethod = property.getReadMethod();
        if (readMethod != null && (value = readMethod.invoke(object, new Object[0])) != null) {
            if (value instanceof List) {
                List list = (List)value;
                for (Object o : list) {
                    if (o == null || !this.isNotKnowType(o)) continue;
                    this.iterate(o);
                }
            } else if (this.isNotKnowType(value)) {
                this.iterate(value);
            }
        }
    }

    private boolean isNotKnowType(Object value) {
        boolean one = !value.getClass().getName().startsWith("java");
        boolean second = !value.getClass().getName().contains("ElementNSImpl");
        return one && second;
    }

    public void setSchemaSet(XSSchemaSet schemaSet) {
        this.schemaSet = schemaSet;
    }
}

