/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.schema;

import ch.admin.smclient.model.User;
import ch.admin.smclient.service.repository.FileRepository;
import ch.admin.smclient2.web.application.SmcUserPrincipal;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.parser.AnnotationParserFactory;
import com.sun.xml.xsom.parser.XSOMParser;
import com.sun.xml.xsom.util.DomAnnotationParserFactory;
import jakarta.annotation.PostConstruct;
import jakarta.faces.context.FacesContext;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import lombok.Generated;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.context.annotation.ApplicationScope;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

@Component(value="schemaParser")
@ApplicationScope
public class SchemaParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchemaParser.class);
    public static final String SCHEMA_FILENAME_KEY = "schemaFileName";
    private final Map<String, XSSchemaSet> parsedSchemas = new HashMap();
    @Autowired
    private FileRepository fileRepository;

    @PostConstruct
    public void initProperties() {
        System.setProperty("xml.catalog.ignoreMissing", "true");
    }

    public XSSchemaSet parseSchema(String fileName, File catalog) throws IOException, SAXException {
        System.setProperty("xml.catalog.files", catalog.getAbsolutePath());
        XSOMParser reader = new XSOMParser(SAXParserFactory.newInstance());
        reader.setAnnotationParser((AnnotationParserFactory)new DomAnnotationParserFactory());
        CatalogManager catalogManager = new CatalogManager();
        reader.setEntityResolver((EntityResolver)new CatalogResolver(catalogManager));
        URL schemaLocation = new URL(fileName);
        reader.parse(schemaLocation.openStream());
        return reader.getResult();
    }

    public XSSchemaSet parseSchema(String sedexId, String fileName) {
        XSSchemaSet schema = (XSSchemaSet)this.parsedSchemas.get(fileName);
        if (schema == null) {
            try {
                schema = this.parseSchema(fileName, this.fileRepository.getCatalogWithPublicReferences(sedexId));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.parsedSchemas.put(fileName, schema);
        }
        return schema;
    }

    public XSSchemaSet parseCurrentSchema() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        User user = ((SmcUserPrincipal)authentication.getPrincipal()).getUser();
        String fileName = (String)FacesContext.getCurrentInstance().getExternalContext().getSessionMap().get(SCHEMA_FILENAME_KEY);
        return this.parseSchema(user.getMandantSedexId(), fileName);
    }
}

