/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.schema;

import ch.admin.smclient.service.StatusCode;
import ch.admin.smclient.util.ZipTool;
import ch.admin.smclient2.web.schema.JaxbBindingCompiler;
import ch.admin.smclient2.web.schema.ListClassesCodeWriter;
import ch.admin.smclient2.web.schema.SchemaParser;
import ch.admin.smclient2.web.schema.reflect.InstantiateStrategy;
import ch.admin.smclient2.web.schema.reflect.PropertyIterator;
import ch.admin.smclient2.web.schema.reflect.Strategy;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSSchemaSet;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.MarshalException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEvent;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.util.ValidationEventCollector;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.xerces.util.XMLCatalogResolver;
import org.glassfish.jaxb.core.api.impl.NameConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.annotation.ApplicationScope;
import org.w3c.dom.ls.LSResourceResolver;

@Component
@ApplicationScope
public class ObjectFactory {
    private final Map<String, List<Class<?>>> compiledClasses = new HashMap();
    private final JaxbBindingCompiler bindingCompiler = new JaxbBindingCompiler();
    private final PropertyIterator propertyIterator = new PropertyIterator((Strategy)new InstantiateStrategy());
    private static final String[] ROOT_ELEMENT_FORMSERVICE = new String[]{StatusCode.MessageType.MESSAGE_XML_NAME.getFileNameNoSuffix(), "eventReport"};
    @Autowired
    SchemaParser schemaParser;

    public String toClassName(String targetNamespace, String name) {
        String packageName = NameConverter.standard.toPackageName(targetNamespace);
        return packageName + "." + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public Object createObjectFromSchema(String sedexId, String schema, File catalog) throws Exception {
        XSSchemaSet xss = this.schemaParser.parseSchema(sedexId, schema);
        Iterator decls = xss.iterateElementDecls();
        String className = null;
        while (decls.hasNext()) {
            XSElementDecl decl = (XSElementDecl)decls.next();
            String declName = decl.getName();
            if (!ArrayUtils.contains((Object[])ROOT_ELEMENT_FORMSERVICE, (Object)declName)) continue;
            className = this.toClassName(decl.getTargetNamespace(), declName);
            break;
        }
        Class<?> rootObject = Class.forName(className);
        this.propertyIterator.setSchemaSet(xss);
        Object returnValue = this.propertyIterator.iterate(rootObject);
        return returnValue;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File saveObject(String schema, Object object, File catalog, File catalogWithPublic) throws Exception {
        BufferedOutputStream bos = null;
        File message = null;
        ValidationEventCollector collector = new ValidationEventCollector();
        try {
            message = File.createTempFile("new", ".xml");
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setEventHandler((ValidationEventHandler)collector);
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            XMLCatalogResolver resolver = new XMLCatalogResolver();
            resolver.setCatalogList(new String[]{catalog.toString()});
            resolver.setPreferPublic(true);
            sf.setResourceResolver((LSResourceResolver)resolver);
            Schema schemaObject = sf.newSchema(new URL(schema));
            marshaller.setSchema(schemaObject);
            bos = new BufferedOutputStream(new FileOutputStream(message));
            marshaller.marshal(object, (OutputStream)bos);
        }
        catch (MarshalException e) {
            try {
                StringBuilder errors = new StringBuilder();
                ValidationEvent[] validationEventArray = collector.getEvents();
                int n = validationEventArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        this.closeStreamAndRemoveFile(bos, message);
                        throw new MarshalException(errors.toString(), (Throwable)e);
                    }
                    ValidationEvent event = validationEventArray[n2];
                    errors.append(event.getMessage()).append("\n");
                    ++n2;
                }
                catch (Exception e2) {
                    this.closeStreamAndRemoveFile(bos, message);
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)bos);
        return message;
    }

    private void closeStreamAndRemoveFile(BufferedOutputStream bos, File message) {
        IOUtils.closeQuietly((OutputStream)bos);
        FileUtils.deleteQuietly((File)message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object loadObject(String schema, File zipFile, File catalog) throws Exception {
        Object result = null;
        BufferedInputStream bis = null;
        ZipFile zip = new ZipFile(zipFile);
        try {
            ZipArchiveEntry entry = ZipTool.getZipEntry((File)zipFile, (String)StatusCode.MessageType.MESSAGE_XML_NAME.getFileNameNoSuffix());
            bis = new BufferedInputStream(zip.getInputStream(entry));
            result = this.loadObject(schema, (InputStream)bis, catalog);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bis);
            IOUtils.closeQuietly((Closeable)zip);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)bis);
        IOUtils.closeQuietly((Closeable)zip);
        return result;
    }

    public Object loadObject(String schema, String xml, File catalog) throws Exception {
        return this.loadObject(schema, IOUtils.toInputStream((String)xml, (String)"UTF-8"), catalog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object loadObject(String schema, InputStream inputstream, File catalog) throws Exception {
        Object result = null;
        try {
            List classes = this.getClasses(schema, catalog);
            JAXBContext jc = JAXBContext.newInstance((Class[])classes.toArray(new Class[classes.size()]));
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            result = unmarshaller.unmarshal(inputstream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputstream);
        }
        return result;
    }

    public Class<?> getClassByName(String schemaFileName, String name) {
        for (Class class1 : (List)this.compiledClasses.get(schemaFileName)) {
            if (!class1.getName().equalsIgnoreCase(name)) continue;
            return class1;
        }
        return null;
    }

    public Class<?> getClass(String schemaFileName, Object type) {
        List classes = (List)this.compiledClasses.get(schemaFileName);
        for (Class class1 : classes) {
            if (!class1.getName().equals(type)) continue;
            return class1;
        }
        return null;
    }

    private List<Class<?>> getClasses(String schema, File catalog) throws IOException, MalformedURLException {
        List classes = (List)this.compiledClasses.get(schema);
        if (classes == null) {
            URL schemaLocation = new URL(schema);
            InputStream reader = schemaLocation.openStream();
            ListClassesCodeWriter bindings = this.bindingCompiler.generateJavaBindingsFromXsd((Reader)new InputStreamReader(reader), catalog);
            classes = bindings.getClasses();
            this.compiledClasses.put(schema, classes);
        }
        return classes;
    }
}

