/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.schema;

import ch.admin.smclient2.web.schema.RewindableStringReader;
import java.io.IOException;
import java.io.Reader;

public class CachingRewindableReader
extends Reader {
    private Reader source;
    private boolean sourceClosed;
    private RewindableStringReader cache;
    private StringBuilder strBuilder;

    public CachingRewindableReader(Reader source) {
        this.source = source;
        this.strBuilder = new StringBuilder();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int value = 0;
        if (this.cache == null) {
            value = this.source.read(cbuf, off, len);
            if (value != -1) {
                this.strBuilder.append(cbuf, off, value);
            } else {
                this.cache = new RewindableStringReader(this.strBuilder.toString());
            }
        } else {
            value = this.cache.read(cbuf, off, len);
        }
        return value;
    }

    @Override
    public void close() throws IOException {
        if (!this.sourceClosed) {
            this.source.close();
            this.sourceClosed = true;
        }
        if (this.cache == null) {
            this.cache = new RewindableStringReader(this.strBuilder.toString());
        } else {
            this.cache.reset();
        }
    }
}

