/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.mailbox;

import ch.admin.smclient.model.Message;
import ch.admin.smclient.model.validate.message.MessageDefinition;
import ch.admin.smclient.service.DomainParameters;
import ch.admin.smclient.service.ElmMessageProducer;
import ch.admin.smclient.service.MessageHandler;
import ch.admin.smclient.service.MessageParser;
import ch.admin.smclient.service.PdfRenderer;
import ch.admin.smclient.service.StatusCode;
import ch.admin.smclient.service.exceptions.MessageTooBigException;
import ch.admin.smclient.service.postfach.MailboxService;
import ch.admin.smclient.service.repository.FileRepository;
import ch.admin.smclient.util.MimeTypeUtil;
import ch.admin.smclient.util.ZipTool;
import ch.admin.smclient2.web.compatibility.AppMessages;
import ch.admin.smclient2.web.compatibility.CurrentUserBean;
import ch.admin.smclient2.web.compatibility.SmClientBundle;
import ch.admin.smclient2.web.mailbox.FailedFile;
import ch.admin.smclient2.web.mailbox.MailboxListMessagesBean;
import ch.admin.smclient2.web.mailbox.TreeElement;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import lombok.Generated;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.primefaces.model.DefaultStreamedContent;
import org.primefaces.model.StreamedContent;
import org.primefaces.util.Callbacks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Scope(value="session")
public class ViewHeaderBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ViewHeaderBean.class);
    @Autowired
    private MailboxService mailboxService;
    @Autowired
    private MessageHandler messageHandler;
    @Autowired
    private AppMessages appMessages;
    @Autowired
    FileRepository fileRepository;
    @Autowired
    PdfRenderer pdfRenderer;
    @Autowired
    private MailboxListMessagesBean mailboxListMessagesBean;
    private List<TreeElement> headerFields;
    private List<TreeElement> messageFields;
    private List<String> attachFiles;
    private String receipt;
    private boolean showMessageFields = false;
    private String sedexReceipt;
    private Message currentMessage;
    private List<String> listHeaderFields = Arrays.asList("/DeclareSalaryConsumer/DistributorRequestContext", "/envelope", "/GetResultFromDeclareSalaryConsumerResponse/ConsumerResponseContext");
    private List<String> listabeFields = Arrays.asList("/DeclareSalaryConsumer/DeclareSalary", "/GetResultFromDeclareSalaryConsumerResponse/GetResultFromDeclareSalaryResponse");
    @Autowired
    private CurrentUserBean currentUserBean;

    public String evaluateHeaderFields(Message msg, boolean fromDB) {
        this.currentMessage = msg;
        String success = "/outlook/viewmsgheader.xhtml?faces-redirect=true";
        try {
            Document xmlDoc;
            long printMessageSmaller;
            long messageSize;
            File messageFile = new File(this.currentMessage.getFolder(), this.currentMessage.getFileName());
            log.debug("read header of: {0} ", (Object)messageFile);
            this.headerFields = new ArrayList();
            this.messageFields = new ArrayList();
            if (this.showMessageFields && this.isZipFile(messageFile) && (messageSize = ZipTool.getEntrySize((File)messageFile, (String)StatusCode.MessageType.MESSAGE_XML_NAME.getFileNameNoSuffix())) > (printMessageSmaller = this.pdfRenderer.getPrintMessageSmaller(this.currentMessage.getMandant().getSedexId()))) {
                File messageLocation = this.currentMessage.getMessageLocation();
                String format = String.format("%1$s is bigger (%2$d) than the configured size (%3$d) for printing and viewing", messageLocation, messageSize, printMessageSmaller);
                MessageTooBigException e = new MessageTooBigException(format, new Object[]{messageLocation.getName(), messageSize, printMessageSmaller});
                this.showMessageFields = false;
            }
            if (!this.isElm()) {
                xmlDoc = this.messageHandler.parseMessageToDocument(messageFile, this.showMessageFields);
                this.attachFiles = ZipTool.getAttachmentEntries((File)messageFile);
                this.receipt = ZipTool.getEntry((File)messageFile, (String)".zip");
            } else {
                xmlDoc = !this.isZipFile(messageFile) ? this.messageHandler.parseMessageXmlToDocument(messageFile, this.showMessageFields) : ElmMessageProducer.parseMessageFromZipFile((File)messageFile, (boolean)this.showMessageFields);
            }
            this.currentMessage.setParsedDocument(xmlDoc);
            if (!this.isElm()) {
                Iterator eIterator = xmlDoc.getRootElement().elementIterator();
                Element currentElem = (Element)eIterator.next();
                this.fillFieldsList(currentElem, this.headerFields, 0);
                if (this.showMessageFields) {
                    currentElem = eIterator.hasNext() ? (Element)eIterator.next() : null;
                    this.fillFieldsList(currentElem, this.messageFields, 0);
                }
            } else {
                ViewHeaderBean.removeAllNamespaces((Document)xmlDoc);
                this.fillFieldsList(xmlDoc, this.listHeaderFields, this.headerFields, 0);
                if (this.showMessageFields) {
                    this.fillFieldsList(xmlDoc, this.listabeFields, this.messageFields, 0);
                }
            }
            if (this.isZipFile(messageFile)) {
                this.sedexReceipt = ZipTool.getEntry((File)messageFile, (String)"receipt");
            }
            if (this.sedexReceipt == null && this.isZipFile(messageFile)) {
                this.sedexReceipt = ZipTool.getEntry((File)messageFile, (String)"Receipt");
            }
            if (fromDB) {
                this.mailboxService.markRead(msg, true);
            }
        }
        catch (Exception ex) {
            log.warn("w-0210 | Unable to view message {1} (id: {0})", new Object[]{ex, msg.getId(), msg.getMessageId()});
            return "listmessages?faces-redirect=true";
        }
        return success;
    }

    public String evaluateHeaderFields(Message msg) {
        return this.evaluateHeaderFields(msg, true);
    }

    public String evaluateHeaderFields(FailedFile file) {
        return this.evaluateHeaderFields(new File(file.getFullname()));
    }

    public String evaluateHeaderFields(File msg) {
        Message message = null;
        String logMessage = "w-0210 | Unable to view message {1}";
        String logBundleKey = "viewmsgheader.messageDeleted";
        try {
            message = this.messageHandler.parseMessage(msg, DomainParameters.ELM.getReceiveProcessName());
        }
        catch (Exception e) {
            this.logWarningException(e, logMessage, logBundleKey, new Object[]{msg});
        }
        if (message == null) {
            this.logWarningException(null, logMessage, logBundleKey, new Object[]{msg});
            this.currentMessage = new Message(msg);
            return this.backToMailBox();
        }
        return this.evaluateHeaderFields(message, false);
    }

    public boolean isElm() {
        return this.currentMessage != null && this.currentMessage.getMessageType().equalsIgnoreCase("elm");
    }

    public boolean checkAttachmentFile(String filename) throws UnsupportedEncodingException {
        if (StringUtils.isBlank((CharSequence)filename) || this.attachFiles == null) {
            return false;
        }
        String filenameUTF8 = new String(filename.getBytes("UTF8"), "UTF8");
        return this.attachFiles.contains(filenameUTF8);
    }

    public static void removeAllNamespaces(Document doc) {
        Element root = doc.getRootElement();
        if (root.getNamespace() != Namespace.NO_NAMESPACE) {
            ViewHeaderBean.removeNamespaces((List)root.content());
        }
    }

    public boolean hasSpecialistAnswer() {
        String messageType = this.currentMessage.getMessageType();
        String subMessageType = this.currentMessage.getSubMessageType();
        String sedexId = this.currentUserBean.getUser().getMandantSedexId();
        boolean result = true;
        try {
            MessageDefinition definition = this.fileRepository.getMessageDefinition(sedexId, messageType, subMessageType);
            if (definition == null) {
                log.debug("could not find definition for {0}-{1} in mandant {2}", new Object[]{messageType, subMessageType, sedexId});
                return false;
            }
            String domain = definition.getDomain();
            if (domain != null) {
                DomainParameters domainParameters = DomainParameters.valueOfName((String)domain);
                result = domainParameters.hasSpecialistAnswer();
            }
        }
        catch (Exception e) {
            log.debug("can't read message definitions", (Throwable)e);
        }
        return result;
    }

    public boolean hasFoXsltFile() {
        if (this.currentMessage.getMandant() != null) {
            return this.mailboxService.hasFoXsltFile(this.currentMessage, this.currentUserBean.getUser());
        }
        return false;
    }

    public boolean hasCsvXsltFile() {
        if (this.currentMessage.getMandant() != null) {
            return this.mailboxService.hasCsvXsltFile(this.currentMessage, this.currentUserBean.getUser());
        }
        return false;
    }

    public static void unfixNamespaces(Document doc, Namespace original) {
        Element root = doc.getRootElement();
        if (original != null) {
            ViewHeaderBean.setNamespaces((List)root.content(), (Namespace)original);
        }
    }

    public static void setNamespace(Element elem, Namespace ns) {
        elem.setQName(QName.get((String)elem.getName(), (Namespace)ns, (String)elem.getQualifiedName()));
    }

    public static void removeNamespaces(Element elem) {
        ViewHeaderBean.setNamespaces((Element)elem, (Namespace)Namespace.NO_NAMESPACE);
    }

    public static void removeNamespaces(List l) {
        ViewHeaderBean.setNamespaces((List)l, (Namespace)Namespace.NO_NAMESPACE);
    }

    public static void setNamespaces(Element elem, Namespace ns) {
        ViewHeaderBean.setNamespace((Element)elem, (Namespace)ns);
        ViewHeaderBean.setNamespaces((List)elem.content(), (Namespace)ns);
    }

    public static void setNamespaces(List l, Namespace ns) {
        Node n = null;
        for (int i = 0; i < l.size(); ++i) {
            n = (Node)l.get(i);
            if (n.getNodeType() == 2) {
                ((Attribute)n).setNamespace(ns);
            }
            if (n.getNodeType() != 1) continue;
            ViewHeaderBean.setNamespaces((Element)((Element)n), (Namespace)ns);
        }
    }

    public String backToMailBox() {
        String folder = String.valueOf(this.mailboxListMessagesBean.getCurrentFolder());
        if (this.currentMessage.getId() != null) {
            return "/outlook/listmessages?folder=" + folder + "&faces-redirect=true";
        }
        return "/outlook/listfilemessages?folder=" + folder + "&faces-redirect=true";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamedContent uploadAttachment(String entry) {
        block7: {
            StreamedContent streamedContent;
            ZipFile zip = null;
            try {
                File messageFile = new File(this.currentMessage.getFolder(), this.currentMessage.getFileName());
                log.debug("uploading entry name {1} from file {0}", (Object)messageFile.getAbsolutePath(), (Object)entry);
                zip = new ZipFile(messageFile);
                Enumeration entries = zip.getEntries();
                while (entries.hasMoreElements()) {
                    ZipArchiveEntry entry1 = (ZipArchiveEntry)entries.nextElement();
                    if (!entry1.getName().equals(entry)) continue;
                    InputStream is = zip.getInputStream(entry1);
                    File temp = File.createTempFile("smclient-download-", "");
                    Files.copy(is, temp.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    FileInputStream downloadInputStream = new FileInputStream(temp.getAbsolutePath());
                    String mimeType = MimeTypeUtil.getMostSpecificMimeType((String)entry1.getName(), (boolean)false);
                    DefaultStreamedContent defaultStreamedContent = DefaultStreamedContent.builder().name(FilenameUtils.getName((String)entry1.getName())).contentType(mimeType).stream((Callbacks.SerializableSupplier & Serializable)() -> downloadInputStream).build();
                    ZipFile.closeQuietly((ZipFile)zip);
                    return defaultStreamedContent;
                }
                streamedContent = null;
                ZipFile.closeQuietly((ZipFile)zip);
            }
            catch (Exception ex) {
                log.warn("w-0211 | Unable to upload file", (Throwable)ex);
                break block7;
            }
            finally {
                ZipFile.closeQuietly(zip);
            }
            return streamedContent;
        }
        return null;
    }

    public String getValueFromBundle(TreeElement element) {
        String prefix = this.currentMessage.getVersionSuffix(element.getElement());
        try {
            String key = prefix + "|" + element.getName() + "." + element.getValue();
            return SmClientBundle.getBundle().getString(key);
        }
        catch (MissingResourceException e) {
            return element.getValue();
        }
    }

    public void setShowMessageFields(boolean showMessageFields) {
        this.showMessageFields = showMessageFields;
        if (showMessageFields) {
            this.evaluateHeaderFields(this.currentMessage);
        }
    }

    void fillFieldsList(Element element, List<TreeElement> list, int level) {
        if (element != null) {
            String name = element.getName();
            String value = (String)element.getData();
            if (level != 0) {
                list.add(new TreeElement(level, level * 1000, name, value, element));
            }
            Iterator it = element.elementIterator();
            while (it.hasNext()) {
                Element currentElement = (Element)it.next();
                if (!currentElement.hasContent()) continue;
                this.fillFieldsList(currentElement, list, level + 1);
            }
        }
    }

    void fillFieldsList(Document doc, List<String> fieldsNameList, List<TreeElement> list, int level) {
        for (String field : fieldsNameList) {
            List nodes = MessageParser.findNodes((Element)doc.getRootElement(), (String)field);
            if (nodes.size() == 1 && ((Element)nodes.get(0)).isTextOnly()) {
                Element node = (Element)nodes.get(0);
                list.add(new TreeElement(1, 1000, field.substring(field.lastIndexOf(47) + 1), node.getText(), node));
                continue;
            }
            for (Element node : nodes) {
                this.fillFieldsList(node, list, level + 1);
            }
        }
    }

    private void logWarningException(Exception e, String message, String bundleKey, Object ... params) {
        log.warn(message, (Object)e, (Object)params);
    }

    private boolean isZipFile(File messageFile) {
        return messageFile != null && FilenameUtils.getExtension((String)messageFile.getName()).contains("zip");
    }

    @Generated
    public List<TreeElement> getHeaderFields() {
        return this.headerFields;
    }

    @Generated
    public List<TreeElement> getMessageFields() {
        return this.messageFields;
    }

    @Generated
    public List<String> getAttachFiles() {
        return this.attachFiles;
    }

    @Generated
    public void setAttachFiles(List<String> attachFiles) {
        this.attachFiles = attachFiles;
    }

    @Generated
    public String getReceipt() {
        return this.receipt;
    }

    @Generated
    public void setReceipt(String receipt) {
        this.receipt = receipt;
    }

    @Generated
    public boolean isShowMessageFields() {
        return this.showMessageFields;
    }

    @Generated
    public String getSedexReceipt() {
        return this.sedexReceipt;
    }

    @Generated
    public void setSedexReceipt(String sedexReceipt) {
        this.sedexReceipt = sedexReceipt;
    }

    @Generated
    public Message getCurrentMessage() {
        return this.currentMessage;
    }

    @Generated
    public void setCurrentMessage(Message currentMessage) {
        this.currentMessage = currentMessage;
    }
}

