/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.mailbox;

import ch.admin.smclient.model.validate.message.MessageDefinition;
import ch.admin.smclient.service.DomainParameters;
import ch.admin.smclient2.web.compatibility.SmClientBundle;
import java.util.MissingResourceException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class MessageType {
    private String type;
    private String subType;
    private String name;
    private String viewName;
    private String domain = DomainParameters.STANDARD.getName();
    public static final String DEFAULT_VIEW = "compose-form.xhtml";

    public MessageType(MessageDefinition message) {
        this(message.getName(), message.getType(), message.getSubtype());
        if (StringUtils.isNotBlank((CharSequence)message.getCustomViewName())) {
            this.setViewName(message.getCustomViewName());
        }
        this.domain = message.hasDomainOnVersion() ? message.getCurrentVersion().getDomain() : message.getDomain();
    }

    public MessageType(String name, String type, String subType, String viewName) {
        this.type = type;
        this.name = name;
        this.subType = subType;
        this.viewName = viewName;
    }

    public MessageType(String name, String type, String subType) {
        this(name, type, subType, DEFAULT_VIEW);
    }

    public String getId() {
        return this.type + " " + this.subType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getBundleName() {
        return this.getBundleName(this.name);
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    String getBundleName(String key) {
        String bundleName;
        try {
            bundleName = SmClientBundle.getBundle().getString(key);
        }
        catch (MissingResourceException e) {
            bundleName = key;
        }
        return bundleName;
    }

    public String toString() {
        return String.format("MessageType [type=%s, subType=%s]", this.type, this.subType);
    }

    @Generated
    public String getDomain() {
        return this.domain;
    }
}

