/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.mailbox;

import ch.admin.smclient.model.Domain;
import ch.admin.smclient.service.DomainParameters;
import ch.admin.smclient.service.StatusCode;
import ch.admin.smclient.service.repository.DirectoryRepository;
import ch.admin.smclient.service.repository.FileRepository;
import ch.admin.smclient.util.ZipTool;
import ch.admin.smclient2.web.mailbox.Attachment;
import ch.admin.smclient2.web.mailbox.FileUpload;
import ch.admin.smclient2.web.mailbox.ZipMessageInfo;
import ch.admin.smclient2.web.schema.ObjectFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MessageFileProducer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageFileProducer.class);
    public static final String ECH0058V4_SUFFIX = "_000001";
    @Autowired
    FileRepository fileRepository;
    @Autowired
    ObjectFactory objectFactory;
    @Autowired
    DirectoryRepository directoryRepository;

    public void createZipMessage(String sedexId, ZipMessageInfo zipInfo) throws Exception {
        this.createZipMessage(sedexId, zipInfo, null);
    }

    public void createZipMessage(String sedexId, ZipMessageInfo zipInfo, Domain domain) throws Exception {
        File message = this.objectFactory.saveObject(zipInfo.getSchema(), zipInfo.getMessageObject(), this.getCatalogFile(sedexId), this.getCatalogWithPubllicRefrences(sedexId));
        File zipFile = this.createZipFile(message, zipInfo);
        File dest = this.directoryRepository.getSmclientOutbox(sedexId, domain);
        FileUtils.moveFileToDirectory((File)zipFile, (File)dest, (boolean)false);
    }

    private File getCatalogFile(String sedexId) throws IOException {
        return this.fileRepository.getCatalogXml(sedexId);
    }

    private File getCatalogWithPubllicRefrences(String sedexId) throws IOException {
        return this.fileRepository.getCatalogWithPublicReferences(sedexId);
    }

    String getSuffix(ZipMessageInfo zipInfo) {
        if (DomainParameters.ECH0058V4.getName().equals(zipInfo.getDomain())) {
            return ECH0058V4_SUFFIX;
        }
        return "";
    }

    private File createZipFile(File message, ZipMessageInfo zipInfo) throws IOException {
        String newFileName;
        List filesInZip;
        File tmp;
        File answerFolder = zipInfo.getAnswerFolder();
        if (answerFolder != null && answerFolder.exists()) {
            tmp = answerFolder;
            filesInZip = this.listAttachmentsFile(answerFolder);
            File fileToBeReplaced = this.getFirstFile(tmp, StatusCode.MessageType.MESSAGE_XML_NAME);
            newFileName = fileToBeReplaced.getName();
            FileUtils.forceDelete((File)fileToBeReplaced);
        } else {
            tmp = ZipTool.createTempDir((String)"toSent");
            filesInZip = this.moveAttachments(tmp, zipInfo);
            newFileName = StatusCode.MessageType.MESSAGE_XML_NAME.getFileName(this.getSuffix(zipInfo));
        }
        File newLocation = new File(tmp, newFileName);
        FileUtils.moveFile((File)message, (File)newLocation);
        String messageZipName = FilenameUtils.removeExtension((String)message.getName()) + ".zip";
        filesInZip.add(newLocation);
        File zipFile = new File(tmp.getParent(), messageZipName);
        ZipTool.createZipFile((File)zipFile, (Collection)filesInZip, (String)tmp.getAbsolutePath());
        FileUtils.deleteDirectory((File)tmp);
        return zipFile;
    }

    private List<File> listAttachmentsFile(File answerFolder) throws IOException {
        try (Stream<Path> pathStream = Files.walk(answerFolder.toPath(), new FileVisitOption[0]);){
            List list = pathStream.filter(p -> Files.isRegularFile(p, new LinkOption[0])).filter(p -> p.toString().contains("attachments")).map(Path::toFile).collect(Collectors.toCollection(ArrayList::new));
            return list;
        }
    }

    private File getFirstFile(File directory, StatusCode.MessageType type) {
        Collection files = FileUtils.listFiles((File)directory, (IOFileFilter)FileFilterUtils.prefixFileFilter((String)type.getFileNameNoSuffix()), null);
        return (File)files.iterator().next();
    }

    private List<File> moveAttachments(File folder, ZipMessageInfo zipInfo) throws IOException {
        ArrayList<File> filesInZip = new ArrayList<File>();
        File attachments = new File(folder, "attachments" + this.getSuffix(zipInfo));
        attachments.mkdir();
        for (Attachment attachment : zipInfo.getAttachments()) {
            for (FileUpload upload : attachment.getFiles()) {
                File attachmentFile;
                block5: {
                    String attachmentName = upload.getName();
                    if (!StringUtils.isNotBlank((CharSequence)attachmentName)) continue;
                    attachmentFile = new File(attachments, attachmentName);
                    FileUtils.copyFile((File)upload.getFile(), (File)attachmentFile);
                    if (!FileUtils.deleteQuietly((File)upload.getFile())) {
                        try {
                            FileUtils.forceDelete((File)upload.getFile());
                        }
                        catch (Exception e) {
                            log.info("Unable to delete temp file {0}", (Object)e, (Object)upload.getFile());
                            if (!upload.getFile().exists()) break block5;
                            upload.getFile().deleteOnExit();
                        }
                    }
                }
                filesInZip.add(attachmentFile);
            }
        }
        return filesInZip;
    }
}

