/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.mailbox;

import ch.admin.smclient.model.Domain;
import ch.admin.smclient.model.Message;
import ch.admin.smclient.service.CsvRenderer;
import ch.admin.smclient.service.DomainParameters;
import ch.admin.smclient.service.DomainRepository;
import ch.admin.smclient.service.exceptions.SmClientApplicationException;
import ch.admin.smclient.service.postfach.MailboxFolder;
import ch.admin.smclient.service.postfach.MailboxService;
import ch.admin.smclient.util.MimeTypeUtil;
import ch.admin.smclient.util.ZipTool;
import ch.admin.smclient2.web.compatibility.AppMessages;
import ch.admin.smclient2.web.compatibility.CurrentUserBean;
import ch.admin.smclient2.web.compatibility.SmClientBundle;
import ch.admin.smclient2.web.mailbox.FailedFile;
import ch.admin.smclient2.web.mailbox.FiledsHelper;
import ch.admin.smclient2.web.mailbox.MailboxListMessagesBean;
import eu.medsea.mimeutil.MimeUtil2;
import jakarta.faces.model.SelectItem;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.primefaces.model.DefaultStreamedContent;
import org.primefaces.model.StreamedContent;
import org.primefaces.util.Callbacks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Scope(value="session")
public class MailboxListMessagesBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MailboxListMessagesBean.class);
    private static final long serialVersionUID = 1L;
    @Autowired
    private AppMessages appMessages;
    @Autowired
    private MailboxService mailboxService;
    private String filterSubjectValue;
    private String filterSenderIdValue;
    private String filterRecipientIdValue;
    private String filterMsgType;
    private String filterMessageIdValue;
    private MailboxFolder currentFolder = MailboxFolder.INBOX;
    private List<Message> selectedMessages;
    private List<Message> messageList;
    private MailboxFolder messageFolder;
    private Collection<FailedFile> fileMessageList;
    private int rowsPerPage = 10;
    private boolean dirty = true;
    private Boolean filterMessageRead;
    private String filterImportant = "";
    private String orderBy = "receivedDate";
    private boolean isAccending = false;
    private FiledsHelper.DateInterval receivedAgo = FiledsHelper.DateInterval.ALL;
    @Autowired
    private DomainRepository domainRepository;
    @Autowired
    private CurrentUserBean currentUserBean;

    public SelectItem[] getReceivedAgoValues() {
        return new SelectItem[]{new SelectItem((Object)FiledsHelper.DateInterval.ALL, SmClientBundle.getBundle().getString("listmsgs.select.all")), new SelectItem((Object)FiledsHelper.DateInterval.DAY, SmClientBundle.getBundle().getString("listmsgs.select.day")), new SelectItem((Object)FiledsHelper.DateInterval.WEEK, SmClientBundle.getBundle().getString("listmsgs.select.week")), new SelectItem((Object)FiledsHelper.DateInterval.WEEK2, SmClientBundle.getBundle().getString("listmsgs.select.2weeks")), new SelectItem((Object)FiledsHelper.DateInterval.MONTH, SmClientBundle.getBundle().getString("listmsgs.select.month")), new SelectItem((Object)FiledsHelper.DateInterval.YEAR, SmClientBundle.getBundle().getString("listmsgs.select.year"))};
    }

    public static Date getBackTime(FiledsHelper.DateInterval interval) {
        Calendar cal = GregorianCalendar.getInstance();
        switch (2.$SwitchMap$ch$admin$smclient2$web$mailbox$FiledsHelper$DateInterval[interval.ordinal()]) {
            case 1: {
                cal.add(6, -1);
                break;
            }
            case 2: {
                cal.add(3, -1);
                break;
            }
            case 3: {
                cal.add(3, -2);
                break;
            }
            case 4: {
                cal.add(2, -1);
                break;
            }
            case 5: {
                cal.add(1, -1);
                break;
            }
            default: {
                cal.add(1, -100);
            }
        }
        return cal.getTime();
    }

    public Collection<FailedFile> getFileMessageList() {
        if (this.fileMessageList != null) {
            return this.fileMessageList;
        }
        return this.refreshFileList();
    }

    public Collection<FailedFile> refreshFileList() {
        Domain domain = this.domainRepository.findByName(DomainParameters.ELM.getName());
        File directory = this.mailboxService.getDirLocation(this.currentUserBean.getMandantSedexId(), this.currentFolder.getLocationKey(), domain);
        if (directory == null || !directory.exists()) {
            log.error("Directory {0} ({1}) does not exist for mandant {2}.", new Object[]{directory, this.currentFolder.getLocationKey(), this.currentUserBean.getMandantSedexId()});
        }
        this.fileMessageList = this.mailboxService.getFileMessageList(this.currentFolder, this.currentUserBean.getMandantSedexId()).stream().map(file -> new FailedFile(file.getName(), file.getAbsolutePath(), new Date(file.lastModified()), file.lastModified())).collect(Collectors.toList());
        return this.fileMessageList;
    }

    public boolean filterLastModified(Object current) {
        FailedFile currentFile = (FailedFile)current;
        Date backTime = MailboxListMessagesBean.getBackTime((FiledsHelper.DateInterval)this.receivedAgo);
        return currentFile.getLastModified() > backTime.getTime();
    }

    public List<Message> getMessageList() {
        if (this.messageFolder != null && this.currentFolder == this.messageFolder) {
            return this.messageList;
        }
        return this.refresh();
    }

    public List<String> getMessageTypes() {
        if (this.messageList != null) {
            return this.messageList.stream().map(mt -> mt.getMessageType() + " " + mt.getSubMessageType()).distinct().toList();
        }
        return List.of();
    }

    public List<Message> refresh() {
        this.messageFolder = this.currentFolder;
        if (this.selectedMessages != null) {
            this.selectedMessages.clear();
        }
        File location = this.mailboxService.getDirLocation(this.currentUserBean.getMandantSedexId(), this.currentFolder.getLocationKey());
        this.messageList = this.mailboxService.selectMessagesByMailbox2(this.currentUserBean.getMandantSedexId(), location.getAbsolutePath());
        if (this.currentFolder.equals((Object)MailboxFolder.INBOX_IMPORTANT)) {
            this.messageList = this.messageList.stream().filter(Message::isHighPriority).collect(Collectors.toList());
        } else if (this.currentFolder.equals((Object)MailboxFolder.INBOX_READ)) {
            this.messageList = this.messageList.stream().filter(Message::getMessageRead).collect(Collectors.toList());
        } else if (this.currentFolder.equals((Object)MailboxFolder.INBOX_UNREAD)) {
            this.messageList = this.messageList.stream().filter(m -> m.getMessageRead() == false).collect(Collectors.toList());
        }
        return this.messageList;
    }

    public boolean filterByLastModified(Object value, Object filter, Locale lang) {
        if (value instanceof FailedFile) {
            FailedFile file = (FailedFile)value;
            return true;
        }
        return false;
    }

    public String exportMessage(Message msg) {
        log.debug("Exporting messageId {1} (id: {0})", (Object)msg.getId(), (Object)msg.getMessageId());
        try {
            this.mailboxService.exportMessage(msg, this.currentUserBean.getDefaultLanguage(), true);
        }
        catch (SmClientApplicationException e) {
            if (e.getBundleKey() != null) {
                log.warn("w-0201 | Can't export message {1} (id: {0})", new Object[]{e, msg.getId(), msg.getMessageId()});
            } else {
                this.logException("error.listmsg.export", msg, (Exception)((Object)e));
            }
        }
        catch (Exception ex) {
            this.logException("error.listmsg.export", msg, ex);
        }
        this.refresh();
        return "delete_msg";
    }

    public String exportCsvMessage(Message msg) {
        log.debug("Export message as CSV {1} (id: {0})", (Object)msg.getId(), (Object)msg.getMessageId());
        File renderedCsv = null;
        StreamedContent bio = null;
        try {
            renderedCsv = this.mailboxService.generateCsv(msg, this.currentUserBean.getDefaultLanguage());
            if (renderedCsv.isDirectory()) {
                Collection csvs = FileUtils.listFiles((File)renderedCsv, (String[])new String[]{"csv"}, (boolean)false);
                renderedCsv = csvs.size() > 1 ? CsvRenderer.mergeFiles((File)renderedCsv, (String)"csvmessage.csv", (Collection)csvs) : (File)CollectionUtils.get((Object)csvs, (int)0);
            }
            bio = this.downloadFileToBrowser(renderedCsv);
            this.mailboxService.moveMessage(msg, MailboxFolder.DELETED, Message.MessageState.EXPORT);
        }
        catch (SmClientApplicationException e) {
            log.warn("w-0205 | Can't export message as Csv {0}", (Object)e, (Object)msg.getMessageId());
            if (e.getBundleKey() == null) {
                this.logException("error.listmsg.export", msg, (Exception)((Object)e));
            }
        }
        catch (Exception ex) {
            this.logException("error.listmsg.export", msg, ex);
        }
        this.refresh();
        return "delete_msg";
    }

    public String deleteMessage(Message msg) {
        log.debug("Loading message for delete", (Object)msg.getMessageId());
        try {
            this.mailboxService.moveMessage(msg, MailboxFolder.DELETED, Message.MessageState.DELETE);
        }
        catch (Exception ex) {
            log.warn("w-0213 |Unable to delete message {0} may be already was deleted by another user", (Object)msg.getMessageId());
            log.debug("w-0213 |Unable to delete message {0} may be already was deleted by another user", (Object)ex, (Object)msg.getMessageId());
        }
        this.refresh();
        return "delete_msg";
    }

    public StreamedContent printSingleMessage(Message msg) {
        log.debug("Printing message {1} (id: {0})", (Object)msg.getId(), (Object)msg.getMessageId());
        File renderedPdf = null;
        StreamedContent content = null;
        try {
            renderedPdf = this.mailboxService.generatePdfToPrint(msg, this.currentUserBean.getDefaultLanguage());
            content = this.downloadFileToBrowser(renderedPdf);
            this.mailboxService.moveMessage(msg, MailboxFolder.DELETED, Message.MessageState.PRINT);
        }
        catch (SmClientApplicationException e) {
            log.warn("w-0205 | Can't print message {0}", (Object)e, (Object)msg.getMessageId());
            if (e.getBundleKey() != null) {
                this.appMessages.addError("error", e.getBundleKey(), new String[]{msg.getSubject()});
            } else {
                this.logException("error.listmsg.print", msg, (Exception)((Object)e));
            }
        }
        catch (Exception ex) {
            this.logException("error.listmsg.print", msg, ex);
        }
        this.refresh();
        return content;
    }

    public StreamedContent downloadFileToBrowser(File fileToUpload) throws IOException {
        String mimeType = MimeTypeUtil.getMostSpecificMimeType((String)fileToUpload.getName());
        if (StringUtils.isBlank((CharSequence)mimeType)) {
            mimeType = MimeUtil2.UNKNOWN_MIME_TYPE.toString();
        }
        DefaultStreamedContent file = DefaultStreamedContent.builder().name(fileToUpload.getName()).contentType(mimeType).stream((Callbacks.SerializableSupplier & Serializable)() -> {
            try {
                return new /* Unavailable Anonymous Inner Class!! */;
            }
            catch (FileNotFoundException e) {
                log.debug("The file to download disappeared", (Throwable)e);
                return null;
            }
        }).build();
        return file;
    }

    public boolean isInboxFolder() {
        return this.currentFolder == MailboxFolder.INBOX || this.currentFolder == MailboxFolder.INBOX_IMPORTANT || this.currentFolder == MailboxFolder.INBOX_UNREAD || this.currentFolder == MailboxFolder.INBOX_READ;
    }

    public boolean isButtonsDisplayed() {
        return this.isInboxFolder() || this.currentFolder == MailboxFolder.FAILED_TO_SEND || this.currentFolder == MailboxFolder.FAILED_TO_TRANSMIT;
    }

    public boolean isGroupedMessage(Message msg) {
        if (msg.getGroupedMessage() == null) {
            File messageLocation = msg.getMessageLocation();
            msg.setGroupedMessage(Boolean.valueOf(ZipTool.isGroupedMessage((File)messageLocation)));
        }
        return msg.getGroupedMessage();
    }

    public boolean hasFoXsltFile(Message currentMessage) {
        return this.mailboxService.hasFoXsltFile(currentMessage, this.currentUserBean.getUser());
    }

    public boolean hasCsvXsltFile(Message currentMessage) {
        return this.mailboxService.hasCsvXsltFile(currentMessage, this.currentUserBean.getUser());
    }

    public MailboxFolder getCurrentFolder() {
        return this.currentFolder;
    }

    public void setCurrentFolder(MailboxFolder currentFolder) {
        this.filterSubjectValue = "";
        this.filterSenderIdValue = "";
        this.filterRecipientIdValue = "";
        this.filterMsgType = "";
        this.filterMessageIdValue = "";
        this.receivedAgo = FiledsHelper.DateInterval.ALL;
        this.currentFolder = currentFolder;
        this.dirty = true;
        this.filterMessageRead = null;
        this.filterImportant = "";
        if (currentFolder != null) {
            switch (2.$SwitchMap$ch$admin$smclient$service$postfach$MailboxFolder[currentFolder.ordinal()]) {
                case 1: {
                    this.filterMessageRead = false;
                    break;
                }
                case 2: {
                    this.filterImportant = String.valueOf(1);
                    break;
                }
                case 3: {
                    this.filterMessageRead = true;
                    break;
                }
                case 4: {
                    break;
                }
            }
        }
    }

    public Date getLastMessageChange(Message msg) {
        return this.mailboxService.getLastMessageChange(msg.getId());
    }

    public int getNumberOfColumns() {
        if (this.isInboxFolder() || this.currentFolder == MailboxFolder.FAILED_TO_SEND || this.currentFolder == MailboxFolder.FAILED_TO_TRANSMIT) {
            return 6;
        }
        if (this.currentFolder == MailboxFolder.DELETED) {
            return 7;
        }
        if (this.currentFolder == MailboxFolder.FAILED_TO_RECEIVE) {
            return 2;
        }
        if (this.currentFolder == null) {
            return 9;
        }
        return 5;
    }

    public boolean isBoxEmpty() {
        return this.currentFolder != MailboxFolder.FAILED_TO_RECEIVE || this.fileMessageList == null || this.fileMessageList.size() <= 0;
    }

    public void setFilterSubjectValue(String filterSubjectValue) {
        this.filterSubjectValue = filterSubjectValue;
        this.dirty = true;
    }

    public void setFilterSenderIdValue(String filterSenderIdValue) {
        this.filterSenderIdValue = filterSenderIdValue;
        this.dirty = true;
    }

    public void setFilterRecipientIdValue(String filterRecipientIdValue) {
        this.filterRecipientIdValue = filterRecipientIdValue;
        this.dirty = true;
    }

    public void setFilterMsgType(String filterMsgType) {
        this.filterMsgType = filterMsgType;
        this.dirty = true;
    }

    public void setFilterMessageIdValue(String filterMessageIdValue) {
        this.filterMessageIdValue = filterMessageIdValue;
        this.dirty = true;
    }

    public void setRowsPerPage(int rowsPerPage) {
        this.rowsPerPage = rowsPerPage;
        this.dirty = true;
    }

    public boolean showArrow(String column, boolean arrowUp) {
        if (this.orderBy.equals(column)) {
            return this.isAccending ^ arrowUp;
        }
        return false;
    }

    public void setReceivedAgo(FiledsHelper.DateInterval receivedAgo) {
        this.receivedAgo = receivedAgo;
        this.dirty = true;
    }

    public boolean isSubstitutionMessage(Message msg) {
        return "elm".equals(msg.getMessageType()) && "3".equals(msg.getAction());
    }

    private void logException(String bundleKey, Message msg, Exception ex) {
        log.warn("w-0205 | Can't print message {0}", (Object)ex, (Object)msg.getMessageId());
        this.appMessages.addWarning("warning", bundleKey, new String[0]);
    }

    @Generated
    public String getFilterSubjectValue() {
        return this.filterSubjectValue;
    }

    @Generated
    public String getFilterSenderIdValue() {
        return this.filterSenderIdValue;
    }

    @Generated
    public String getFilterRecipientIdValue() {
        return this.filterRecipientIdValue;
    }

    @Generated
    public String getFilterMsgType() {
        return this.filterMsgType;
    }

    @Generated
    public String getFilterMessageIdValue() {
        return this.filterMessageIdValue;
    }

    @Generated
    public List<Message> getSelectedMessages() {
        return this.selectedMessages;
    }

    @Generated
    public void setSelectedMessages(List<Message> selectedMessages) {
        this.selectedMessages = selectedMessages;
    }

    @Generated
    public void setMessageList(List<Message> messageList) {
        this.messageList = messageList;
    }

    @Generated
    public int getRowsPerPage() {
        return this.rowsPerPage;
    }

    @Generated
    public FiledsHelper.DateInterval getReceivedAgo() {
        return this.receivedAgo;
    }
}

