/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.mailbox;

import ch.admin.smclient.model.Message;
import ch.admin.smclient.service.exceptions.MessageLockedException;
import ch.admin.smclient.service.exceptions.SmClientApplicationException;
import ch.admin.smclient.service.postfach.MailboxFolder;
import ch.admin.smclient.service.postfach.MailboxService;
import ch.admin.smclient2.web.compatibility.CurrentUserBean;
import ch.admin.smclient2.web.mailbox.MailboxListMessagesBean;
import jakarta.annotation.PostConstruct;
import jakarta.faces.model.SelectItem;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="session")
public class InboxToolbarBean
implements Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InboxToolbarBean.class);
    private static final long serialVersionUID = 1L;
    @Autowired
    private MailboxService mailboxService;
    @Autowired
    private MailboxListMessagesBean mailboxListMessagesBean;
    @Autowired
    private CurrentUserBean currentUserBean;
    private String selectedPrinter = null;
    private List<SelectItem> printersList;
    private Map<String, PrintService> availablePrinters = null;

    @PostConstruct
    void init() {
        this.printersList = null;
    }

    public int deleteSelectedMessages() {
        List messages = this.getCheckedMessages();
        int deleted = this.moveMessagesFolder(messages, MailboxFolder.DELETED, Message.MessageState.DELETE);
        log.debug("{} messages deleted", (Object)deleted);
        this.mailboxListMessagesBean.refresh();
        return deleted;
    }

    public int restoreSelectedMessages() {
        List messages = this.getCheckedMessages();
        int restored = this.moveMessagesFolder(messages, MailboxFolder.INBOX, Message.MessageState.RESTORE);
        log.debug("{} messages restored", (Object)restored);
        this.mailboxListMessagesBean.refresh();
        return restored;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void printSelectedMessages() {
        int printMessages = 0;
        List messages = this.getCheckedMessages();
        try {
            PrintService ps = (PrintService)this.getAvailablePrinters().get(this.selectedPrinter);
            if (ps == null) {
                ps = (PrintService)this.getAvailablePrinters().values().iterator().next();
            }
            log.info("Printing messages using: {}", (Object)(ps == null ? "NULL" : ps.getName()));
            printMessages = this.mailboxService.printMessages(messages, this.currentUserBean.getUser().getDefaultLanguage(), ps);
        }
        catch (SmClientApplicationException e) {
            this.logException((Exception)((Object)e));
            if (e.getBundleKey() == null) {
                // empty if block
            }
        }
        catch (Exception ex) {
            this.logException(ex);
        }
        if (printMessages < messages.size()) {
            log.warn("w-0208 | {} messages were selected to print, but {} were printed", (Object)messages.size(), (Object)printMessages);
        }
        this.mailboxListMessagesBean.refresh();
    }

    private void logException(Exception ex) {
        log.warn("w-0207 | can't print messages", (Throwable)ex);
    }

    public void exportSelectedMessages() {
        List messages = this.getCheckedMessages();
        try {
            int nbOfExportedMessages = this.mailboxService.exportMessages(messages, this.currentUserBean.getUser().getDefaultLanguage());
            if (nbOfExportedMessages < messages.size()) {
                log.warn("w-0208 | {} messages was selected to export, but {} were exported", (Object)messages.size(), (Object)nbOfExportedMessages);
            }
        }
        catch (MessageLockedException e) {
            log.warn("w-0207 | can't export messages", (Throwable)e);
        }
        this.mailboxListMessagesBean.refresh();
    }

    public void exportCsvSelectedMessages() {
        List messages = this.getCheckedMessages();
        int i = this.mailboxService.exportCsvMessages(messages, this.currentUserBean.getUser().getDefaultLanguage());
        if (i < messages.size()) {
            log.warn("w-0208 | {} messages was selected to export as csv, but {} were exported", (Object)messages.size(), (Object)i);
        }
        this.mailboxListMessagesBean.refresh();
    }

    public void markUnreadSelectedMessages() {
        List messages = this.getCheckedMessages();
        int i = this.mailboxService.markRead(messages, false);
        if (i < messages.size()) {
            // empty if block
        }
        this.mailboxListMessagesBean.refresh();
    }

    public List<Message> getCheckedMessages() {
        return this.mailboxListMessagesBean.getSelectedMessages();
    }

    public int getNumberOfMessages(MailboxFolder folder) {
        if (folder == MailboxFolder.FAILED_TO_RECEIVE) {
            return this.mailboxService.getFileMessageList(folder, this.currentUserBean.getUser().getMandantSedexId()).size();
        }
        return this.mailboxService.getNumberOfMessages(this.currentUserBean.getUser().getMandantSedexId(), folder);
    }

    private int moveMessagesFolder(List<Message> messages, MailboxFolder destination, Message.MessageState state) {
        int proceed = 0;
        for (Message message : messages) {
            try {
                this.mailboxService.moveMessage(message, destination, state);
                ++proceed;
            }
            catch (Exception ex) {
                log.warn("w-0209 | Unable to move message {}, cause {}", new Object[]{message.getMessageId(), ex.getMessage(), ex});
            }
        }
        return proceed;
    }

    private Map<String, PrintService> getAvailablePrinters() {
        if (this.availablePrinters == null) {
            PrintService[] printServices = PrintServiceLookup.lookupPrintServices(DocFlavor.INPUT_STREAM.POSTSCRIPT, null);
            assert (printServices != null);
            if (printServices.length > 0 && PrintServiceLookup.lookupDefaultPrintService() != null) {
                this.selectedPrinter = PrintServiceLookup.lookupDefaultPrintService().getName();
            }
            this.availablePrinters = Arrays.stream(printServices).collect(Collectors.toMap(PrintService::getName, Function.identity()));
        }
        return this.availablePrinters;
    }

    public List<SelectItem> getPrintersList() {
        if (this.printersList == null) {
            this.printersList = this.getAvailablePrinters().keySet().stream().map(SelectItem::new).toList();
        }
        return this.printersList;
    }

    public String getSelectedPrinter() {
        if (this.selectedPrinter == null && !this.getPrintersList().isEmpty() && PrintServiceLookup.lookupDefaultPrintService() != null) {
            this.selectedPrinter = PrintServiceLookup.lookupDefaultPrintService().getName();
        }
        log.debug("Get selected printer {}", (Object)this.selectedPrinter);
        return this.selectedPrinter;
    }

    public void setSelectedPrinter(String selectedPrinter) {
        this.selectedPrinter = selectedPrinter;
        log.debug("Set selected printer {}", (Object)selectedPrinter);
    }
}

