/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.mailbox;

import ch.admin.smclient.service.ProductVersion;
import ch.admin.smclient.service.repository.FileRepository;
import ch.admin.smclient2.web.compatibility.CurrentUserBean;
import ch.admin.smclient2.web.mailbox.ComposeBean;
import ch.admin.smclient2.web.mailbox.ComposeMessageBean;
import ch.admin.smclient2.web.util.JsfUtil;
import ch.ech.xmlns.ech_0010_f._5.AddressInformationType;
import ch.ech.xmlns.ech_0058._4.SendingApplicationType;
import ch.ech.xmlns.ech_0097._1.UidStructureType;
import ch.steuerkonferenz.xmlns.ssk_3111_000001._1.ContentType;
import ch.steuerkonferenz.xmlns.ssk_3111_000001._1.HeaderType;
import ch.steuerkonferenz.xmlns.ssk_3111_000001._1.Message;
import ch.steuerkonferenz.xmlns.ssk_3111_000001._1.RepartitionValueCantonType;
import ch.steuerkonferenz.xmlns.ssk_common._2.ContactInformationType;
import ch.steuerkonferenz.xmlns.ssk_common._2.LegalEntitiesTaxType;
import java.time.LocalDate;
import java.time.Year;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;

@Controller
@Scope(value="session")
public class ComposeRepartitionBean
extends ComposeMessageBean<Message> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComposeRepartitionBean.class);
    @Autowired
    private ComposeBean composeBean;
    @Autowired
    private FileRepository fileRepository;
    @Autowired
    CurrentUserBean user;
    @Autowired
    JsfUtil util;
    @Autowired
    ProductVersion productVersion;
    private RepartitionValueCantonType repartition;

    public ComposeRepartitionBean(ComposeBean composeBean) {
        this.composeBean = composeBean;
    }

    public void addRepartition() {
        this.repartition = new RepartitionValueCantonType();
    }

    public void finalizeAddRepartition() {
        List repartitionList = ((Message)this.getMessage()).getContent().getRepartitionCompilations();
        repartitionList.add(this.repartition);
    }

    public void cancelAddRepartition() {
    }

    public boolean canAddRepartition() {
        return this.repartition != null && this.repartition.getRepartitionParticipation() != null & this.repartition.getRepartitionParticipationOutstanding() != null && this.repartition.getRepartitionParticipationRetroceded() != null && this.repartition.getCanton() != null && this.repartition.getPercentage() != null;
    }

    public void removeRepartition(RepartitionValueCantonType repartition) {
        List repartitions = ((Message)this.getMessage()).getContent().getRepartitionCompilations();
        if (repartitions != null) {
            repartitions.remove(repartition);
        }
    }

    public String save(Message message) throws Exception {
        HeaderType header = message.getHeader();
        ContentType content = message.getContent();
        message.getHeader().setSenderId(this.user.getMandantSedexId());
        header.setSubject(this.composeBean.getFullSubject());
        List recipientIds = this.composeBean.getRecipients();
        if (recipientIds != null && recipientIds.size() > 1) {
            log.error("Only one recipient allowed");
            throw new Exception("Only one recipient allowed");
        }
        header.setRecipientId((String)recipientIds.get(0));
        SendingApplicationType app = new SendingApplicationType();
        app.setManufacturer(this.productVersion.getManufacturer());
        app.setProduct(this.productVersion.getProduct());
        app.setProductVersion(this.productVersion.getProductVersion());
        header.setSendingApplication(app);
        header.setMessageType(this.composeBean.getMessageType().getType());
        header.setSubMessageType(this.composeBean.getMessageType().getSubType());
        header.setMessageDate(this.util.getNow());
        header.setMessageId(this.fileRepository.getPrefixNumber(this.user.getMandantSedexId()).concat(this.util.getMessageId()));
        header.setResponseExpected(false);
        header.setBusinessCaseClosed(true);
        ContactInformationType contactInfo = header.getExtension().getContactInformation();
        LegalEntitiesTaxType taxpayer = content.getTaxpayer();
        AddressInformationType address = taxpayer.getAddress();
        if (header.getAction().equals("1")) {
            header.setReferenceMessageId(null);
        }
        if (contactInfo.getName().isEmpty()) {
            contactInfo.setName(null);
        }
        if (contactInfo.getDepartment().isEmpty()) {
            contactInfo.setDepartment(null);
        }
        if (contactInfo.getOther().isEmpty()) {
            contactInfo.setOther(null);
        }
        if (StringUtils.isEmpty((CharSequence)header.getComment())) {
            header.setComment(null);
        }
        if (StringUtils.isEmpty((CharSequence)address.getStreet())) {
            address.setStreet(null);
        }
        if (StringUtils.isEmpty((CharSequence)address.getHouseNumber())) {
            address.setHouseNumber(null);
        }
        if (StringUtils.isEmpty((CharSequence)address.getTown())) {
            address.setTown(null);
        }
        if (StringUtils.isEmpty((CharSequence)address.getCountry())) {
            address.setCountry(null);
        }
        if (address.getStreet() == null && address.getHouseNumber() == null && address.getTown() == null && address.getCountry() == null) {
            taxpayer.setAddress(null);
        }
        String schemaFileName = null;
        try {
            schemaFileName = this.composeBean.getSchemaFile(this.composeBean.getMessageType());
            String string = schemaFileName.substring(schemaFileName.lastIndexOf(45) + 1, schemaFileName.lastIndexOf(46));
        }
        catch (Exception e) {
            log.error("Cannot determine the minor version from the schema file {}", (Object)this.composeBean.getMessageType().getName());
        }
        return this.composeBean.save((Object)message);
    }

    public void setTaxPeriod(String taxPeriod) {
        Message message = (Message)this.getMessage();
        ContentType content = message.getContent();
        LocalDate date = LocalDate.of(Integer.parseInt(taxPeriod), 1, 1);
        Date period = Date.from(date.atStartOfDay(ZoneId.systemDefault()).toInstant());
        content.setTaxPeriod(period);
    }

    public String getTaxPeriod() {
        Message message = (Message)this.getMessage();
        ContentType content = message.getContent();
        Date date = content.getTaxPeriod();
        if (date == null) {
            return Year.now().toString();
        }
        return content.getTaxPeriod().toString();
    }

    public void resetForm() {
        Object msg = this.getMessage();
        if (msg instanceof Message) {
            Message message = (Message)msg;
            ContentType content = message.getContent();
            LegalEntitiesTaxType taxpayer = content.getTaxpayer();
            taxpayer.setUid(new UidStructureType());
            taxpayer.setAddress(new AddressInformationType());
        }
    }

    public Boolean hasReferenceMessageId() {
        HeaderType header = ((Message)this.getMessage()).getHeader();
        String action = header.getAction();
        return action != null && !action.equals("1");
    }

    @Generated
    public RepartitionValueCantonType getRepartition() {
        return this.repartition;
    }

    @Generated
    public void setRepartition(RepartitionValueCantonType repartition) {
        this.repartition = repartition;
    }
}

