/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.mailbox;

import ch.admin.smclient.service.ProductVersion;
import ch.admin.smclient.service.repository.FileRepository;
import ch.admin.smclient2.web.compatibility.CurrentUserBean;
import ch.admin.smclient2.web.mailbox.ComposeBean;
import ch.admin.smclient2.web.mailbox.ComposeMessageBean;
import ch.admin.smclient2.web.util.JsfUtil;
import ch.eahv_iv.xmlns.eahv_iv_2011_000104._3.ContentType;
import ch.eahv_iv.xmlns.eahv_iv_2011_000104._3.HeaderType;
import ch.eahv_iv.xmlns.eahv_iv_2011_000104._3.Message;
import ch.eahv_iv.xmlns.eahv_iv_common._1.DeclarationLocalReferenceType;
import ch.ech.xmlns.ech_0058._2.SendingApplicationType;
import java.math.BigInteger;
import lombok.Generated;
import org.primefaces.event.ToggleEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;

@Controller
@Scope(value="session")
public class ComposeRejectionBean
extends ComposeMessageBean<Message> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComposeRejectionBean.class);
    @Autowired
    ComposeBean composeBean;
    @Autowired
    FileRepository fileRepository;
    @Autowired
    CurrentUserBean user;
    @Autowired
    JsfUtil util;
    @Autowired
    ProductVersion productVersion;
    private boolean hasPersonId = false;
    private String addressType;
    private String categorieId;
    private String numberId;

    public void togglePersonId(ToggleEvent event) {
        Message message = (Message)this.getMessage();
        HeaderType header = message.getHeader();
        boolean bl = this.hasPersonId = !this.hasPersonId;
        if (this.hasPersonId) {
            header.setDeclarationLocalReference(new DeclarationLocalReferenceType());
        } else {
            header.setDeclarationLocalReference(null);
        }
    }

    public void addOtherPersonId() {
    }

    public void openWizard() {
    }

    public void finishEditingDetailsWizard() {
    }

    public String save(Message message) throws Exception {
        HeaderType header = message.getHeader();
        ContentType content = message.getContent();
        message.getHeader().setSenderId(this.user.getMandantSedexId());
        header.setSubject(this.composeBean.getFullSubject());
        header.getRecipientIds().addAll(this.composeBean.getRecipients());
        SendingApplicationType app = new SendingApplicationType();
        app.setManufacturer(this.productVersion.getManufacturer());
        app.setProduct(this.productVersion.getProduct());
        app.setProductVersion(this.productVersion.getProductVersion());
        header.setSendingApplication(app);
        header.setMessageType(Integer.parseInt(this.composeBean.getMessageType().getType()));
        header.setSubMessageType(this.composeBean.getMessageType().getSubType());
        header.setMessageDate(this.util.getNow());
        header.setMessageId(this.fileRepository.getPrefixNumber(this.user.getMandantSedexId()).concat(this.util.getMessageId()));
        String schemaFileName = null;
        try {
            schemaFileName = this.composeBean.getSchemaFile(this.composeBean.getMessageType());
            String minorVersion = schemaFileName.substring(schemaFileName.lastIndexOf(45) + 1, schemaFileName.lastIndexOf(46));
            message.setMinorVersion(new BigInteger(minorVersion));
        }
        catch (Exception e) {
            log.error("Cannot determine the minor version from the schema file {}", (Object)this.composeBean.getMessageType().getName());
            message.setMinorVersion(BigInteger.ZERO);
        }
        return this.composeBean.save((Object)message);
    }

    public void resetForm() {
        this.addressType = "swiss";
        this.hasPersonId = false;
    }

    @Generated
    public boolean isHasPersonId() {
        return this.hasPersonId;
    }

    @Generated
    public void setHasPersonId(boolean hasPersonId) {
        this.hasPersonId = hasPersonId;
    }

    @Generated
    public String getAddressType() {
        return this.addressType;
    }

    @Generated
    public void setAddressType(String addressType) {
        this.addressType = addressType;
    }

    @Generated
    public String getCategorieId() {
        return this.categorieId;
    }

    @Generated
    public void setCategorieId(String categorieId) {
        this.categorieId = categorieId;
    }

    @Generated
    public String getNumberId() {
        return this.numberId;
    }

    @Generated
    public void setNumberId(String numberId) {
        this.numberId = numberId;
    }
}

