/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.mailbox;

import ch.admin.smclient.service.ProductVersion;
import ch.admin.smclient.service.repository.FileRepository;
import ch.admin.smclient2.web.compatibility.CurrentUserBean;
import ch.admin.smclient2.web.mailbox.ComposeBean;
import ch.admin.smclient2.web.mailbox.ComposeMessageBean;
import ch.admin.smclient2.web.util.JsfUtil;
import ch.eahv_iv.xmlns.eahv_iv_2010_000101._5.ContentType;
import ch.eahv_iv.xmlns.eahv_iv_2010_000101._5.HeaderType;
import ch.eahv_iv.xmlns.eahv_iv_2010_000101._5.Message;
import ch.eahv_iv.xmlns.eahv_iv_2010_000101._5.MutationType;
import ch.eahv_iv.xmlns.eahv_iv_common._1.DeclarationLocalReferenceType;
import ch.eahv_iv.xmlns.eahv_iv_common._1.NamedOrganisationIdType;
import ch.ech.xmlns.ech_0010._3.AddressInformationType;
import ch.ech.xmlns.ech_0058._2.SendingApplicationType;
import java.math.BigInteger;
import java.util.List;
import lombok.Generated;
import org.primefaces.event.ToggleEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;

@Controller
@Scope(value="session")
public class ComposeMutationMeldungBean
extends ComposeMessageBean<Message> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComposeMutationMeldungBean.class);
    @Autowired
    private ComposeBean composeBean;
    @Autowired
    private FileRepository fileRepository;
    @Autowired
    CurrentUserBean user;
    @Autowired
    JsfUtil util;
    @Autowired
    ProductVersion productVersion;
    private MutationType mutation;
    private String addressType;
    private String returnAddressType;
    private String categorieId;
    private String organisationId;
    private boolean hasPersonId = false;

    public ComposeMutationMeldungBean(ComposeBean composeBean) {
        this.composeBean = composeBean;
    }

    public void addMutation(Message message) {
        this.addressType = "swiss";
        this.returnAddressType = "swiss";
        this.mutation = new MutationType();
        this.mutation.setAddress(new AddressInformationType());
        this.mutation.setReturnAddress(new AddressInformationType());
    }

    public void deleteMutation(MutationType mutation) {
        List mutations = ((Message)this.getMessage()).getContent().getMutations();
        if (mutations != null) {
            mutations.remove(mutation);
        }
    }

    public void deleteOrg(NamedOrganisationIdType organisationId) {
        this.mutation.getOtherOrganisationIds().remove(organisationId);
    }

    public void addOrg() {
        NamedOrganisationIdType organisationIdType = new NamedOrganisationIdType().withOrganisationId(this.organisationId).withOrganisationIdCategory(this.categorieId);
        this.mutation.getOtherOrganisationIds().add(organisationIdType);
        this.categorieId = "";
        this.organisationId = "";
    }

    public void togglePersonId(ToggleEvent event) {
        Message message = (Message)this.getMessage();
        HeaderType header = message.getHeader();
        boolean bl = this.hasPersonId = !this.hasPersonId;
        if (this.hasPersonId) {
            header.setDeclarationLocalReference(new DeclarationLocalReferenceType());
        } else {
            header.setDeclarationLocalReference(null);
        }
    }

    public void addMutationToMessage() {
        Message message = (Message)this.getMessage();
        message.getContent().getMutations().add(this.mutation);
    }

    public String save(Message message) throws Exception {
        HeaderType header = message.getHeader();
        ContentType content = message.getContent();
        message.getHeader().setSenderId(this.user.getMandantSedexId());
        header.setSubject(this.composeBean.getFullSubject());
        header.getRecipientIds().addAll(this.composeBean.getRecipients());
        SendingApplicationType app = new SendingApplicationType();
        app.setManufacturer(this.productVersion.getManufacturer());
        app.setProduct(this.productVersion.getProduct());
        app.setProductVersion(this.productVersion.getProductVersion());
        header.setSendingApplication(app);
        header.setMessageType(Integer.parseInt(this.composeBean.getMessageType().getType()));
        header.setSubMessageType(this.composeBean.getMessageType().getSubType());
        header.setMessageDate(this.util.getNow());
        header.setMessageId(this.fileRepository.getPrefixNumber(this.user.getMandantSedexId()).concat(this.util.getMessageId()));
        String schemaFileName = null;
        try {
            schemaFileName = this.composeBean.getSchemaFile(this.composeBean.getMessageType());
            String minorVersion = schemaFileName.substring(schemaFileName.lastIndexOf(45) + 1, schemaFileName.lastIndexOf(46));
            message.setMinorVersion(new BigInteger(minorVersion));
        }
        catch (Exception e) {
            log.error("Cannot determine the minor version from the schema file {}", (Object)this.composeBean.getMessageType().getName());
            message.setMinorVersion(BigInteger.ZERO);
        }
        return this.composeBean.save((Object)message);
    }

    public void resetForm() {
        this.addressType = "swiss";
        this.returnAddressType = "swiss";
        this.mutation = null;
    }

    @Generated
    public MutationType getMutation() {
        return this.mutation;
    }

    @Generated
    public void setMutation(MutationType mutation) {
        this.mutation = mutation;
    }

    @Generated
    public String getAddressType() {
        return this.addressType;
    }

    @Generated
    public void setAddressType(String addressType) {
        this.addressType = addressType;
    }

    @Generated
    public String getReturnAddressType() {
        return this.returnAddressType;
    }

    @Generated
    public void setReturnAddressType(String returnAddressType) {
        this.returnAddressType = returnAddressType;
    }

    @Generated
    public String getCategorieId() {
        return this.categorieId;
    }

    @Generated
    public void setCategorieId(String categorieId) {
        this.categorieId = categorieId;
    }

    @Generated
    public String getOrganisationId() {
        return this.organisationId;
    }

    @Generated
    public void setOrganisationId(String organisationId) {
        this.organisationId = organisationId;
    }

    @Generated
    public boolean isHasPersonId() {
        return this.hasPersonId;
    }

    @Generated
    public void setHasPersonId(boolean hasPersonId) {
        this.hasPersonId = hasPersonId;
    }
}

