/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.mailbox;

import ch.admin.smclient.service.ProductVersion;
import ch.admin.smclient.service.repository.FileRepository;
import ch.admin.smclient2.web.compatibility.CurrentUserBean;
import ch.admin.smclient2.web.mailbox.AttachmentBean;
import ch.admin.smclient2.web.mailbox.ComposeBean;
import ch.admin.smclient2.web.mailbox.ComposeMessageBean;
import ch.admin.smclient2.web.util.JsfUtil;
import ch.ech.xmlns.ech_0007_f._5.SwissMunicipalityType;
import ch.ech.xmlns.ech_0010_f._5.AddressInformationType;
import ch.ech.xmlns.ech_0058._4.SendingApplicationType;
import ch.steuerkonferenz.xmlns.ssk_3108_000001._1.AttachmentType;
import ch.steuerkonferenz.xmlns.ssk_3108_000001._1.ContentType;
import ch.steuerkonferenz.xmlns.ssk_3108_000001._1.HeaderType;
import ch.steuerkonferenz.xmlns.ssk_3108_000001._1.Message;
import jakarta.faces.model.SelectItem;
import java.math.BigInteger;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import org.primefaces.model.file.UploadedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;

@Controller
@Scope(value="session")
public class ComposeKantonDossierNpBean
extends ComposeMessageBean<Message> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComposeKantonDossierNpBean.class);
    @Autowired
    private ComposeBean composeBean;
    @Autowired
    private FileRepository fileRepository;
    @Autowired
    CurrentUserBean user;
    @Autowired
    JsfUtil util;
    @Autowired
    ProductVersion productVersion;
    @Autowired
    private AttachmentBean attachmentBean;
    private AttachmentType attachmentType;
    private UploadedFile file;

    public boolean isDateEnquiryNeeded() {
        String action = ((Message)this.getMessage()).getHeader().getAction();
        if (action == null) {
            return false;
        }
        return action.equals("3") || action.equals("4");
    }

    public String save(Message message) throws Exception {
        HeaderType header = message.getHeader();
        ContentType content = message.getContent();
        message.getHeader().setSenderId(this.user.getMandantSedexId());
        header.setSubject(this.composeBean.getFullSubject());
        List recipients = this.composeBean.getRecipients();
        if (recipients.size() != 1) {
            throw new RuntimeException("Unique recipient needed");
        }
        header.setRecipientId((String)recipients.get(0));
        SendingApplicationType app = new SendingApplicationType();
        app.setManufacturer(this.productVersion.getManufacturer());
        app.setProduct(this.productVersion.getProduct());
        app.setProductVersion(this.productVersion.getProductVersion());
        header.setSendingApplication(app);
        header.setMessageType(this.composeBean.getMessageType().getType());
        header.setSubMessageType(this.composeBean.getMessageType().getSubType());
        header.setMessageDate(this.util.getNow());
        header.setMessageId(this.fileRepository.getPrefixNumber(this.user.getMandantSedexId()).concat(this.util.getMessageId()));
        header.setBusinessCaseClosed(true);
        header.setResponseExpected(false);
        String schemaFileName = null;
        try {
            schemaFileName = this.composeBean.getSchemaFile(this.composeBean.getMessageType());
            String minorVersion = schemaFileName.substring(schemaFileName.lastIndexOf(45) + 1, schemaFileName.lastIndexOf(46));
            message.setMinorVersion(new BigInteger(minorVersion));
        }
        catch (Exception e) {
            log.error("Cannot determine the minor version from the schema file {}", (Object)this.composeBean.getMessageType().getName());
            message.setMinorVersion(BigInteger.ZERO);
        }
        return this.attachmentBean.save((Object)message);
    }

    public List<AttachmentType> getAttachments() {
        return ((Message)this.getMessage()).getHeader().getAttachments();
    }

    public boolean canAddAttachment() {
        return this.attachmentBean.canAddAttachment();
    }

    public void finalizeAddAttachment() throws Exception {
        this.attachmentBean.validateUpload();
        this.attachmentBean.add();
        HeaderType header = ((Message)this.getMessage()).getHeader();
        header.getAttachments().add(this.attachmentType);
    }

    public void addAttachment() {
        this.attachmentType = new AttachmentType();
        this.attachmentBean.prepareAttachment();
    }

    public void remove(AttachmentType attachment) {
        List attachments = this.getAttachments();
        int index = attachments.indexOf(attachment);
        this.attachmentBean.remove(index);
    }

    public void cancelAddAttachment() {
        this.attachmentType = null;
    }

    public AttachmentType getAttachmentType() {
        if (this.attachmentType == null) {
            this.attachmentType = new AttachmentType();
        }
        return this.attachmentType;
    }

    public List<SelectItem> getMimeTypes() {
        return Stream.of(AttachmentBean.SupportedMimeTypes.TIFF, AttachmentBean.SupportedMimeTypes.PDF, AttachmentBean.SupportedMimeTypes.XLSX).map(type -> new SelectItem((Object)type.getMimeType(), type.name())).toList();
    }

    public void resetForm() {
        this.attachmentType = null;
        Object message = this.composeBean.getMessageObject();
        if (message instanceof Message) {
            Message msg = (Message)message;
            this.attachmentBean.init((Object)msg);
            msg.getContent().getTaxPayer().setAddress(new AddressInformationType());
            msg.getContent().getTaxPayer().setTaxMunicipality(new SwissMunicipalityType());
        }
    }

    @Generated
    public void setAttachmentType(AttachmentType attachmentType) {
        this.attachmentType = attachmentType;
    }

    @Generated
    public UploadedFile getFile() {
        return this.file;
    }

    @Generated
    public void setFile(UploadedFile file) {
        this.file = file;
    }
}

