/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.mailbox;

import ch.admin.smclient.service.ProductVersion;
import ch.admin.smclient.service.repository.FileRepository;
import ch.admin.smclient2.web.compatibility.AppMessages;
import ch.admin.smclient2.web.compatibility.CurrentUserBean;
import ch.admin.smclient2.web.mailbox.AddressBookBean;
import ch.admin.smclient2.web.mailbox.AttachmentBean;
import ch.admin.smclient2.web.mailbox.ComposeBean;
import ch.admin.smclient2.web.mailbox.ComposeMessageBean;
import ch.admin.smclient2.web.util.JsfUtil;
import ch.ech.xmlns.ech_0058._4.SendingApplicationType;
import ch.ech.xmlns.ech_0097._1.NamedOrganisationIdType;
import ch.ech.xmlns.ech_0097._1.UidOrganisationIdCategorieType;
import ch.ech.xmlns.ech_0097._1.UidStructureType;
import ch.steuerkonferenz.xmlns.ssk_3003_000001._1.AttachmentType;
import ch.steuerkonferenz.xmlns.ssk_3003_000001._1.ContentType;
import ch.steuerkonferenz.xmlns.ssk_3003_000001._1.HeaderType;
import ch.steuerkonferenz.xmlns.ssk_3003_000001._1.Message;
import ch.steuerkonferenz.xmlns.ssk_common._2.LegalEntitiesTaxType;
import jakarta.faces.model.SelectItem;
import java.math.BigInteger;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.primefaces.PrimeFaces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;

@Controller
@Scope(value="session")
public class ComposeEstvDossierMeldungBean
extends ComposeMessageBean<Message> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComposeEstvDossierMeldungBean.class);
    public static final String ANSWER = "6";
    @Autowired
    private ComposeBean composeBean;
    @Autowired
    private AddressBookBean addressBookBean;
    @Autowired
    private FileRepository fileRepository;
    @Autowired
    private CurrentUserBean user;
    @Autowired
    private JsfUtil util;
    @Autowired
    private ProductVersion productVersion;
    private AttachmentType attachmentType;
    private String taxPayer;
    private boolean hasOtherOrganisationId;
    @Autowired
    private AttachmentBean attachmentBean;
    @Autowired
    private AppMessages appMessages;

    public boolean isOtherOrgIdNeeded() {
        return this.hasOtherOrganisationId && ((Message)this.getMessage()).getHeader().getAction().equals(ANSWER);
    }

    public void resetAll() {
        this.taxPayer = "";
        this.hasOtherOrganisationId = false;
        this.attachmentType = null;
        this.attachmentBean.init(this.getMessage());
    }

    public void setTaxPayer(String newTaxPayer) {
        this.taxPayer = newTaxPayer;
        LegalEntitiesTaxType legalEntities = ((Message)this.getMessage()).getContent().getTaxPayer().getLegalEntity();
        if (newTaxPayer.isBlank()) {
            legalEntities.setUid(null);
        } else {
            UidStructureType uid = new UidStructureType();
            uid.setUidOrganisationIdCategorie(UidOrganisationIdCategorieType.CHE);
            legalEntities.setUid(uid);
        }
    }

    public void taxPayerListener() {
        UidStructureType uid = null;
        if (!StringUtils.isEmpty((CharSequence)this.taxPayer)) {
            uid = new UidStructureType();
        }
        ContentType content = ((Message)this.getMessage()).getContent();
        content.getTaxPayer().getLegalEntity().setUid(uid);
    }

    public void toggleOtherOrganisationId() {
        boolean bl = this.hasOtherOrganisationId = !this.hasOtherOrganisationId;
        if (this.hasOtherOrganisationId) {
            LegalEntitiesTaxType legalEntity = ((Message)this.getMessage()).getContent().getTaxPayer().getLegalEntity();
            List orgIds = legalEntity.getOtherOrganisationIds();
            orgIds.add(new NamedOrganisationIdType());
        } else {
            LegalEntitiesTaxType legalEntity = ((Message)this.getMessage()).getContent().getTaxPayer().getLegalEntity();
            legalEntity.getOtherOrganisationIds().clear();
        }
    }

    public String taxPayerType() {
        if (null == ((Message)this.getMessage()).getContent().getTaxPayer().getLegalEntity().getLegalForm()) {
            return "";
        }
        return ((Message)this.getMessage()).getContent().getTaxPayer().getLegalEntity().getLegalForm().toString();
    }

    public String save(Message message) throws Exception {
        HeaderType header = message.getHeader();
        ContentType content = message.getContent();
        message.getHeader().setSenderId(this.user.getMandantSedexId());
        header.setSubject(this.composeBean.getFullSubject());
        List recipients = this.composeBean.getRecipients();
        if (recipients.size() != 1) {
            throw new RuntimeException("Unique recipient needed");
        }
        header.setRecipientId((String)recipients.get(0));
        SendingApplicationType app = new SendingApplicationType();
        app.setManufacturer(this.productVersion.getManufacturer());
        app.setProduct(this.productVersion.getProduct());
        app.setProductVersion(this.productVersion.getProductVersion());
        header.setSendingApplication(app);
        header.setMessageType(this.composeBean.getMessageType().getType());
        header.setSubMessageType(this.composeBean.getMessageType().getSubType());
        header.setMessageDate(this.util.getNow());
        header.setMessageId(this.fileRepository.getPrefixNumber(this.user.getMandantSedexId()).concat(this.util.getMessageId()));
        String action = ((Message)this.getMessage()).getHeader().getAction();
        if (action.equals(ANSWER)) {
            header.setBusinessCaseClosed(false);
        } else {
            header.setBusinessCaseClosed(true);
        }
        header.setResponseExpected(false);
        String schemaFileName = null;
        try {
            schemaFileName = this.composeBean.getSchemaFile(this.composeBean.getMessageType());
            String minorVersion = schemaFileName.substring(schemaFileName.lastIndexOf(45) + 1, schemaFileName.lastIndexOf(46));
            message.setMinorVersion(new BigInteger(minorVersion));
        }
        catch (Exception e) {
            log.error("Cannot determine the minor version from the schema file {}", (Object)this.composeBean.getMessageType().getName());
            message.setMinorVersion(BigInteger.ZERO);
        }
        return this.attachmentBean.save((Object)message);
    }

    public List<AttachmentType> getAttachments() {
        return ((Message)this.getMessage()).getHeader().getAttachments();
    }

    public void finalizeAddAttachment() throws Exception {
        if (this.attachmentType.getDocumentDate() == null) {
            this.appMessages.addError("error", "attachment.no.date", new String[0]);
            return;
        }
        this.attachmentBean.validateUpload();
        this.attachmentBean.add();
        HeaderType header = ((Message)this.getMessage()).getHeader();
        header.getAttachments().add(this.attachmentType);
        this.util.execute("PF('attachmentDialog').hide()");
    }

    public boolean canAddAttachment() {
        return this.attachmentBean.canAddAttachment();
    }

    public void addAttachment() {
        this.attachmentType = new AttachmentType();
        this.attachmentBean.prepareAttachment();
    }

    public void remove(AttachmentType attachment) {
        List attachments = this.getAttachments();
        int index = attachments.indexOf(attachment);
        this.attachmentBean.remove(index);
    }

    public void cancelAddAttachment() {
        this.attachmentType = null;
        PrimeFaces.current().resetInputs(new String[]{"attachmentForm"});
    }

    public List<SelectItem> getMimeTypes() {
        return Stream.of(AttachmentBean.SupportedMimeTypes.TIFF, AttachmentBean.SupportedMimeTypes.PDF).map(type -> new SelectItem((Object)type.getMimeType(), type.name())).toList();
    }

    public AttachmentType getAttachmentType() {
        if (this.attachmentType == null) {
            this.attachmentType = new AttachmentType();
        }
        return this.attachmentType;
    }

    @Generated
    public void setAttachmentType(AttachmentType attachmentType) {
        this.attachmentType = attachmentType;
    }

    @Generated
    public String getTaxPayer() {
        return this.taxPayer;
    }

    @Generated
    public boolean isHasOtherOrganisationId() {
        return this.hasOtherOrganisationId;
    }

    @Generated
    public void setHasOtherOrganisationId(boolean hasOtherOrganisationId) {
        this.hasOtherOrganisationId = hasOtherOrganisationId;
    }
}

