/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.mailbox;

import ch.admin.smclient.model.Domain;
import ch.admin.smclient.model.validate.message.MessageDefinition;
import ch.admin.smclient.service.DomainRepository;
import ch.admin.smclient.service.repository.DirectoryRepository;
import ch.admin.smclient.service.repository.FileRepository;
import ch.admin.smclient2.web.compatibility.AppMessages;
import ch.admin.smclient2.web.compatibility.CurrentUserBean;
import ch.admin.smclient2.web.compatibility.SmClientBundle;
import ch.admin.smclient2.web.mailbox.AddressBookBean;
import ch.admin.smclient2.web.mailbox.AnswerType;
import ch.admin.smclient2.web.mailbox.Attachment;
import ch.admin.smclient2.web.mailbox.AttachmentAnalyzer;
import ch.admin.smclient2.web.mailbox.AttachmentBean;
import ch.admin.smclient2.web.mailbox.ComposeAustauschBean;
import ch.admin.smclient2.web.mailbox.ComposeBean;
import ch.admin.smclient2.web.mailbox.ComposeEstvDossierMeldungBean;
import ch.admin.smclient2.web.mailbox.ComposeKantonDossierBean;
import ch.admin.smclient2.web.mailbox.ComposeKantonDossierNpBean;
import ch.admin.smclient2.web.mailbox.ComposeMutationMeldungBean;
import ch.admin.smclient2.web.mailbox.ComposeRejectionBean;
import ch.admin.smclient2.web.mailbox.ComposeRepartitionBean;
import ch.admin.smclient2.web.mailbox.MessageFileProducer;
import ch.admin.smclient2.web.mailbox.MessageType;
import ch.admin.smclient2.web.mailbox.ZipMessageInfo;
import ch.admin.smclient2.web.schema.ObjectFactory;
import ch.admin.smclient2.web.schema.SchemaParser;
import ch.admin.smclient2.web.schema.reflect.ClearPropertiesStrategy;
import ch.admin.smclient2.web.schema.reflect.PropertyIterator;
import ch.admin.smclient2.web.schema.reflect.Strategy;
import ch.admin.smclient2.web.util.JsfUtil;
import com.sun.xml.xsom.XSSchemaSet;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.context.FacesContext;
import jakarta.faces.model.SelectItem;
import jakarta.xml.bind.MarshalException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import lombok.Generated;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Scope(value="session")
public class ComposeBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComposeBean.class);
    public static final String MESSAGE_SAVED = "ch.admin.smclient.webbeans.mailbox.ComposeBean.MessageSavedEvent";
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    FileRepository fileRepository;
    @Autowired
    DirectoryRepository directoryRepository;
    @Autowired
    DomainRepository domainRepository;
    @Autowired
    ObjectFactory objectFactory;
    @Autowired
    AddressBookBean addressBookBean;
    List<MessageDefinition> messageDefinitions;
    MessageType messageType;
    String textualMessageType;
    Object messageTransfer;
    @Autowired
    MessageFileProducer messageFileProducer;
    @Autowired
    private AttachmentAnalyzer attachmentAnalyzer;
    public List<String> recipients;
    @Autowired
    CurrentUserBean user;
    @Autowired
    private JsfUtil jsfUtil;
    private String subject;
    private File answerFolder;
    private Object contentObject;
    private boolean partial;
    private AnswerType answerType;
    private Object messageObject;
    List<SelectItem> messageTypes;
    @Autowired
    private AttachmentBean attachmentBean;
    @Autowired
    private AppMessages appMessages;
    @Autowired
    private SchemaParser schemaParser;

    public String getFullSubject() {
        String messageTypeName = this.messageType.getName();
        String bundleName = this.messageType.getBundleName();
        if (StringUtils.isEmpty((CharSequence)messageTypeName)) {
            return this.subject;
        }
        if (StringUtils.isEmpty((CharSequence)this.subject)) {
            return bundleName.concat(" - ").concat(this.subject);
        }
        if (this.subject.startsWith(messageTypeName) || this.subject.startsWith(bundleName)) {
            return this.subject;
        }
        return bundleName.concat(" - ").concat(this.subject);
    }

    public void onMessageTypeChanged() {
        this.textualMessageType = this.messageType.getType() + " " + this.messageType.getSubType();
        this.addressBookBean.reset();
    }

    public List<SelectItem> getMessageTypes() {
        if (this.messageTypes == null) {
            ArrayList<SelectItem> result = new ArrayList<SelectItem>();
            try {
                List messages = this.getMessageDefinitions(this.user.getMandantSedexId());
                log.debug("Getting message definitions for {}", (Object)this.user.getMandantSedexId());
                log.debug("Found: {} entries", (Object)messages.size());
                for (MessageDefinition message : messages) {
                    String name;
                    try {
                        name = SmClientBundle.getBundle().getString(message.getName());
                    }
                    catch (MissingResourceException e) {
                        name = message.getName();
                    }
                    if (!this.customFormExists(message)) continue;
                    log.debug("Found a custom form for message {}", (Object)name);
                    result.add(new SelectItem((Object)new MessageType(message), name));
                }
                if (!this.user.isAhviv().booleanValue() && this.user.isTestPlatformUser().booleanValue()) {
                    result.add(this.getSpecialistFeedBackItem());
                }
                this.messageTypes = result;
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
        return this.messageTypes;
    }

    public String getMessageName() {
        if (this.messageType != null) {
            String name;
            try {
                name = SmClientBundle.getBundle().getString(this.messageType.getName());
            }
            catch (MissingResourceException e) {
                name = this.messageType.getName();
            }
            return name;
        }
        return "";
    }

    public Object createXsdObject() throws Exception {
        if (this.messageType != null) {
            String schema = this.getSchemaFile(this.messageType);
            this.getSessionMap().put("schemaFileName", schema);
            return this.objectFactory.createObjectFromSchema(this.user.getMandantSedexId(), schema, this.getCatalogFile());
        }
        return null;
    }

    public Object getMessageObject() {
        if (this.messageObject == null) {
            try {
                this.messageObject = this.createXsdObject();
            }
            catch (Exception e) {
                log.warn("Cannot create message object", (Throwable)e);
            }
        }
        return this.messageObject;
    }

    public String toAttachment(Object object) {
        this.messageTransfer = object;
        return "attachment";
    }

    public String toAttachment(Object object, String messageId) {
        if (messageId != null) {
            // empty if block
        }
        return this.toAttachment(object);
    }

    public String checkAndToAttachment(Object object, String messageId, boolean condition, String errorMessage) {
        if (condition) {
            return this.toAttachment(object, messageId);
        }
        return null;
    }

    public String checkAndToAttachment(Object object, boolean condition, String errorMessage) {
        if (condition) {
            return this.toAttachment(object);
        }
        return null;
    }

    public String checkAndSave(Object object, boolean condition, String errorMessage) throws Exception {
        if (condition) {
            return this.save(object);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String save(Object object) throws Exception {
        String schemaUrl = this.fileRepository.getSchemaFile(this.user.getMandantSedexId(), this.messageType.getType(), this.messageType.getSubType());
        XSSchemaSet schema = this.schemaParser.parseCurrentSchema();
        Domain domain = this.domainRepository.findByName(this.messageType.getDomain());
        try {
            this.messageFileProducer.createZipMessage(this.user.getMandantSedexId(), new ZipMessageInfo(object, schemaUrl, this.answerFolder, domain.getName()), domain);
        }
        catch (Exception e) {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "Error", e.getMessage()));
            log.warn("unable to save message of type {1} with subject {2}", new Object[]{e, this.getMessageType(), this.getSubject()});
            String string = null;
            return string;
        }
        finally {
            FileUtils.deleteQuietly((File)this.answerFolder);
        }
        this.addressBookBean.reset();
        this.resetAll();
        return "/compose/confirm.xhtml?faces-redirect=true";
    }

    private boolean hasFilesInAttachments(List<Attachment> attachments) {
        for (Attachment att : attachments) {
            if (att.getFiles() == null || att.getFiles().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private String currentSchema() {
        return (String)FacesContext.getCurrentInstance().getExternalContext().getSessionMap().get("schemaFileName");
    }

    public String saveWithAttachments(Object message, List<Attachment> attachments) throws Exception {
        XSSchemaSet schema = this.schemaParser.parseCurrentSchema();
        Object messageTransfer = ComposeBean.processFields((Object)message, (XSSchemaSet)schema, (MessageType)this.messageType);
        if (!this.hasFilesInAttachments(attachments)) {
            return null;
        }
        Domain domain = this.domainRepository.findByName(this.messageType.getDomain());
        ZipMessageInfo zipMessageInfo = new ZipMessageInfo(messageTransfer, this.currentSchema(), attachments, domain.getName());
        this.attachmentAnalyzer.setSuffix(this.messageFileProducer.getSuffix(zipMessageInfo));
        this.attachmentAnalyzer.fillAttachments(messageTransfer, attachments);
        try {
            this.messageFileProducer.createZipMessage(this.user.getMandantSedexId(), zipMessageInfo, domain);
        }
        catch (MarshalException e) {
            return null;
        }
        return "/compose/confirm.xhtml?faces-redirect=true";
    }

    public String saveAnswer(Object object) throws Exception {
        try {
            PropertyUtils.setProperty((Object)object, (String)"content", (Object)this.contentObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.save(object);
    }

    public void reset() {
        this.setSubject(null);
        if (this.recipients != null) {
            this.recipients = null;
        }
    }

    public void resetAll() {
        this.setMessageType(null);
        this.setTextualMessageType(null);
        this.addressBookBean.reset();
        this.reset();
    }

    public void addBean(List<Object> toAddTo, String type) throws Exception {
        Object bean = this.instanceOf(type);
        toAddTo.add(bean);
    }

    public void add(Object object, String name, String type) throws Exception {
        Object bean = this.instanceOf(type);
        PropertyUtils.setProperty((Object)object, (String)name, (Object)bean);
    }

    public void remove(Object object, String name, String type) throws Exception {
        PropertyUtils.setProperty((Object)object, (String)name, null);
    }

    public void removeBean(List list, String type) {
        if (list.size() > 0) {
            list.remove(list.size() - 1);
        }
    }

    public void removeIndex(List list, int index) {
        list.remove(index);
    }

    public void addAndRemove(Object object, String fieldName, String name) throws Exception {
        new JsfUtil().add(object, fieldName);
        JsfUtil.removeAlias((String)name);
    }

    public void removeAndAdd(List list, int index, String name) {
        this.removeIndex(list, index);
        JsfUtil.createAlias((Object)(--index), (String)name);
    }

    public List<MessageDefinition> getMessageDefinitions(String sedexId) throws Exception {
        if (this.messageDefinitions == null) {
            log.debug("refreshing message definitions");
            this.messageDefinitions = this.fileRepository.getFormServiceMessageDefinitions(sedexId);
        }
        log.debug("message defintions: {} entries", (Object)this.messageDefinitions.size());
        return this.messageDefinitions;
    }

    public SelectItem getSpecialistFeedBackItem() {
        SpecialistFeedBackMessageType type = new SpecialistFeedBackMessageType(this);
        return new SelectItem((Object)type, type.getBundleName());
    }

    public String generate(ComposeAustauschBean austausch, ComposeEstvDossierMeldungBean estv, ComposeRejectionBean rejection, ComposeKantonDossierBean canton, ComposeMutationMeldungBean mutation, ComposeKantonDossierNpBean mutationNp, ComposeRepartitionBean repartition) {
        this.recipients = this.addressBookBean.getRecipients();
        if (this.recipients == null || this.recipients.isEmpty()) {
            this.appMessages.addError("error", "compose.no.recipients.selected", new String[0]);
            return null;
        }
        try {
            this.messageObject = this.createXsdObject();
            String type = this.messageType.getName();
            this.attachmentBean.setMessageTransfer(this.messageObject);
            this.attachmentBean.setMessageType(this.messageType);
            austausch.resetForm();
            estv.resetAll();
            rejection.resetForm();
            canton.resetForm();
            mutation.resetForm();
            mutationNp.resetForm();
            repartition.resetForm();
            return "/compose/" + this.messageType.getViewName() + "?faces-redirect=true";
        }
        catch (Exception e) {
            log.error("Cannot create message object: {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public void storeFormInSession(String form) {
    }

    public boolean isNotReport(Object object) {
        return !PropertyUtils.isReadable((Object)object, (String)"reportHeader");
    }

    public boolean hasAttachmentAttribute(Object object) {
        try {
            return PropertyUtils.isReadable((Object)object, (String)"header.attachment") || PropertyUtils.isReadable((Object)object, (String)"header.extension") && PropertyUtils.getProperty((Object)object, (String)"header.extension") != null && PropertyUtils.isReadable((Object)object, (String)"header.extension.attachment");
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getSchemaFile(MessageType messageType) throws Exception {
        if (messageType instanceof SpecialistFeedBackMessageType) {
            return this.fileRepository.getSchemaLocation(this.user.getMandantSedexId(), "http://www.steuerkonferenz.ch/xmlns/ssk-common");
        }
        return this.fileRepository.getSchemaFile(this.user.getMandantSedexId(), messageType.getType(), messageType.getSubType());
    }

    public static Object processFields(Object object, XSSchemaSet schema, MessageType messageType) throws Exception {
        if (JsfUtil.hasProperty((Object)(object = new PropertyIterator(schema, (Strategy)new ClearPropertiesStrategy()).iterate(object)), (String)"content.organisationIdentification") && messageType.getType().contentEquals("3002") && messageType.getSubType().contentEquals("000302")) {
            PropertyUtils.setProperty((Object)object, (String)"header.object", (Object)PropertyUtils.getProperty((Object)object, (String)"content.organisationIdentification"));
        }
        return object;
    }

    public void putInContext(String answerSchema, Object answerObject) {
    }

    private File getCatalogFile() throws IOException {
        return this.fileRepository.getCatalogWithPublicReferences(this.user.getMandantSedexId());
    }

    private Map<String, Object> getSessionMap() {
        return FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
    }

    private boolean customFormExists(MessageDefinition message) {
        log.debug("custom form exists: '{}' and resource '{}'", (Object)message.getCustomViewName(), (Object)JsfUtil.getResource((String)("compose/" + message.getCustomViewName())).exists());
        return StringUtils.isNotEmpty((CharSequence)message.getCustomViewName()) && JsfUtil.getResource((String)("compose/" + message.getCustomViewName())).exists();
    }

    private Object instanceOf(String type) throws Exception {
        return null;
    }

    @Generated
    public MessageType getMessageType() {
        return this.messageType;
    }

    @Generated
    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    @Generated
    public String getTextualMessageType() {
        return this.textualMessageType;
    }

    @Generated
    public void setTextualMessageType(String textualMessageType) {
        this.textualMessageType = textualMessageType;
    }

    @Generated
    public List<String> getRecipients() {
        return this.recipients;
    }

    @Generated
    public void setRecipients(List<String> recipients) {
        this.recipients = recipients;
    }

    @Generated
    public String getSubject() {
        return this.subject;
    }

    @Generated
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Generated
    public File getAnswerFolder() {
        return this.answerFolder;
    }

    @Generated
    public void setAnswerFolder(File answerFolder) {
        this.answerFolder = answerFolder;
    }

    @Generated
    public Object getContentObject() {
        return this.contentObject;
    }

    @Generated
    public void setContentObject(Object contentObject) {
        this.contentObject = contentObject;
    }

    @Generated
    public boolean isPartial() {
        return this.partial;
    }

    @Generated
    public void setPartial(boolean partial) {
        this.partial = partial;
    }

    @Generated
    public AnswerType getAnswerType() {
        return this.answerType;
    }

    @Generated
    public void setAnswerType(AnswerType answerType) {
        this.answerType = answerType;
    }

    @Generated
    public void setMessageObject(Object messageObject) {
        this.messageObject = messageObject;
    }
}

