/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.mailbox;

import ch.admin.smclient.service.ProductVersion;
import ch.admin.smclient.service.repository.FileRepository;
import ch.admin.smclient2.web.compatibility.AppMessages;
import ch.admin.smclient2.web.compatibility.CurrentUserBean;
import ch.admin.smclient2.web.mailbox.ComposeBean;
import ch.admin.smclient2.web.mailbox.ComposeMessageBean;
import ch.admin.smclient2.web.schema.SchemaParser;
import ch.admin.smclient2.web.schema.reflect.InstantiateStrategy;
import ch.admin.smclient2.web.schema.reflect.PropertyIterator;
import ch.admin.smclient2.web.schema.reflect.Strategy;
import ch.admin.smclient2.web.util.JsfUtil;
import ch.ech.xmlns.ech_0058._5.SendingApplicationType;
import ch.ech.xmlns.ech_0097._3.UidStructureType;
import ch.ech.xmlns.ech_0104._5.Contact;
import ch.ech.xmlns.ech_0104._5.ValidityPeriod;
import ch.ech.xmlns.ech_0104_68._5.BenefitCancellationType;
import ch.ech.xmlns.ech_0104_68._5.BenefitMutationType;
import ch.ech.xmlns.ech_0104_68._5.ContentType;
import ch.ech.xmlns.ech_0104_68._5.HeaderType;
import ch.ech.xmlns.ech_0104_68._5.Message;
import ch.ech.xmlns.ech_0104_68._5.NewBenefitType;
import com.sun.xml.xsom.XSSchemaSet;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;

@Controller
@Scope(value="session")
public class ComposeAustauschBean
extends ComposeMessageBean<Message> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComposeAustauschBean.class);
    @Autowired
    private AppMessages appMessages;
    @Autowired
    private ComposeBean composeBean;
    @Autowired
    private CurrentUserBean user;
    @Autowired
    private FileRepository fileRepository;
    @Autowired
    JsfUtil util;
    @Autowired
    ProductVersion productVersion;
    @Autowired
    private SchemaParser schemaParser;
    private PropertyIterator propertyIterator = new PropertyIterator((Strategy)new InstantiateStrategy());
    private String benefitType;
    String field;
    private String validityPeriodType;
    private NewBenefitType newBenefitType;
    private BenefitMutationType benefitMutationType;
    private BenefitCancellationType benefitCancellationType;
    private boolean hasValidityPeriod = false;
    private boolean hasComment = false;
    private boolean hasCancelComment = false;
    private boolean hasSpecialTreatment = false;
    private boolean hasContact = false;
    private boolean hasUid = false;

    public void resetForm() {
        this.benefitType = "";
        this.validityPeriodType = "STANDARD";
        this.hasValidityPeriod = false;
        this.hasContact = false;
        this.hasCancelComment = false;
        this.hasComment = false;
        this.hasUid = false;
        this.hasSpecialTreatment = false;
        this.newBenefitType = new BenefitMutationType();
        this.benefitMutationType = new BenefitMutationType();
        this.benefitCancellationType = new BenefitCancellationType();
        try {
            XSSchemaSet schema = this.schemaParser.parseCurrentSchema();
            this.propertyIterator.setSchemaSet(schema);
            if (this.newBenefitType != null) {
                this.propertyIterator.iterate((Object)this.newBenefitType);
                this.newBenefitType.getChild().setCountryId(1000);
            }
            if (this.benefitMutationType != null) {
                this.propertyIterator.iterate((Object)this.benefitMutationType);
                this.benefitMutationType.getChild().setCountryId(1000);
            }
            if (this.benefitCancellationType != null) {
                this.propertyIterator.iterate((Object)this.benefitCancellationType);
            }
        }
        catch (Exception e) {
            log.error("error while creating benefit type: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void toggleValidityPeriod() {
        boolean bl = this.hasValidityPeriod = !this.hasValidityPeriod;
        if (this.hasValidityPeriod) {
            this.validityPeriodType = "STANDARD";
            ValidityPeriod period = new ValidityPeriod();
            this.newBenefitType.setValidityPeriod(period);
            this.benefitMutationType.setValidityPeriod(period);
        } else {
            this.newBenefitType.setValidityPeriod(null);
            this.benefitMutationType.setValidityPeriod(null);
        }
    }

    public void toggleContact() {
        boolean bl = this.hasContact = !this.hasContact;
        if (this.hasContact) {
            Contact contact = new Contact();
            this.newBenefitType.setContact(contact);
            this.benefitMutationType.setContact(contact);
            Contact.Employer employer = new Contact.Employer();
            contact.setEmployer(employer);
        } else {
            this.newBenefitType.setContact(null);
        }
    }

    public void toggleUid() {
        boolean bl = this.hasUid = !this.hasUid;
        if (this.hasUid) {
            Contact.Employer employer = this.newBenefitType.getContact().getEmployer();
            employer.setUid(new UidStructureType());
            employer = this.benefitMutationType.getContact().getEmployer();
            employer.setUid(new UidStructureType());
        } else {
            Contact contact = this.newBenefitType.getContact();
            contact.setEmployer(null);
        }
    }

    public void toggleSpecialTreatment() {
        boolean bl = this.hasSpecialTreatment = !this.hasSpecialTreatment;
        if (!this.hasSpecialTreatment) {
            this.newBenefitType.setSpecialTreatment(null);
            this.benefitMutationType.setSpecialTreatment(null);
        }
    }

    public void toggleComment() {
        boolean bl = this.hasComment = !this.hasComment;
        if (!this.hasComment) {
            this.newBenefitType.setComment(null);
            this.benefitMutationType.setComment(null);
        }
    }

    public void toggleCancelComment() {
        boolean bl = this.hasComment = !this.hasComment;
        if (!this.hasComment) {
            this.benefitCancellationType.setComment(null);
        }
    }

    public boolean isNewOrMutation() {
        if (this.benefitType == null) {
            return false;
        }
        return this.benefitType.equals("NEW") || this.benefitType.equals("MUTATION");
    }

    public String save(Message message) throws Exception {
        String reference2;
        String reference1;
        List benefits = message.getContent().getNewBenefitsAndBenefitMutationsAndBenefitCancellations();
        benefits.clear();
        switch (this.benefitType) {
            case "": {
                this.appMessages.addError("error", "error benefit type should not be empty", new String[0]);
                break;
            }
            case "NEW": {
                benefits.add(this.newBenefitType);
                break;
            }
            case "MUTATION": {
                benefits.add(this.benefitMutationType);
                break;
            }
            case "CANCELLATION": {
                benefits.add(this.benefitCancellationType);
            }
        }
        String comment = this.benefitCancellationType.getComment();
        if (StringUtils.isEmpty((CharSequence)comment)) {
            this.benefitCancellationType.setComment(null);
        }
        if (StringUtils.isEmpty((CharSequence)(reference1 = this.benefitCancellationType.getInternalOfficeReference()))) {
            this.benefitCancellationType.setInternalOfficeReference(null);
        }
        if (StringUtils.isEmpty((CharSequence)(reference2 = this.newBenefitType.getInternalOfficeReference()))) {
            this.newBenefitType.setInternalOfficeReference(null);
        }
        HeaderType header = message.getHeader();
        header.setAction("1");
        ContentType content = message.getContent();
        message.getHeader().setSenderId(this.user.getMandantSedexId());
        header.setSubject(this.composeBean.getFullSubject());
        header.getRecipientIds().addAll(this.composeBean.getRecipients());
        SendingApplicationType app = new SendingApplicationType();
        app.setManufacturer(this.productVersion.getManufacturer());
        app.setProduct(this.productVersion.getProduct());
        app.setProductVersion(this.productVersion.getProductVersion());
        header.setSendingApplication(app);
        header.setMessageType(this.composeBean.getMessageType().getType());
        header.setSubMessageType(this.composeBean.getMessageType().getSubType());
        header.setMessageDate(this.util.getNow());
        header.setMessageId(this.fileRepository.getPrefixNumber(this.user.getMandantSedexId()).concat(this.util.getMessageId()));
        String schemaFileName = null;
        try {
            schemaFileName = this.composeBean.getSchemaFile(this.composeBean.getMessageType());
            String minorVersion = schemaFileName.substring(schemaFileName.lastIndexOf(45) + 1, schemaFileName.lastIndexOf(46));
            message.setMinorVersion(Integer.parseInt(minorVersion));
        }
        catch (Exception e) {
            log.error("Cannot determine the minor version from the schema file {}", (Object)this.composeBean.getMessageType().getName());
            message.setMinorVersion(0);
        }
        return this.composeBean.save((Object)message);
    }

    @Generated
    public void setBenefitType(String benefitType) {
        this.benefitType = benefitType;
    }

    @Generated
    public String getBenefitType() {
        return this.benefitType;
    }

    @Generated
    public String getField() {
        return this.field;
    }

    @Generated
    public void setField(String field) {
        this.field = field;
    }

    @Generated
    public String getValidityPeriodType() {
        return this.validityPeriodType;
    }

    @Generated
    public void setValidityPeriodType(String validityPeriodType) {
        this.validityPeriodType = validityPeriodType;
    }

    @Generated
    public NewBenefitType getNewBenefitType() {
        return this.newBenefitType;
    }

    @Generated
    public void setNewBenefitType(NewBenefitType newBenefitType) {
        this.newBenefitType = newBenefitType;
    }

    @Generated
    public BenefitMutationType getBenefitMutationType() {
        return this.benefitMutationType;
    }

    @Generated
    public void setBenefitMutationType(BenefitMutationType benefitMutationType) {
        this.benefitMutationType = benefitMutationType;
    }

    @Generated
    public BenefitCancellationType getBenefitCancellationType() {
        return this.benefitCancellationType;
    }

    @Generated
    public void setBenefitCancellationType(BenefitCancellationType benefitCancellationType) {
        this.benefitCancellationType = benefitCancellationType;
    }

    @Generated
    public boolean isHasValidityPeriod() {
        return this.hasValidityPeriod;
    }

    @Generated
    public void setHasValidityPeriod(boolean hasValidityPeriod) {
        this.hasValidityPeriod = hasValidityPeriod;
    }

    @Generated
    public boolean isHasComment() {
        return this.hasComment;
    }

    @Generated
    public void setHasComment(boolean hasComment) {
        this.hasComment = hasComment;
    }

    @Generated
    public boolean isHasCancelComment() {
        return this.hasCancelComment;
    }

    @Generated
    public void setHasCancelComment(boolean hasCancelComment) {
        this.hasCancelComment = hasCancelComment;
    }

    @Generated
    public boolean isHasSpecialTreatment() {
        return this.hasSpecialTreatment;
    }

    @Generated
    public void setHasSpecialTreatment(boolean hasSpecialTreatment) {
        this.hasSpecialTreatment = hasSpecialTreatment;
    }

    @Generated
    public boolean isHasContact() {
        return this.hasContact;
    }

    @Generated
    public void setHasContact(boolean hasContact) {
        this.hasContact = hasContact;
    }

    @Generated
    public boolean isHasUid() {
        return this.hasUid;
    }

    @Generated
    public void setHasUid(boolean hasUid) {
        this.hasUid = hasUid;
    }
}

