/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.mailbox;

import ch.admin.smclient.model.Domain;
import ch.admin.smclient.service.DomainRepository;
import ch.admin.smclient.service.repository.DirectoryRepository;
import ch.admin.smclient2.web.compatibility.AppMessages;
import ch.admin.smclient2.web.compatibility.CurrentUserBean;
import ch.admin.smclient2.web.compatibility.SmClientBundle;
import ch.admin.smclient2.web.mailbox.AddressBookBean;
import ch.admin.smclient2.web.mailbox.Attachment;
import ch.admin.smclient2.web.mailbox.AttachmentAnalyzer;
import ch.admin.smclient2.web.mailbox.AttachmentBean;
import ch.admin.smclient2.web.mailbox.ComposeBean;
import ch.admin.smclient2.web.mailbox.FileUpload;
import ch.admin.smclient2.web.mailbox.MessageFileProducer;
import ch.admin.smclient2.web.mailbox.MessageType;
import ch.admin.smclient2.web.mailbox.ZipMessageInfo;
import ch.admin.smclient2.web.schema.SchemaParser;
import com.sun.xml.xsom.XSSchemaSet;
import jakarta.faces.context.FacesContext;
import jakarta.xml.bind.MarshalException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.primefaces.event.FileUploadEvent;
import org.primefaces.model.file.UploadedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Scope(value="session")
public class AttachmentBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AttachmentBean.class);
    @Autowired
    private AppMessages appMessages;
    private static final String NAV_REDIRECT = "redirect";
    private static final String NAV_BACK = "back";
    private static final String NAV_DONE = "thanks";
    private static final Pattern FILE_NAME_PATTERN = Pattern.compile("[A-Za-z0-9/_\\-.]*");
    List<Attachment> attachments;
    private Attachment attachment;
    private UploadedFile file;
    private Collection<SupportedMimeTypes> mimeType;
    @Autowired
    private AttachmentAnalyzer attachmentAnalyzer;
    private Object messageTransfer;
    private MessageType messageType;
    @Autowired
    private DomainRepository domainRepository;
    @Autowired
    private MessageFileProducer messageFileProducer;
    @Autowired
    private CurrentUserBean user;
    @Autowired
    SchemaParser schemaParser;
    private String currentSchema;
    @Autowired
    private DirectoryRepository directoryRepository;
    private CurrentUserBean currentUserBean;
    @Qualifier(value="smClientBundle")
    @Autowired
    private SmClientBundle smClientBundle;
    @Autowired
    private AddressBookBean addressBookBean;

    public void init(Object Message2) {
        this.messageTransfer = Message2;
        this.initAttachments();
        this.initFileExtensions();
    }

    public void add() throws Exception {
        this.attachments.add(this.attachment);
    }

    public void prepareAttachment() {
        this.attachment = new Attachment();
    }

    public String remove(Attachment attachment) {
        attachment.deleteAll();
        int index = this.attachments.indexOf(attachment);
        this.attachments.remove(index);
        this.attachmentAnalyzer.removeAttachmentObject(this.messageTransfer, index);
        return "redirect";
    }

    public void remove(int index) {
        this.attachments.remove(index);
        this.attachmentAnalyzer.removeAttachmentObject(this.messageTransfer, index);
    }

    public String back() {
        return "ERROR";
    }

    public String getRestrictedLengthFileName(String filename) {
        int filenameLength = filename.length();
        if (filenameLength > 36) {
            return filename.substring(0, 28) + "..." + filename.substring(filenameLength - 8);
        }
        return filename;
    }

    private boolean isFileInAttachmentsList(String name) {
        return this.attachments.stream().flatMap(a -> a.getFiles().stream()).peek(fu -> log.debug("isFileInAttachmentsList(): Name checked {0} against {1}", (Object)fu.getName(), (Object)name)).anyMatch(fu -> fu.getName().equals(name));
    }

    public void validateUpload() {
        List files = this.attachment.getNewFiles();
        Iterator fileIt = files.iterator();
        while (fileIt.hasNext()) {
            FileUpload next = (FileUpload)fileIt.next();
            log.debug("validateUpload(): File to add:" + next.getName());
            if (!next.isValid()) {
                this.appMessages.addError("error", "attachment.invalid.mimetype", new String[0]);
                fileIt.remove();
                FileUtils.deleteQuietly((File)next.getFile());
                continue;
            }
            if (this.isFileInAttachmentsList(next.getName())) {
                log.info("i-0302 | validateUpload(): File already exists:" + next.getName());
                this.appMessages.addError("error", "attachment.file.alreadyexists", new String[0]);
                fileIt.remove();
                FileUtils.deleteQuietly((File)next.getFile());
                continue;
            }
            if (!this.isFileNameValid(next.getName())) {
                this.appMessages.addError("error", "attachment.invalid.filename", new String[0]);
                fileIt.remove();
                FileUtils.deleteQuietly((File)next.getFile());
                continue;
            }
            log.debug("validateUpload(): File added:" + next.getName());
            this.attachment.files.add(next);
        }
        files.clear();
    }

    private boolean isFileNameValid(String name) {
        return FILE_NAME_PATTERN.matcher(name).matches();
    }

    public boolean isAttachmentList() {
        return this.attachmentAnalyzer.extractAttachmentObject(this.messageTransfer) instanceof List;
    }

    public boolean isStringType() throws Exception {
        return !String.class.isAssignableFrom(this.attachmentAnalyzer.extractDocumentType());
    }

    public String save(Object message) throws Exception {
        XSSchemaSet schema = this.schemaParser.parseCurrentSchema();
        Object messageTransfer = ComposeBean.processFields((Object)message, (XSSchemaSet)schema, (MessageType)this.messageType);
        if (!this.hasFilesInAttachments()) {
            this.appMessages.addError("error", "attachment.error.empty", new String[0]);
            return null;
        }
        Domain domain = this.domainRepository.findByName(this.messageType.getDomain());
        ZipMessageInfo zipMessageInfo = new ZipMessageInfo(messageTransfer, this.currentSchema(), this.attachments, domain.getName());
        this.attachmentAnalyzer.setSuffix(this.messageFileProducer.getSuffix(zipMessageInfo));
        this.attachmentAnalyzer.fillAttachments(messageTransfer, this.attachments);
        try {
            this.messageFileProducer.createZipMessage(this.user.getMandantSedexId(), zipMessageInfo, domain);
        }
        catch (MarshalException e) {
            this.appMessages.addError(e.getMessage(), e.getMessage(), new String[0]);
            return null;
        }
        this.addressBookBean.reset();
        return "/compose/confirm.xhtml?faces-redirect=true";
    }

    public void addFileExtension(String supportedMimeTypeName) {
        this.addFileExtension(SupportedMimeTypes.valueOf((String)supportedMimeTypeName));
    }

    private void initAttachments() {
        this.attachments = new LinkedList();
        this.attachment = new Attachment();
        this.attachmentAnalyzer.init();
    }

    private void initFileExtensions() {
        this.mimeType = EnumSet.of(SupportedMimeTypes.TIFF, SupportedMimeTypes.PDF);
    }

    private void addFileExtension(SupportedMimeTypes supportedMimeType) {
        this.mimeType.add(supportedMimeType);
    }

    private boolean hasFilesInAttachments() {
        for (Attachment att : this.attachments) {
            if (att.getFiles() == null || att.getFiles().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Collection<SupportedMimeTypes> getMimeType() {
        return Collections.unmodifiableCollection(this.mimeType);
    }

    public Map<String, String> getFileExtensions() {
        return Collections.unmodifiableMap(this.mimeType.stream().collect(Collectors.toMap(SupportedMimeTypes::getMimeType, SupportedMimeTypes::getAllExtensions)));
    }

    private String currentSchema() {
        return (String)FacesContext.getCurrentInstance().getExternalContext().getSessionMap().get("schemaFileName");
    }

    public List<Attachment> getAttachments() {
        if (this.attachments == null) {
            this.attachments = new ArrayList();
        }
        return this.attachments;
    }

    public Attachment getAttachment() {
        if (this.attachment == null) {
            this.attachment = new Attachment();
        }
        return this.attachment;
    }

    public void uploadListener(FileUploadEvent event) throws IOException {
        this.attachment.uploadFinished(event);
        this.validateUpload();
    }

    public boolean canAddAttachment() {
        return !this.attachment.files.isEmpty();
    }

    @Generated
    public void setAttachment(Attachment attachment) {
        this.attachment = attachment;
    }

    @Generated
    public UploadedFile getFile() {
        return this.file;
    }

    @Generated
    public void setFile(UploadedFile file) {
        this.file = file;
    }

    @Generated
    public Object getMessageTransfer() {
        return this.messageTransfer;
    }

    @Generated
    public void setMessageTransfer(Object messageTransfer) {
        this.messageTransfer = messageTransfer;
    }

    @Generated
    public MessageType getMessageType() {
        return this.messageType;
    }

    @Generated
    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    @Generated
    public String getCurrentSchema() {
        return this.currentSchema;
    }

    @Generated
    public void setCurrentSchema(String currentSchema) {
        this.currentSchema = currentSchema;
    }
}

