/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.mailbox;

import ch.admin.smclient2.web.compatibility.CurrentUserBean;
import ch.admin.smclient2.web.mailbox.Attachment;
import ch.admin.smclient2.web.mailbox.FileUpload;
import ch.admin.smclient2.web.schema.MinOccursVisitor;
import ch.admin.smclient2.web.schema.ObjectFactory;
import ch.admin.smclient2.web.schema.SchemaParser;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.visitor.XSContentTypeVisitor;
import jakarta.faces.context.FacesContext;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.jxpath.JXPathContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AttachmentAnalyzer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AttachmentAnalyzer.class);
    private static final String ATTACHMENT_XML_PATH = "header/attachments";
    private static final String HEADER_TYPE = "headerType";
    private static final String ATTACHMENT_TYPE = "attachmentType";
    private static final String ATTACHMENT_FILE_TYPE = "attachmentFileType";
    private static final String COMMON_IDENT = "eahv_iv_common";
    private static final String ATTACHMENT_PREFIX = "attachments";
    private static final int SORT_ORDER_START = 1;
    private String suffix;
    private XSComplexType headerType;
    private XSComplexType attachmentType;
    private XSComplexType attachmentFileType;
    private XSComplexType extensionType;
    private Boolean needsDocType;
    private Boolean needsDocDate;
    private Boolean needsAttachments;
    @Autowired
    private ObjectFactory objectFactory;
    @Autowired
    private SchemaParser schemaParser;
    @Autowired
    private CurrentUserBean user;

    public void init() {
        Iterator types = this.lookupSchema().iterateComplexTypes();
        while (types.hasNext()) {
            XSComplexType type = (XSComplexType)types.next();
            if (this.isType(type.getName(), ATTACHMENT_TYPE) && (this.attachmentType == null || this.isCommon(this.attachmentType.getTargetNamespace()))) {
                this.attachmentType = type;
                continue;
            }
            if (this.isType(type.getName(), ATTACHMENT_FILE_TYPE) && (this.attachmentFileType == null || this.isCommon(this.attachmentFileType.getTargetNamespace()))) {
                this.attachmentFileType = type;
                continue;
            }
            if (!this.isType(type.getName(), HEADER_TYPE) || this.headerType != null && !this.isCommon(this.headerType.getTargetNamespace())) continue;
            this.headerType = type;
        }
        if (!this.typesFound()) {
            log.warn("w-0301 | init(): Could not initialize properly: attachmentType=" + this.attachmentType + ",attachmentFileType=" + this.attachmentFileType + ",headerType=" + this.headerType);
        }
    }

    public boolean isComplete() {
        return this.typesFound();
    }

    public boolean isDocTypeRequired() {
        if (this.needsDocType != null) {
            return this.needsDocType;
        }
        this.needsDocType = this.isRequired("documentType", this.attachmentType);
        return this.needsDocType;
    }

    public boolean isDocDateRequired() {
        if (this.needsDocDate != null) {
            return this.needsDocDate;
        }
        this.needsDocDate = this.isRequired("documentDate", this.attachmentType);
        return this.needsDocDate;
    }

    public boolean isAttachmentsRequired() {
        if (this.needsAttachments != null) {
            return this.needsAttachments;
        }
        this.needsAttachments = this.isRequired("attachment", this.headerType) || this.isRequired("attachment", this.extensionType);
        return this.needsAttachments;
    }

    public Object fillAttachments(Object message, List<Attachment> attachments) throws Exception {
        Object object = this.extractAttachmentObject(message);
        if (object instanceof List) {
            this.fillAttachmentList((List)object, attachments);
        } else {
            this.setAttachment(message, attachments.get(0));
        }
        return message;
    }

    public void addAttachmentObject(Object messageObject) {
        try {
            Object object = this.extractAttachmentObject(messageObject);
            if (object instanceof List) {
                List list = (List)object;
                ((List)object).add(this.instanceOf(this.attachmentType));
            } else {
                this.putAttachmentObject(messageObject, this.instanceOf(this.attachmentType));
            }
        }
        catch (Exception e) {
            log.error("Error adding attachment {}", (Throwable)e);
        }
    }

    public void removeAttachmentObject(Object messageObject, int index) {
        Object object = this.extractAttachmentObject(messageObject);
        if (object instanceof List) {
            ((List)object).remove(index);
        }
    }

    public Object extractAttachmentObject(Object message) {
        JXPathContext mainContext = JXPathContext.newContext((Object)message);
        return mainContext.getValue(ATTACHMENT_XML_PATH);
    }

    public void putAttachmentObject(Object message, Object attachment) {
        JXPathContext mainContext = JXPathContext.newContext((Object)message);
        mainContext.setValue(ATTACHMENT_XML_PATH, attachment);
    }

    public Class<?> extractDocumentType() throws Exception {
        Object attInstance = this.instanceOf(this.attachmentType);
        Field documentType = attInstance.getClass().getDeclaredField("documentType");
        return documentType.getType();
    }

    private Object mergeAttachment(Attachment attachment, int counter, Object attInstance) throws Exception {
        JXPathContext attContext = JXPathContext.newContext((Object)attInstance);
        attContext.setValue("leadingDocument", (Object)(counter == 1 ? 1 : 0));
        attContext.setValue("sortOrder", (Object)counter++);
        attContext.setValue("documentFormat", (Object)attachment.getFileType());
        List fileList = (List)attContext.getValue("files");
        this.fillFileList(fileList, attachment);
        return attInstance;
    }

    private XSSchemaSet lookupSchema() {
        return this.schemaParser.parseSchema(this.user.getMandantSedexId(), this.currentSchema());
    }

    private String currentSchema() {
        Map session = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
        return (String)session.get("schemaFileName");
    }

    private boolean isType(String name, String typeName) {
        return name != null && name.toLowerCase().startsWith(typeName.toLowerCase());
    }

    private boolean typesFound() {
        return this.attachmentType != null && this.attachmentFileType != null && this.headerType != null;
    }

    private Object instanceOf(XSComplexType type) throws Exception {
        String name = this.objectFactory.toClassName(type.getTargetNamespace(), type.getName());
        Class<?> toClass = Class.forName(name);
        return toClass.newInstance();
    }

    private boolean isRequired(String elemName, XSComplexType type) {
        if (type == null) {
            return false;
        }
        MinOccursVisitor visitor = new MinOccursVisitor(elemName);
        type.getContentType().visit((XSContentTypeVisitor)visitor);
        return visitor.getMinOccurs() > 0;
    }

    private void fillAttachmentList(List<Object> attachmentList, List<Attachment> attachments) throws Exception {
        for (int i = 0; i < attachments.size(); ++i) {
            Attachment attachment = attachments.get(i);
            this.mergeAttachment(attachment, 1, attachmentList.get(i));
        }
    }

    private void setAttachment(Object message, Attachment attachment) throws Exception {
        Object attachmentObject = this.extractAttachmentObject(message);
        this.mergeAttachment(attachment, 1, attachmentObject);
    }

    private void fillFileList(List<Object> fileList, Attachment attachment) throws Exception {
        fileList.clear();
        int counter = 1;
        for (FileUpload upload : attachment.getFiles()) {
            Object attFileInstance = this.instanceOf(this.attachmentFileType);
            JXPathContext attFileContext = JXPathContext.newContext((Object)attFileInstance);
            String name = new String(upload.getName().getBytes(), StandardCharsets.UTF_8);
            log.debug("fillFileList(): add filename to list " + upload.getName() + " utf-8 " + name);
            attFileContext.setValue("pathFileName", (Object)(ATTACHMENT_PREFIX + this.suffix + "/" + upload.getName()));
            attFileContext.setValue("internalSortOrder", (Object)counter++);
            fileList.add(attFileInstance);
        }
    }

    private boolean isCommon(String namespace) {
        return namespace != null && namespace.contains(COMMON_IDENT);
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }
}

