/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.mailbox;

import ch.admin.smclient.util.MimeTypeUtil;
import ch.admin.smclient2.web.mailbox.FileUpload;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.primefaces.event.FileUploadEvent;
import org.primefaces.model.file.UploadedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Attachment {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Attachment.class);
    private String fileType;
    public List<FileUpload> files = new LinkedList();
    private List<FileUpload> newFiles = new LinkedList();

    public void uploadFinished(FileUploadEvent event) throws IOException {
        UploadedFile item = event.getFile();
        String filename = FilenameUtils.getName((String)item.getFileName());
        String baseName = FilenameUtils.getBaseName((String)filename);
        String extension = FilenameUtils.getExtension((String)filename);
        File newFile = File.createTempFile(baseName, extension);
        try (InputStream input = item.getInputStream();){
            Files.copy(input, Path.of(newFile.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        boolean valid = this.isValid(item, filename);
        log.debug("uploadFinished(): added file " + filename);
        this.newFiles.add(new FileUpload(newFile, filename, valid));
    }

    public void delete(FileUpload file) {
        FileUtils.deleteQuietly((File)file.getFile());
        this.files.remove(file);
    }

    public void up(FileUpload file) {
        int index = this.files.indexOf(file);
        if (index >= 1) {
            this.files.remove(file);
            this.files.add(index - 1, file);
        }
    }

    public void down(FileUpload file) {
        int index = this.files.indexOf(file);
        if (index >= 0 && index < this.files.size() - 1) {
            this.files.remove(file);
            this.files.add(index + 1, file);
        }
    }

    void deleteAll() {
        for (FileUpload fileUpload : this.files) {
            FileUtils.deleteQuietly((File)fileUpload.getFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValid(UploadedFile file, String name) {
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(file.getInputStream());
            boolean bl = MimeTypeUtil.checkFileExtensionAgainstFileContent((InputStream)in, (String)name);
            return bl;
        }
        catch (FileNotFoundException t) {
            log.info("i-0301 | isValid(): uploaded file not found", (Throwable)t);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            log.info("i-0301 | isValid(): io exception {}", (Object)e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public List<FileUpload> getFiles() {
        return this.files;
    }

    public List<FileUpload> getNewFiles() {
        return this.newFiles;
    }
}

