/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.mailbox;

import ch.admin.smclient.model.Domain;
import ch.admin.smclient.model.Message;
import ch.admin.smclient.model.validate.message.Answer;
import ch.admin.smclient.model.validate.message.MessageDefinition;
import ch.admin.smclient.process.AuditTrail;
import ch.admin.smclient.service.DomainParameters;
import ch.admin.smclient.service.DomainRepository;
import ch.admin.smclient.service.StatusCode;
import ch.admin.smclient.service.postfach.MailboxFolder;
import ch.admin.smclient.service.postfach.MailboxService;
import ch.admin.smclient.service.repository.FileRepository;
import ch.admin.smclient.util.ZipTool;
import ch.admin.smclient2.web.compatibility.AppMessages;
import ch.admin.smclient2.web.mailbox.AddressBookBean;
import ch.admin.smclient2.web.mailbox.AnswerBean;
import ch.admin.smclient2.web.mailbox.AnswerType;
import ch.admin.smclient2.web.mailbox.ComposeBean;
import ch.admin.smclient2.web.mailbox.MessageFileProducer;
import ch.admin.smclient2.web.mailbox.MessageType;
import ch.admin.smclient2.web.mailbox.ZipMessageInfo;
import ch.admin.smclient2.web.schema.ObjectFactory;
import ch.admin.smclient2.web.util.JsfUtil;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;

@Controller
@Scope(value="session")
public class AnswerBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnswerBean.class);
    @Autowired
    FileRepository fileRepository;
    @Autowired
    ObjectFactory objectFactory;
    @Autowired
    ComposeBean composeBean;
    @Autowired
    AddressBookBean addressBookBean;
    @Autowired
    MailboxService mailboxService;
    @Autowired
    MessageFileProducer messageFileProducer;
    @Autowired
    JsfUtil util;
    @Autowired
    private AppMessages appMessages;
    @Autowired
    private DomainRepository domainRepository;
    AuditTrail auditTrail;
    private static final Pattern VERSION_WO_NUMBERS_PATTERN = Pattern.compile("(.+?)-\\d+?-\\d+?\\d{1}");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateAnswer(AnswerType answerType, Message currentMessage) {
        Object page = "answer";
        File tmpDir = null;
        try {
            File messageFile = currentMessage.getMessageLocation();
            tmpDir = ZipTool.createTempDir((String)"answer");
            ZipTool.extractZip((File)messageFile, (File)tmpDir);
            String type = currentMessage.getMessageType();
            String subtype = currentMessage.getSubMessageType();
            this.composeBean.setMessageType(new MessageType("", type, subtype));
            this.composeBean.setSubject(currentMessage.getSubject());
            ArrayList<String> recipients = new ArrayList<String>();
            this.addressBookBean.reset();
            this.addressBookBean.setRecipients(recipients);
            String sedexId = currentMessage.getMandant().getSedexId();
            String versionName = currentMessage.getVersion();
            String schema = this.fileRepository.getSchemaLocation(sedexId, versionName);
            File catelogFile = this.fileRepository.getCatalogWithPublicReferences(sedexId);
            Object object = this.objectFactory.loadObject(schema, messageFile, catelogFile);
            Object answerObject = null;
            String answerSchema = null;
            MessageDefinition definition = this.fileRepository.getMessageDefinition(sedexId, type, subtype);
            String domName = definition.getDomain();
            ZipMessageInfo zipMessageInfo = new ZipMessageInfo(object, schema, tmpDir, domName);
            switch (1.$SwitchMap$ch$admin$smclient2$web$mailbox$AnswerType[answerType.ordinal()]) {
                case 1: {
                    Answer answer = (Answer)this.fileRepository.getAnswer(sedexId, type, subtype).orElseThrow(() -> new IllegalStateException("no answer defined in message-list.xml for messageType: " + type + "-" + subtype));
                    answerSchema = this.fileRepository.getSchemaFile(sedexId, answer.getType(), answer.getSubtype());
                    answerObject = this.objectFactory.createObjectFromSchema(sedexId, answerSchema, catelogFile);
                    recipients.add(currentMessage.getSenderId());
                    MessageDefinition messageListObject = this.fileRepository.getMessageDefinition(sedexId, answer.getType(), answer.getSubtype());
                    this.composeBean.setMessageType(new MessageType(messageListObject));
                    String customForm = messageListObject.getCustomViewName();
                    if (customForm != null && !customForm.trim().equals("")) {
                        page = (String)page + "_custom";
                    }
                    Object subject = currentMessage.getSubject();
                    String subjectPrefix = this.getSubjectPrefix(messageListObject);
                    subject = subjectPrefix + " - " + ((String)subject).substring(((String)subject).indexOf(" - ") + 3);
                    this.composeBean.setSubject((String)subject);
                    break;
                }
                case 2: {
                    recipients.add(currentMessage.getSenderId());
                    String namespace = versionName;
                    int index2 = namespace.lastIndexOf(47, namespace.lastIndexOf(47) - 1);
                    namespace = namespace.substring(0, index2 + 1);
                    String version = currentMessage.getVersionSuffix();
                    Matcher m = VERSION_WO_NUMBERS_PATTERN.matcher(version);
                    if (m.find()) {
                        String prefix = m.group(1);
                        String messageType = namespace + prefix + "-common/" + version.substring(version.lastIndexOf("-") + 1);
                        answerSchema = this.fileRepository.getSchemaLocation(sedexId, messageType);
                        if (answerSchema == null) {
                            answerSchema = this.fileRepository.getSchemaLocation(sedexId, messageType.substring(0, messageType.lastIndexOf(47)));
                        }
                        if (answerSchema == null) {
                            answerSchema = this.fileRepository.getSchemaLocation(sedexId, "http://www.ech.ch/xmlns/eCH-0058/");
                        }
                        answerObject = this.objectFactory.createObjectFromSchema(sedexId, answerSchema, catelogFile);
                        break;
                    }
                    this.appMessages.addError("error", "answer.specialist.feedback.could.not.send", new String[0]);
                    String prefix = null;
                    return prefix;
                }
                case 3: {
                    String messageId = this.fileRepository.getPrefixNumber(sedexId) + this.util.getMessageId();
                    this.removeSmclientGeneratedFiles(tmpDir);
                    try {
                        PropertyUtils.setProperty((Object)object, (String)"header.messageId", (Object)messageId);
                    }
                    catch (Exception e) {
                        PropertyUtils.setProperty((Object)object, (String)"reportHeader.messageId", (Object)messageId);
                    }
                    Domain domain = this.domainRepository.findByName(domName);
                    this.messageFileProducer.createZipMessage(sedexId, zipMessageInfo, domain);
                    this.appMessages.addError("error", "compose.message.send", new String[0]);
                    this.auditTrail.persistMessage(currentMessage, Message.MessageState.RESEND, null, null);
                    String string = null;
                    return string;
                }
                case 4: {
                    page = "forward";
                    this.removeSmclientGeneratedFiles(tmpDir);
                    this.composeBean.setAnswerFolder(tmpDir);
                    Object content = new Object();
                    try {
                        content = PropertyUtils.getProperty((Object)object, (String)"content");
                        PropertyUtils.setProperty((Object)object, (String)"content", null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.composeBean.setContentObject(content);
                    answerObject = object;
                    answerSchema = schema;
                }
            }
            this.mailboxService.moveMessage(currentMessage, MailboxFolder.DELETED, Message.MessageState.ANSWER);
            this.copyProperties(answerType, object, answerObject);
            this.composeBean.setAnswerType(answerType);
            this.putInContext(answerSchema, answerObject);
        }
        catch (Exception e) {
            log.info("Can't reply to message {0}. ({1})", (Object)currentMessage.getMessageId(), (Object)e.toString());
            log.debug("Can't reply to message {0}. ({1})", new Object[]{e, currentMessage.getMessageId(), e.getMessage()});
            this.appMessages.addError("error", "viewmsgheader.messageDeleted", new String[0]);
            String string = null;
            return string;
        }
        finally {
            this.deleteDirIfNotNeededAnymore(tmpDir, answerType);
        }
        return page;
    }

    private void deleteDirIfNotNeededAnymore(File tmpDir, AnswerType answerType) {
        if (answerType != AnswerType.FORWARD) {
            FileUtils.deleteQuietly((File)tmpDir);
        }
    }

    private void removeSmclientGeneratedFiles(File tmpDir) {
        WildcardFileFilter wildcardFileFilter = new WildcardFileFilter(this.getUnwantedFilesWildcards(), IOCase.INSENSITIVE);
        FileUtils.listFiles((File)tmpDir, (IOFileFilter)wildcardFileFilter, (IOFileFilter)FileFilterUtils.trueFileFilter()).forEach(FileUtils::deleteQuietly);
    }

    private List<String> getUnwantedFilesWildcards() {
        return Arrays.asList(StatusCode.MessageType.ERROR_XML_NAME.getFileName("*"), "*receipt*.xml");
    }

    public boolean canAnswer(Message currentMessage) throws Exception {
        return this.fileRepository.getAnswer(currentMessage.getMandant().getSedexId(), currentMessage.getMessageType(), currentMessage.getSubMessageType()).isPresent();
    }

    public boolean canForward(Message currentMessage) {
        return currentMessage != null && !currentMessage.getMessageType().equals(DomainParameters.ELM.getName());
    }

    void copyProperties(AnswerType type, Object source, Object dest) throws Exception {
        Properties copyProperties = new Properties();
        try (InputStream resource = this.getClass().getResourceAsStream("/" + type.name().toLowerCase() + ".properties");){
            if (resource != null) {
                copyProperties.load(resource);
            }
        }
        Set<String> keys = copyProperties.stringPropertyNames();
        for (String destKey : keys) {
            String sourceKey = (String)copyProperties.get(destKey);
            Object value = null;
            if (sourceKey.startsWith("_")) {
                if (sourceKey.length() != 1) {
                    value = sourceKey.substring(1);
                }
            } else {
                try {
                    value = PropertyUtils.getProperty((Object)source, (String)sourceKey);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            try {
                PropertyUtils.setProperty((Object)dest, (String)destKey, (Object)value);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
    }

    void putInContext(String answerSchema, Object answerObject) {
        this.composeBean.putInContext(answerSchema, answerObject);
    }

    String getSubjectPrefix(MessageDefinition messageListObject) {
        return new MessageType(messageListObject).getBundleName();
    }
}

