/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.mailbox;

import ch.admin.smclient.model.validate.participant.Participant;
import ch.admin.smclient.service.repository.FileRepository;
import ch.admin.smclient2.web.compatibility.CurrentUserBean;
import ch.admin.smclient2.web.mailbox.AddressBookBean;
import ch.admin.smclient2.web.mailbox.MessageType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="session")
public class AddressBookBean {
    @Autowired
    FileRepository fileRepository;
    @Autowired
    CurrentUserBean user;
    private List<AddressBookEntry> addresses;
    private List<AddressBookEntry> selectedAddresses;
    private List<String> recipients;

    public List<AddressBookEntry> initAddressBook(MessageType messageType) throws Exception {
        if (messageType != null) {
            this.addresses = new ArrayList();
            HashSet<AddressBookEntry> result = new HashSet<AddressBookEntry>();
            List participants = this.fileRepository.getParticipants(this.user.getMandantSedexId(), messageType.getType(), messageType.getSubType());
            for (Participant participant : participants) {
                result.add(new AddressBookEntry(participant));
            }
            this.addresses.addAll(result);
        }
        return this.addresses;
    }

    public void reset() {
        this.recipients = new ArrayList();
        this.addresses = new ArrayList();
        this.selectedAddresses = new ArrayList();
    }

    public void save() {
        this.recipients = this.selectedAddresses.stream().map(AddressBookEntry::getSedexId).toList();
    }

    public String next() {
        if (this.user.isTestPlatformUser().booleanValue()) {
            this.recipients = new ArrayList();
            this.recipients.add(this.user.getLogicSedexId());
        } else if (this.recipients == null || this.recipients.isEmpty()) {
            return null;
        }
        return "/compose/compose-3003-1.xhtml";
    }

    public List<String> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(List<String> recipients) {
        this.recipients = recipients;
    }

    public List<AddressBookEntry> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<AddressBookEntry> addresses) {
        this.addresses = addresses;
    }

    @Generated
    public List<AddressBookEntry> getSelectedAddresses() {
        return this.selectedAddresses;
    }

    @Generated
    public void setSelectedAddresses(List<AddressBookEntry> selectedAddresses) {
        this.selectedAddresses = selectedAddresses;
    }
}

