/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.compatibility;

import ch.admin.smclient.model.User;
import ch.admin.smclient.service.repository.DirectoryRepository;
import ch.admin.smclient2.web.application.SmcUserPrincipal;
import ch.admin.smclient2.web.compatibility.CurrentLocale;
import ch.admin.smclient2.web.compatibility.SmClientBundleLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.context.annotation.ApplicationScope;

@Component
@ApplicationScope
public class SmClientBundle
extends ResourceBundle
implements ApplicationContextAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SmClientBundle.class);
    private static ApplicationContext context;
    private final Map<Locale, List<ResourceBundle>> bundleCache = new ConcurrentHashMap();

    public static ResourceBundle getBundle() {
        return ResourceBundle.getBundle(SmClientBundle.class.getName(), CurrentLocale.getLocale());
    }

    private List<ResourceBundle> getBundlesForCurrentLocale() {
        Locale instance = CurrentLocale.getLocale();
        List bundles = (List)this.bundleCache.get(instance);
        if (bundles == null) {
            bundles = this.loadBundlesForCurrentLocale();
            this.bundleCache.put(instance, bundles);
        }
        return bundles;
    }

    private List<ResourceBundle> loadBundlesForCurrentLocale() {
        DirectoryRepository directoryRepository = this.getDirectoryRepository();
        User user = this.getUser();
        ArrayList<ResourceBundle> bundles = new ArrayList<ResourceBundle>();
        for (String bundleName : SmClientBundleLoader.getBundleNames()) {
            ResourceBundle bundle = SmClientBundleLoader.loadBundle((String)bundleName, (DirectoryRepository)directoryRepository, (User)user);
            if (bundle == null) continue;
            bundles.add(bundle);
        }
        ResourceBundle bundle = SmClientBundleLoader.loadBundle((String)"ValidatorMessages", (DirectoryRepository)directoryRepository, (User)user);
        if (bundle != null) {
            bundles.add(bundle);
        }
        if ((bundle = SmClientBundleLoader.loadBundle((String)"org/hibernate/validator/ValidationMessages", (DirectoryRepository)directoryRepository, (User)user)) != null) {
            bundles.add(bundle);
        }
        if ((bundle = SmClientBundleLoader.loadBundle((String)"javax.faces.Messages", (DirectoryRepository)directoryRepository, (User)user)) != null) {
            bundles.add(bundle);
        }
        return Collections.unmodifiableList(bundles);
    }

    private User getUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Object object = authentication.getPrincipal();
        if (object instanceof SmcUserPrincipal) {
            SmcUserPrincipal smcUserPrincipal = (SmcUserPrincipal)object;
            return smcUserPrincipal.getUser();
        }
        return null;
    }

    private DirectoryRepository getDirectoryRepository() {
        return (DirectoryRepository)context.getBean(DirectoryRepository.class);
    }

    @Override
    @NonNull
    public Enumeration<String> getKeys() {
        List<Enumeration> keys = this.getBundlesForCurrentLocale().stream().map(ResourceBundle::getKeys).toList();
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected Object handleGetObject(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        for (ResourceBundle littleBundle : this.getBundlesForCurrentLocale()) {
            try {
                Object result = littleBundle.getObject(key);
                if (result instanceof String) {
                    String message = (String)result;
                    return message;
                }
                return result;
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        return null;
    }

    @Override
    public Locale getLocale() {
        return CurrentLocale.getLocale();
    }

    @Bean
    public SmClientBundle dummyBuild() {
        return new SmClientBundle();
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        if (applicationContext == null) {
            throw new NullPointerException("applicationContext is marked non-null but is null");
        }
        context = applicationContext;
    }
}

