/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.compatibility;

import ch.admin.smclient.model.Mandant;
import ch.admin.smclient.service.MandantRepository;
import jakarta.faces.model.SelectItem;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="loginBean")
@Scope(value="view")
public class LoginBean {
    private static final String SUPER_USER_MANDANT = "smClient-su";
    @Autowired
    MandantRepository mandantRepository;
    private List<Mandant> activeMandanten;
    private List<SelectItem> mandantenDropdown;

    public boolean isMandantenDropDownNeeded() {
        return this.getActiveMandanten().size() > 1;
    }

    public List<SelectItem> getMandanten() {
        if (this.mandantenDropdown == null) {
            this.mandantenDropdown = new ArrayList();
            this.mandantenDropdown.add(new SelectItem((Object)"", SUPER_USER_MANDANT));
            for (Mandant mandant : this.getActiveMandanten()) {
                this.mandantenDropdown.add(new SelectItem((Object)mandant.getSedexId(), mandant.getName()));
            }
        }
        return this.mandantenDropdown;
    }

    public List<Mandant> getAllMandanten() {
        return this.mandantRepository.findAllAdmin();
    }

    private List<Mandant> getActiveMandanten() {
        if (this.activeMandanten == null) {
            this.activeMandanten = this.mandantRepository.findAllActive();
        }
        return this.activeMandanten;
    }
}

