/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.compatibility;

import ch.admin.smclient.model.Mandant;
import ch.admin.smclient.model.User;
import ch.admin.smclient2.web.application.SmcUserPrincipal;
import java.util.Collection;
import java.util.Locale;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class CurrentUserBean {
    public String getMandantSedexId() {
        return this.getUser().getMandantSedexId();
    }

    public String getDefaultLanguage() {
        return this.getUser().getDefaultLanguage();
    }

    public String getLogicSedexId() {
        return this.getUser().getLogicSedexId();
    }

    public Mandant getMandant() {
        return this.getUser().getMandant();
    }

    public String getFirstname() {
        return this.getUser().getFirstname();
    }

    public String getLastname() {
        return this.getUser().getLastname();
    }

    public Collection<? extends GrantedAuthority> getRole() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication.getAuthorities();
    }

    public String getDescription() {
        return "<description>";
    }

    public String getUsername() {
        return this.getUser().getUsername();
    }

    public String getUsernameAndMandant() {
        User user = this.getUser();
        return String.format("%s, %s", user.getUsername(), user.getMandantSedexId());
    }

    public Locale getUserLocale() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Object object = authentication.getPrincipal();
        if (object instanceof SmcUserPrincipal) {
            SmcUserPrincipal smcUserPrincipal = (SmcUserPrincipal)object;
            return smcUserPrincipal.getLocale();
        }
        return Locale.getDefault();
    }

    public Boolean isAhviv() {
        return this.getRole().stream().anyMatch(r -> r.getAuthority().contains("TestPlatformAhvivUser"));
    }

    public Boolean isTestPlatformUser() {
        return this.getRole().stream().anyMatch(r -> r.getAuthority().contains("TestPlatformUser"));
    }

    public Boolean isMonitoring() {
        return this.getRole().stream().anyMatch(r -> r.getAuthority().contains("monitoring"));
    }

    public User getUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Object object = authentication.getPrincipal();
        if (object instanceof SmcUserPrincipal) {
            SmcUserPrincipal smcUserPrincipal = (SmcUserPrincipal)object;
            return smcUserPrincipal.getUser();
        }
        throw new IllegalStateException("Missing authentication");
    }
}

