/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.compatibility;

import ch.admin.smclient2.web.compatibility.CurrentUserBean;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.context.FacesContext;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AppMessages {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppMessages.class);
    @Autowired
    private CurrentUserBean userBean;
    private ResourceBundle messages;

    private ResourceBundle getMessages() {
        if (this.messages == null) {
            try {
                this.messages = ResourceBundle.getBundle("messages", this.userBean.getUserLocale());
            }
            catch (MissingResourceException e) {
                log.warn("Missing resource bundle for application messages");
            }
        }
        return this.messages;
    }

    private void add(FacesMessage.Severity severity, String summary, String detail, String ... params) {
        String message;
        this.messages = this.getMessages();
        try {
            if (this.messages == null) {
                message = detail;
            } else {
                String template = this.messages.getString(detail);
                message = MessageFormat.format(template, params);
            }
        }
        catch (MissingResourceException e) {
            message = summary;
        }
        FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(severity, message, null));
    }

    public void addInfo(String summary, String detail, String ... params) {
        this.add(FacesMessage.SEVERITY_INFO, summary, detail, params);
    }

    public void addWarning(String summary, String detail, String ... params) {
        this.add(FacesMessage.SEVERITY_WARN, summary, detail, params);
    }

    public void addError(String summary, String detail, String ... params) {
        this.add(FacesMessage.SEVERITY_ERROR, summary, detail, params);
    }
}

