/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.application;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;

public class SmcAuthenticationSuccessHandler
implements AuthenticationSuccessHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SmcAuthenticationSuccessHandler.class);
    private final RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        this.handle(request, response, authentication);
        this.clearAuthenticationAttributes(request);
    }

    protected void handle(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        Collection authorities = authentication.getAuthorities();
        List<String> roles = authorities.stream().map(GrantedAuthority::getAuthority).toList();
        if (roles.contains("ROLE_SuperUser")) {
            log.info("SuperAdmin logging in");
            this.redirectStrategy.sendRedirect(request, response, "/audit/mandant.xhtml");
        } else if (roles.contains("ROLE_Admin")) {
            log.info("Admin logging in");
            this.redirectStrategy.sendRedirect(request, response, "/audit/property.xhtml");
        } else if (roles.contains("ROLE_ActiveUser")) {
            log.info("ActiveUser logging in");
            this.redirectStrategy.sendRedirect(request, response, "/compose/compose.xhtml");
        } else {
            log.info("PassiveUser or default logging in");
            this.redirectStrategy.sendRedirect(request, response, "/outlook/listmessages.xhtml?folder=INBOX");
        }
    }

    protected void clearAuthenticationAttributes(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return;
        }
        session.removeAttribute("SPRING_SECURITY_LAST_EXCEPTION");
    }
}

