/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.application;

import ch.admin.smclient.model.Mandant;
import ch.admin.smclient.model.User;
import ch.admin.smclient.service.LDAPProperties;
import ch.admin.smclient.service.MandantRepository;
import ch.admin.smclient.service.postfach.AdminService;
import ch.admin.smclient.service.repository.FileRepository;
import ch.admin.smclient2.web.application.SmcAuthenticationProvider;
import ch.admin.smclient2.web.application.SmcAuthenticationToken;
import ch.admin.smclient2.web.application.SmcUserPrincipal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.AbstractUserDetailsAuthenticationProvider;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;

@Component
public class SmcAuthenticationProvider
extends AbstractUserDetailsAuthenticationProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SmcAuthenticationProvider.class);
    @Autowired
    private FileRepository fileRepository;
    @Autowired
    private AdminService adminService;
    @Autowired
    private MandantRepository mandantRepository;
    @Value(value="${mandant.name:#{null}}")
    private String defaultMandantName;

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        SmcUserPrincipal principal;
        if (userDetails instanceof SmcUserPrincipal && !(principal = (SmcUserPrincipal)userDetails).getIsLdap().booleanValue() && !principal.getUser().equalsPassword(authentication.getCredentials().toString())) {
            throw new BadCredentialsException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.badCredentials", "Bad credentials"));
        }
    }

    protected UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        if (authentication instanceof SmcAuthenticationToken) {
            SmcAuthenticationToken token = (SmcAuthenticationToken)authentication;
            String mandant = token.getMandant();
            if (StringUtils.isEmpty((CharSequence)mandant) && username.equals("SuperUser")) {
                User superUser = this.adminService.getSuperUser(username);
                if (superUser == null) {
                    throw new UsernameNotFoundException("Super user not found");
                }
                return new SmcUserPrincipal(superUser, new Locale(superUser.getDefaultLanguage()), superUser.getRole().stream().map(r -> new SimpleGrantedAuthority("ROLE_" + r.getName())).collect(Collectors.toList()), Boolean.valueOf(false));
            }
            LDAPProperties ldapProperties = this.fileRepository.getLDAPProperties(mandant = this.getMandant(mandant));
            if (ldapProperties.isLdapEnabled()) {
                return this.authWithLDAP(token, mandant, ldapProperties);
            }
            return this.authWithDB(username, mandant);
        }
        return null;
    }

    private String getMandant(String providedMandant) {
        String mandant = providedMandant;
        if (StringUtils.isEmpty((CharSequence)mandant)) {
            if (this.defaultMandantName != null) {
                mandant = this.defaultMandantName;
            } else {
                List<String> mandants = this.mandantRepository.findAllActive().stream().map(Mandant::getSedexId).toList();
                if (mandants.size() != 1) {
                    throw new RuntimeException("No default mandant found");
                }
                mandant = mandants.get(0);
            }
        }
        return mandant;
    }

    private UserDetails authWithDB(String username, String mandant) {
        log.debug("authenticating {} using DB", (Object)username);
        User user = this.adminService.getUserByName(username, mandant);
        if (user == null) {
            User dummyUser = new User();
            dummyUser.setPassword("password");
            dummyUser.equalsPassword("usernameNotFound");
            throw new UsernameNotFoundException(username);
        }
        return new SmcUserPrincipal(user, new Locale(user.getDefaultLanguage()), user.getRole().stream().map(r -> this.getAuthority(r.getName())).collect(Collectors.toList()), Boolean.valueOf(false));
    }

    private UserDetails authWithLDAP(SmcAuthenticationToken token, String mandant, LDAPProperties ldapProperties) {
        SmcUserPrincipal smcUserPrincipal;
        String username = token.getPrincipal().toString();
        String password = token.getCredentials().toString();
        log.info("authenticating {} using LDAP", (Object)username);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ldapProperties.getProviderURL());
        env.put("java.naming.security.authentication", ldapProperties.getAuthenticationType());
        env.put("java.naming.security.principal", String.format("%s=%s,%s", ldapProperties.getBaseFilter(), username, ldapProperties.getBaseCtxDN()));
        env.put("java.naming.security.credentials", password);
        AutoClosableInitialLdapContext ctx = new AutoClosableInitialLdapContext(env);
        try {
            User user = this.buildLdapUser(ctx, token, mandant, ldapProperties);
            List authorities = this.getLdapRoles(username, env, ldapProperties);
            smcUserPrincipal = new SmcUserPrincipal(user, new Locale(user.getDefaultLanguage()), authorities, Boolean.valueOf(true));
        }
        catch (Throwable user) {
            try {
                try {
                    ctx.close();
                }
                catch (Throwable throwable) {
                    user.addSuppressed(throwable);
                }
                throw user;
            }
            catch (NamingException ex) {
                UserDetails superUser = this.getSuperUser(username);
                if (superUser == null) {
                    log.info("i-0430 | login failed", (Throwable)ex);
                    throw new UsernameNotFoundException(username);
                }
                return superUser;
            }
        }
        ctx.close();
        return smcUserPrincipal;
    }

    private GrantedAuthority getAuthority(String role) {
        return new SimpleGrantedAuthority(String.format("ROLE_%s", role));
    }

    private User buildLdapUser(AutoClosableInitialLdapContext ctx, SmcAuthenticationToken token, String mandant, LDAPProperties ldapProperties) {
        String username = token.getPrincipal().toString();
        Locale preferredLocale = token.getPreferredLocale();
        User user = new User();
        user.setUsername(username);
        user.setMandant(this.mandantRepository.findById(mandant));
        try {
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(0);
            String filter = String.format("(%s=%s)", ldapProperties.getBaseFilter(), username);
            SearchResult sr = (SearchResult)ctx.search(String.format("%s=%s,%s", ldapProperties.getBaseFilter(), username, ldapProperties.getBaseCtxDN()), filter, ctls).next();
            String languageAttributeID = ldapProperties.getLanguageAttributeID();
            String ldapLang = sr.getAttributes().get(languageAttributeID).get().toString();
            String lang = this.fromSupportedLanguage(ldapLang, token.getLocales()).orElseGet(() -> {
                String defLang = preferredLocale.getLanguage();
                log.warn("w-0432 | Unable to set user's language: '{}'. Probably not a supported language. Default '{}' will be used.", (Object)ldapLang, (Object)defLang);
                return defLang;
            });
            log.info("Set language {}", (Object)lang);
            user.setDefaultLanguage(lang);
        }
        catch (Exception ex) {
            String defaultLocale = preferredLocale.getLanguage();
            user.setDefaultLanguage(defaultLocale);
            log.warn("w-0432 | Unable to read user's language {} {} will be used", (Object)ex.getMessage(), (Object)defaultLocale);
        }
        return user;
    }

    private List<GrantedAuthority> getLdapRoles(String username, Hashtable<String, String> env, LDAPProperties ldapProperties) {
        ArrayList<GrantedAuthority> arrayList;
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        if (ldapProperties.getBindDN() != null) {
            env.put("java.naming.security.principal", ldapProperties.getBindDN());
            env.put("java.naming.security.credentials", ldapProperties.getBindCredential());
        }
        AutoClosableInitialLdapContext ctx = new AutoClosableInitialLdapContext(env);
        try {
            SearchControls ctls = new SearchControls();
            String rolesCtxDN = ldapProperties.getRolesCtxDN();
            String roleFilter = ldapProperties.getRoleFilter();
            String roleAttributeID = ldapProperties.getRoleAttributeID();
            ctls.setReturningAttributes(new String[]{roleAttributeID});
            ctls.setSearchScope(1);
            String filter = roleFilter.replaceAll("'username'", username);
            NamingEnumeration results = ctx.search(rolesCtxDN, filter, ctls);
            while (results != null && results.hasMore()) {
                SearchResult sr = (SearchResult)results.next();
                NamingEnumeration<?> roles = sr.getAttributes().get(roleAttributeID).getAll();
                while (roles.hasMoreElements()) {
                    String role = roles.nextElement().toString();
                    log.debug("Role {}", (Object)role);
                    if (role.equals(ldapProperties.getAdminRoleMapper())) {
                        log.info("Mapping role {} to {}", (Object)role, (Object)LDAPProperties.DEFAULT_ADMIN_ROLE);
                        authorities.add(this.getAuthority(LDAPProperties.DEFAULT_ADMIN_ROLE));
                    }
                    if (role.equals(ldapProperties.getActiveUserRoleMapper())) {
                        log.info("Mapping role {} to {}", (Object)role, (Object)LDAPProperties.DEFAULT_ACTIVEUSER_ROLE);
                        authorities.add(this.getAuthority(LDAPProperties.DEFAULT_ACTIVEUSER_ROLE));
                    }
                    if (role.equals(ldapProperties.getPassiveUserRoleMapper())) {
                        log.info("Mapping role {} to {}", (Object)role, (Object)LDAPProperties.DEFAULT_PASSIVEUSER_ROLE);
                        authorities.add(this.getAuthority(LDAPProperties.DEFAULT_PASSIVEUSER_ROLE));
                    }
                    if (!role.equals(ldapProperties.getSuperUserRoleMapper())) continue;
                    log.info("Mapping role {} to {}", (Object)role, (Object)LDAPProperties.DEFAULT_SUPERUSER_ROLE);
                    authorities.add(this.getAuthority(LDAPProperties.DEFAULT_SUPERUSER_ROLE));
                }
            }
            arrayList = authorities;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ctx.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                log.warn("w-0431 | unable to read user's roles", (Throwable)ex);
                throw new UsernameNotFoundException(username);
            }
        }
        ctx.close();
        return arrayList;
    }

    private UserDetails getSuperUser(String username) {
        User user = this.adminService.getSuperUser(username);
        if (user == null) {
            return null;
        }
        return new SmcUserPrincipal(user, new Locale(user.getDefaultLanguage()), user.getRole().stream().map(r -> new SimpleGrantedAuthority("ROLE_" + r.getName())).collect(Collectors.toList()), Boolean.valueOf(false));
    }

    private Optional<String> fromSupportedLanguage(String ldapLang, Enumeration<Locale> supportedLocales) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(supportedLocales.asIterator(), 16), false).map(locale -> locale.getDisplayName((Locale)locale)).filter(ldapLang::startsWith).findAny();
    }
}

