/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.application;

import ch.admin.smclient2.web.application.SmcAuthenticationToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Enumeration;
import java.util.Locale;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

public class SmcAuthenticationFilter
extends UsernamePasswordAuthenticationFilter {
    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        String path = request.getServletPath();
        String method = request.getMethod();
        if (path.contains("/login.xhtml") && "POST".equals(method)) {
            return true;
        }
        return super.requiresAuthentication(request, response);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        String username = this.obtainUsername(request);
        String password = this.obtainPassword(request);
        String mandant = request.getParameter("mandant_input");
        Locale preferredLocales = request.getLocale();
        Enumeration locales = request.getLocales();
        SmcAuthenticationToken userToken = new SmcAuthenticationToken((Object)username, (Object)password, mandant, preferredLocales, locales);
        this.setDetails(request, (UsernamePasswordAuthenticationToken)userToken);
        return this.getAuthenticationManager().authenticate((Authentication)userToken);
    }
}

