/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.application;

import ch.admin.smclient2.web.ApplicationUsers;
import ch.admin.smclient2.web.application.SmcAuthenticationFilter;
import ch.admin.smclient2.web.application.SmcAuthenticationSuccessHandler;
import jakarta.servlet.Filter;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.authentication.configuration.AuthenticationConfiguration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
@EnableConfigurationProperties(value={ApplicationUsers.class})
public class SecurityConfig {
    @Bean
    SecurityFilterChain configure(HttpSecurity http, AuthenticationManager authenticationManager) {
        try {
            http.csrf(AbstractHttpConfigurer::disable);
            http.addFilterBefore((Filter)this.smcAuthenticationFilter(authenticationManager), UsernamePasswordAuthenticationFilter.class).authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(new String[]{"/images/**"})).permitAll().requestMatchers(new String[]{"/"})).permitAll().requestMatchers(new String[]{"/logout"})).permitAll().requestMatchers(new String[]{"/login.xhtml"})).permitAll().requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher("/jakarta.faces.resource/**")})).permitAll().requestMatchers(new String[]{"/audit/mandant.xhtml"})).hasRole("SuperUser").requestMatchers(new String[]{"testplatform/changepassword.xhtml"})).hasRole("SuperUser").requestMatchers(new String[]{"/audit/**"})).hasRole("Admin").requestMatchers(new String[]{"/compose/**"})).hasRole("ActiveUser").requestMatchers(new String[]{"/outlook/**"})).hasRole("PassiveUser").anyRequest()).authenticated()).formLogin(formLogin -> formLogin.loginPage("/login.xhtml").permitAll()).logout(logout -> logout.logoutSuccessUrl("/login.xhtml").logoutUrl("/logout").deleteCookies(new String[]{"JSESSIONID"}));
            return (SecurityFilterChain)http.build();
        }
        catch (Exception ex) {
            throw new BeanCreationException("Wrong spring security configuration", (Throwable)ex);
        }
    }

    @Bean
    public AuthenticationManager authenticationManager(AuthenticationConfiguration authenticationConfiguration) throws Exception {
        return authenticationConfiguration.getAuthenticationManager();
    }

    public SmcAuthenticationFilter smcAuthenticationFilter(AuthenticationManager authenticationManager) {
        SmcAuthenticationFilter filter = new SmcAuthenticationFilter();
        filter.setAuthenticationManager(authenticationManager);
        filter.setAuthenticationSuccessHandler(this.smClientAuthenticationSuccessHandler());
        filter.setAuthenticationFailureHandler((request, response, exception) -> new DefaultRedirectStrategy().sendRedirect(request, response, "/login.xhtml?error=true"));
        filter.setSecurityContextRepository((SecurityContextRepository)new HttpSessionSecurityContextRepository());
        return filter;
    }

    @Bean
    public AuthenticationSuccessHandler smClientAuthenticationSuccessHandler() {
        return new SmcAuthenticationSuccessHandler();
    }
}

