/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.admin;

import ch.admin.smclient.model.Property;
import ch.admin.smclient.service.BackupUtility;
import ch.admin.smclient.service.PropertyKeys;
import ch.admin.smclient.service.annotations.ConfigEntry;
import ch.admin.smclient.service.repository.DirectoryRepository;
import ch.admin.smclient.service.repository.FileRepository;
import ch.admin.smclient.service.repository.PropertyRepository;
import ch.admin.smclient2.web.admin.PropertyUpdateBean;
import ch.admin.smclient2.web.admin.StatusChecker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StatusChecker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatusChecker.class);
    @Autowired
    private PropertyRepository propertyRepository;
    @Autowired
    private FileRepository fileRepository;
    @Autowired
    private DirectoryRepository directoryRepository;
    private boolean isDBErrors = false;
    private boolean isFSErrors = false;
    private static final Map<BackupUtility.ConfigKeys, Properties> propertyFiles = new HashMap();

    public List<String> checkDataBase(String sedexId) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String value;
            Properties properties = this.propertyRepository.findByMandant(sedexId);
            for (BackupUtility.ConfigKeys configKeys : BackupUtility.ConfigKeys.values()) {
                if (configKeys == BackupUtility.ConfigKeys.GLOBAL_CONFIG) continue;
                value = properties.getProperty(configKeys.getValue());
                if (StringUtils.isEmpty((CharSequence)value)) {
                    result.add("property " + configKeys.getValue() + " NOT FOUND");
                    this.isDBErrors = true;
                    continue;
                }
                File configFile = new File(value);
                if (configFile.exists()) continue;
                result.add("File: " + configFile + " not found");
                this.isDBErrors = true;
            }
            for (BackupUtility.ConfigKeys configKeys : PropertyUpdateBean.DBProperties.values()) {
                value = properties.getProperty(configKeys.getValue());
                if (!StringUtils.isEmpty((CharSequence)value)) continue;
                result.add("property " + configKeys.getValue() + " NOT FOUND");
                this.isDBErrors = true;
            }
        }
        catch (Exception ex) {
            result.add("General DataBase Exception, please check installation" + ex.getMessage());
        }
        return result;
    }

    public List<String> checkFileSystem(String sedexId) {
        List<String> result = new ArrayList<String>();
        Properties properties = this.propertyRepository.findByMandant(sedexId);
        List global = this.propertyRepository.findForAllMandantsAndDomainsByKey(BackupUtility.ConfigKeys.GLOBAL_CONFIG.getValue());
        for (Property property : global) {
            properties.put(property.getKey(), property.getValue());
        }
        Field[] propertiesToCheck = PropertyKeys.class.getFields();
        for (int i = 0; i < propertiesToCheck.length; ++i) {
            Field propertyToCheck = propertiesToCheck[i];
            try {
                ConfigEntry metaData = propertyToCheck.getAnnotation(ConfigEntry.class);
                if (metaData.location() == BackupUtility.ConfigKeys.RULES) continue;
                result = this.checkProperty(properties, result, propertyToCheck);
                continue;
            }
            catch (Exception e) {
                result.add("Cannot check properties: " + e.getMessage());
            }
        }
        propertyFiles.clear();
        return result;
    }

    public boolean isDBErrors() {
        return this.isDBErrors;
    }

    public boolean isFSErrors() {
        return this.isFSErrors;
    }

    private List<String> checkProperty(Properties properties, List<String> result, Field propertyToCheck) {
        try {
            String propertyValue;
            ConfigEntry metaData = propertyToCheck.getAnnotation(ConfigEntry.class);
            String propertyName = (String)propertyToCheck.get(null);
            BackupUtility.ConfigKeys configKey = metaData.location();
            Properties prop = (Properties)propertyFiles.get(configKey);
            if (prop == null) {
                prop = new Properties();
                try (FileInputStream is = new FileInputStream(properties.getProperty(configKey.getValue()));){
                    prop.load(is);
                }
                propertyFiles.put(configKey, prop);
            }
            if (metaData != null && metaData.required() && (propertyValue = prop.getProperty(propertyName)) == null) {
                result.add("Property: " + propertyName + " is missing in " + properties.getProperty(configKey.getValue()));
            }
        }
        catch (Exception ex) {
            result.add("General FileSystem Exception, please check installation: " + ex.getMessage());
            log.error("Exception: ", (Throwable)ex);
            this.isFSErrors = true;
        }
        this.isFSErrors = result.size() > 0;
        return result;
    }

    private boolean checkFileAvailability(Properties properties, String propertyKey, ConfigEntry metaData) {
        Object path = properties.getProperty(propertyKey);
        if (!"".equals(metaData.containingDirectory())) {
            String containingDir = metaData.readDirFromProperty() ? properties.getProperty(metaData.containingDirectory()) : metaData.containingDirectory();
            path = containingDir + (!containingDir.endsWith("/") && !((String)path).startsWith("/") ? "/" : "") + (String)path;
        }
        File file = new File((String)path);
        return file.exists();
    }

    public List<Map.Entry<String, String>> readConfigFileContents(String sedexId) {
        Properties properties = this.propertyRepository.findByMandant(sedexId);
        HashMap<String, String> fileContents = new HashMap<String, String>();
        for (BackupUtility.ConfigKeys configKey : BackupUtility.ConfigKeys.values()) {
            String path;
            if (BackupUtility.ConfigKeys.GLOBAL_CONFIG.equals((Object)configKey) || (path = properties.getProperty(configKey.getValue())) == null) continue;
            String[] pathParts = path.split("/");
            String shortFileName = pathParts[pathParts.length - 1];
            try {
                String content = this.getFileContents(new FileInputStream(path));
                fileContents.put(shortFileName, content);
            }
            catch (FileNotFoundException e) {
                log.error("The file '" + properties.getProperty(configKey.getValue()) + "' does not exist!");
            }
            catch (IOException e) {
                log.error("IO error: {}", (Throwable)e);
            }
        }
        StringBuilder globalFile = new StringBuilder();
        for (Map.Entry<Object, Object> entry : this.fileRepository.getGlobalConfiguration().entrySet()) {
            globalFile.append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
        }
        fileContents.put("global-config.location", globalFile.toString());
        fileContents.put("version.properties", this.getRepositoryVersionContent(sedexId));
        ArrayList<Map.Entry<String, String>> entries = new ArrayList<Map.Entry<String, String>>(fileContents.entrySet());
        Collections.sort(entries, new ConfigFileOrder(this));
        return entries;
    }

    private String getRepositoryVersionContent(String sedexId) {
        String versionInfo;
        DirectoryRepository dirRep = this.directoryRepository;
        File repoVersion = null;
        if (this.propertyRepository.findByMandant(sedexId).getProperty("version") != null) {
            repoVersion = dirRep.getFileRepositoryLocation(sedexId, "version");
        } else {
            File participantsDir = dirRep.getFileRepositoryLocation(sedexId, "participants");
            if (participantsDir != null) {
                repoVersion = new File(participantsDir, "version.properties");
            }
        }
        if (repoVersion != null) {
            try {
                versionInfo = this.getFileContents(new FileInputStream(repoVersion));
            }
            catch (Exception e) {
                log.warn("Error while reading version.properties: {0}", (Object)e.getMessage());
                versionInfo = "Error while reading version.properties, see log for details";
            }
        } else {
            versionInfo = "No repository version information found!";
        }
        return versionInfo;
    }

    private String replaceSensitiveProperties(String properties, Set<String> sensitivePropertyNames) {
        String[] lines;
        if (properties == null || sensitivePropertyNames == null) {
            return properties;
        }
        StringBuilder result = new StringBuilder();
        for (String line : lines = properties.split("\n")) {
            String[] keyValue = line.split("=", 2);
            if (keyValue.length == 2) {
                String key = keyValue[0].trim();
                String value = keyValue[1].trim();
                if (sensitivePropertyNames.contains(key)) {
                    result.append(key).append("=XXXXXXXXXX\n");
                    continue;
                }
                result.append(line).append("\n");
                continue;
            }
            result.append(line).append("\n");
        }
        return result.toString().trim();
    }

    private String getFileContents(FileInputStream in) throws IOException {
        int chr;
        HashSet<String> sensitiveProperties = new HashSet<String>();
        sensitiveProperties.add("bindCredential");
        sensitiveProperties.add("apiKey");
        StringBuffer str = new StringBuffer();
        while ((chr = in.read()) != -1) {
            str.append(String.valueOf((char)chr));
        }
        return this.replaceSensitiveProperties(str.toString(), sensitiveProperties);
    }
}

