/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.admin;

import ch.admin.smclient.model.Property;
import ch.admin.smclient.service.repository.PropertyRepository;
import ch.admin.smclient2.web.admin.PropertyUpdateBean;
import ch.admin.smclient2.web.compatibility.AppMessages;
import ch.admin.smclient2.web.compatibility.CurrentUserBean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PropertyUpdateBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PropertyUpdateBean.class);
    @Autowired
    PropertyRepository propertyRepository;
    @Autowired
    CurrentUserBean user;
    @Autowired
    private AppMessages appMessages;
    private Property deleteTimeOut;
    private Property sessionTimeOut;

    public Property getDeleteTimeOut() {
        if (this.deleteTimeOut == null) {
            this.deleteTimeOut = this.propertyRepository.findByName(this.user.getMandantSedexId(), DBProperties.KEEP_DELETED.getValue());
        }
        return this.deleteTimeOut;
    }

    public Property getSessionTimeOut() {
        if (this.sessionTimeOut == null) {
            this.sessionTimeOut = this.propertyRepository.findByName(this.user.getMandantSedexId(), DBProperties.TIMEOUT.getValue());
        }
        return this.sessionTimeOut;
    }

    public void updateProperties() {
        log.debug("Updating properties");
        try {
            int timeOut = Integer.parseInt(this.getSessionTimeOut().getValue());
            log.debug("Update session timeout to {0} min", (Object)timeOut);
            Integer.parseInt(this.getDeleteTimeOut().getValue());
            this.appMessages.addInfo("info", "property.update.values", new String[0]);
            this.propertyRepository.update(this.user.getMandantSedexId(), this.sessionTimeOut);
            this.propertyRepository.update(this.user.getMandantSedexId(), this.deleteTimeOut);
        }
        catch (Exception ex) {
            log.debug("Validation failed, properties not updated", (Throwable)ex);
        }
    }

    public void checkValues() {
        log.debug("Value {0}, delete cv {1}", (Object)this.sessionTimeOut, (Object)this.deleteTimeOut);
    }

    @Generated
    public void setDeleteTimeOut(Property deleteTimeOut) {
        this.deleteTimeOut = deleteTimeOut;
    }

    @Generated
    public void setSessionTimeOut(Property sessionTimeOut) {
        this.sessionTimeOut = sessionTimeOut;
    }
}

