/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.admin;

import ch.admin.smclient.model.Message;
import ch.admin.smclient2.web.admin.MessageStatusSignal;
import java.util.Optional;
import lombok.Generated;

public enum MessageStatusSignal {
    ALL("all", "listmsgs.select.all", "", Message.SimpleStatus.NOTSET),
    GREEN("green", "message.status.signal.green", "/img/statusicon-green.gif", Message.SimpleStatus.OK),
    RED("red", "message.status.signal.red", "/img/statusicon-red.gif", Message.SimpleStatus.FAILED),
    YELLOW("yellow", "message.status.signal.yellow", "/img/statusicon-yellow.gif", Message.SimpleStatus.DELAYED, "P1D"),
    BLUE("blue", "message.status.signal.blue", "/img/statusicon-blue.gif", Message.SimpleStatus.DELAYED, "P1D");

    private String color;
    private String bundleKey;
    private String statusIcon;
    private Message.SimpleStatus simpleStatus;
    private String lastChangeCriteria;
    private static final MessageStatusSignal DEFAULT;

    private MessageStatusSignal(String color, String bundleKey, String statusIcon, Message.SimpleStatus simpleStatus) {
        this(string, n, color, bundleKey, statusIcon, simpleStatus, "");
    }

    private MessageStatusSignal(String color, String bundleKey, String statusIcon, Message.SimpleStatus simpleStatus, String lastChangeCriteria) {
        this.color = color;
        this.bundleKey = bundleKey;
        this.statusIcon = statusIcon;
        this.simpleStatus = simpleStatus;
        this.lastChangeCriteria = lastChangeCriteria;
        Finder.byColorMap.put(color, this);
    }

    public static MessageStatusSignal valueOfColor(String color) {
        return Optional.ofNullable((MessageStatusSignal)Finder.byColorMap.get(color)).orElseThrow(() -> new IllegalArgumentException(String.format("Unsupported type %s.", color)));
    }

    public static MessageStatusSignal getDefault() {
        return DEFAULT;
    }

    @Generated
    public String getColor() {
        return this.color;
    }

    @Generated
    public String getBundleKey() {
        return this.bundleKey;
    }

    @Generated
    public String getStatusIcon() {
        return this.statusIcon;
    }

    @Generated
    public Message.SimpleStatus getSimpleStatus() {
        return this.simpleStatus;
    }

    @Generated
    public String getLastChangeCriteria() {
        return this.lastChangeCriteria;
    }

    static {
        DEFAULT = ALL;
    }
}

