/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.admin;

import ch.admin.smclient.model.Message;
import ch.admin.smclient.service.postfach.AdminService;
import ch.admin.smclient2.web.admin.MessageStatusSignal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.primefaces.model.FilterMeta;
import org.primefaces.model.LazyDataModel;
import org.primefaces.model.MatchMode;
import org.primefaces.model.SortMeta;
import org.primefaces.model.SortOrder;

public class MessageListModel
extends LazyDataModel<Message> {
    private final AdminService adminService;
    private final String sedexId;

    public MessageListModel(AdminService adminService, String sedexId) {
        this.adminService = adminService;
        this.sedexId = sedexId;
    }

    private Set<Integer> getSet(FilterMeta filterMeta) {
        if ("currentState".equals(filterMeta.getField())) {
            MessageStatusSignal signal = MessageStatusSignal.valueOfColor((String)filterMeta.getFilterValue().toString().toLowerCase());
            return EnumSet.allOf(Message.MessageState.class).stream().filter(ms -> ms.getSimpleStatus().equals((Object)signal.getSimpleStatus())).map(Message.MessageState::getCode).collect(Collectors.toSet());
        }
        return Set.of();
    }

    private Pair<String, Map<String, Object>> buildFilter(Map<String, FilterMeta> filterBy) {
        StringBuilder sb = new StringBuilder();
        HashMap<Object, Object> parameters = new HashMap<Object, Object>();
        sb.append("message.mandant.sedexId = :sedexId");
        parameters.put("sedexId", this.sedexId);
        for (FilterMeta filterMeta : filterBy.values()) {
            if ("messageType".equals(filterMeta.getField())) {
                String value = (String)filterMeta.getFilterValue();
                String[] values = value.split(" ");
                sb.append(" AND message.messageType = :messageType");
                parameters.put("messageType", values[0]);
                if (values.length <= 1) continue;
                sb.append(" AND ").append("message.subMessageType = :subMessageType");
                parameters.put("subMessageType", values[1]);
                continue;
            }
            if ("internalMessages".equals(filterMeta.getField())) {
                sb.append(" AND (GroupedMessageAudit.messageId = :internalMessageId OR message.messageId = :internalMessageId)");
                parameters.put("internalMessageId", filterMeta.getFilterValue());
                continue;
            }
            sb.append(" AND ").append("message.").append(filterMeta.getField());
            if (filterMeta.getMatchMode() == MatchMode.CONTAINS) {
                sb.append(" LIKE :").append(filterMeta.getField());
                parameters.put(filterMeta.getField(), "%" + filterMeta.getFilterValue() + "%");
                continue;
            }
            if (filterMeta.getMatchMode() == MatchMode.BETWEEN) {
                sb.append(" BETWEEN :").append(filterMeta.getField()).append("_0 AND :").append(filterMeta.getField()).append("_1");
                List values = (List)filterMeta.getFilterValue();
                parameters.put(filterMeta.getField() + "_0", values.get(0));
                parameters.put(filterMeta.getField() + "_1", values.get(1));
                continue;
            }
            if (filterMeta.getMatchMode() == MatchMode.IN) {
                sb.append(" IN :").append(filterMeta.getField());
                parameters.put(filterMeta.getField(), this.getSet(filterMeta));
                continue;
            }
            if (filterMeta.getMatchMode() != MatchMode.EXACT) continue;
            sb.append(" = :").append(filterMeta.getField());
            parameters.put(filterMeta.getField(), filterMeta.getFilterValue());
        }
        return new ImmutablePair((Object)sb.toString(), parameters);
    }

    public int count(Map<String, FilterMeta> filterBy) {
        Pair sqlFilterPair = this.buildFilter(filterBy);
        return this.adminService.countMessagesForAudit((String)sqlFilterPair.getKey(), (Map)sqlFilterPair.getValue());
    }

    public List<Message> load(int first, int pageSize, Map<String, SortMeta> sortBy, Map<String, FilterMeta> filterBy) {
        Pair sqlFilterPair = this.buildFilter(filterBy);
        ArrayList<String> sortedByColumns = new ArrayList<String>();
        boolean isAcs = true;
        Collection<SortMeta> sortMetas = sortBy.values();
        if (!sortMetas.isEmpty()) {
            SortMeta sortedMeta = sortMetas.iterator().next();
            if ("messageType".equals(sortedMeta.getField())) {
                sortedByColumns.add("messageType");
                sortedByColumns.add("subMessageType");
            } else {
                sortedByColumns.add(sortedMeta.getField());
            }
            isAcs = sortedMeta.getOrder() == SortOrder.ASCENDING;
        } else {
            sortedByColumns.add("lastChange");
            isAcs = false;
        }
        return this.adminService.selectMessagesForAudit(first, pageSize, sortedByColumns, isAcs, (String)sqlFilterPair.getKey(), (Map)sqlFilterPair.getValue());
    }
}

