/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.admin;

import ch.admin.smclient.process.MessageCleaner;
import ch.admin.smclient2.web.compatibility.AppMessages;
import ch.admin.smclient2.web.compatibility.CurrentUserBean;
import java.util.Date;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="session")
public class CleanupBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CleanupBean.class);
    private Date date;
    private Integer messagesToDelete;
    @Autowired
    private AppMessages appMessages;
    @Autowired
    private CurrentUserBean user;
    @Autowired
    MessageCleaner messageCleaner;

    public void cleanup() {
        try {
            String numDeleted = String.valueOf(this.messageCleaner.cleanup(this.date, this.user.getMandantSedexId()));
            this.appMessages.addInfo("info", "cleanup.complete", new String[]{numDeleted});
        }
        catch (Exception e) {
            this.appMessages.addError("error", "cleanup.timeout", new String[0]);
        }
    }

    public void updateMessageAmount(int amount) {
        log.debug("observed event, get {0} messages.", (Object)amount);
        this.messagesToDelete = amount;
        log.debug("number of message to be deleted updated to {0}.", (Object)this.messagesToDelete);
    }

    @Generated
    public void setDate(Date date) {
        this.date = date;
    }

    @Generated
    public Date getDate() {
        return this.date;
    }

    @Generated
    public void setMessagesToDelete(Integer messagesToDelete) {
        this.messagesToDelete = messagesToDelete;
    }

    @Generated
    public Integer getMessagesToDelete() {
        return this.messagesToDelete;
    }
}

