/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.admin;

import ch.admin.smclient.model.Audit;
import ch.admin.smclient.model.GroupedMessageAudit;
import ch.admin.smclient.model.Message;
import ch.admin.smclient.service.postfach.AdminService;
import ch.admin.smclient.service.postfach.MailboxService;
import ch.admin.smclient2.web.admin.MessageListModel;
import ch.admin.smclient2.web.admin.MessageStatusSignal;
import ch.admin.smclient2.web.compatibility.CurrentUserBean;
import jakarta.annotation.PostConstruct;
import jakarta.faces.model.SelectItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="session")
public class AuditBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuditBean.class);
    @Autowired
    private AdminService adminService;
    @Autowired
    private MailboxService mailboxService;
    @Autowired
    CurrentUserBean userBean;
    private List<Audit> msgAuditTrail = new ArrayList();
    private MessageListModel messageList;
    private Message currentMessage = null;

    @PostConstruct
    void init() {
        String sedexId = this.userBean.getMandantSedexId();
        this.messageList = new MessageListModel(this.adminService, sedexId);
    }

    public int getMessageStatusCodeForText(Message message) {
        return message.getCurrentState();
    }

    public List<SelectItem> getMessageStatusSignalItems() {
        ResourceBundle bundle = ResourceBundle.getBundle("messages", this.userBean.getUserLocale());
        return Arrays.stream(MessageStatusSignal.values()).filter(status -> status != MessageStatusSignal.ALL).map(status -> new SelectItem(status, bundle.getString(status.getBundleKey()))).toList();
    }

    public List<SelectItem> getMessageStatusItems() {
        List msgStatus = this.mailboxService.getMessageStatuses();
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (String status : msgStatus) {
            items.add(new SelectItem((Object)status, status));
        }
        return items;
    }

    public List<SelectItem> getMessageTypeItems() {
        List msgTypes = this.mailboxService.getMessageTypes(this.userBean.getMandantSedexId(), null);
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (Object[] msgType : msgTypes) {
            String messageType = (String)msgType[0];
            String menuItemValue = msgType[1] != null ? messageType + " " + msgType[1] : messageType;
            SelectItem item = new SelectItem((Object)menuItemValue, menuItemValue);
            items.add(item);
        }
        return items;
    }

    public MessageStatusSignal getMessageStatusSignal(Message message) {
        Message.SimpleStatus statusSignal = Message.MessageState.valueOfCode((int)message.getCurrentState()).getSimpleStatus();
        if (Objects.requireNonNull(statusSignal) == Message.SimpleStatus.DELAYED) {
            long diff = Calendar.getInstance().getTime().getTime() - message.getLastChange().getTime();
            if (TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS) >= 1L) {
                return MessageStatusSignal.YELLOW;
            }
            return MessageStatusSignal.BLUE;
        }
        return EnumSet.allOf(MessageStatusSignal.class).stream().filter(e -> e.getSimpleStatus() == statusSignal).findFirst().orElseThrow(() -> new IllegalArgumentException("No Element with simpleStatus " + statusSignal));
    }

    public String evaluateTrailFields(Message message) {
        log.debug("Get trail about {} (id: {})", (Object)message.getId(), (Object)message.getMessageId());
        this.msgAuditTrail = this.adminService.getAuditInfobyMsgId(message.getId());
        this.currentMessage = message;
        return "/audit/showTrail.xhtml?faces-redirect=true";
    }

    public String reset() {
        return "/audit/listAudit.xhtml";
    }

    public List<GroupedMessageAudit> getFirstInternalMessages(Message message, int numberOfMessage) {
        return message.getInternalMessages().stream().limit(numberOfMessage).toList();
    }

    @Generated
    public void setMsgAuditTrail(List<Audit> msgAuditTrail) {
        this.msgAuditTrail = msgAuditTrail;
    }

    @Generated
    public List<Audit> getMsgAuditTrail() {
        return this.msgAuditTrail;
    }

    @Generated
    public MessageListModel getMessageList() {
        return this.messageList;
    }

    @Generated
    public void setMessageList(MessageListModel messageList) {
        this.messageList = messageList;
    }

    @Generated
    public void setCurrentMessage(Message currentMessage) {
        this.currentMessage = currentMessage;
    }

    @Generated
    public Message getCurrentMessage() {
        return this.currentMessage;
    }
}

