/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web.admin;

import ch.admin.smclient.model.Mandant;
import ch.admin.smclient.model.Role;
import ch.admin.smclient.model.User;
import ch.admin.smclient.service.MandantService;
import ch.admin.smclient.service.postfach.AdminService;
import ch.admin.smclient.util.InvalidMandantStateException;
import ch.admin.smclient2.web.compatibility.AppMessages;
import ch.admin.smclient2.web.compatibility.CurrentUserBean;
import jakarta.faces.model.SelectItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="session")
public class AdminBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdminBean.class);
    @Autowired
    private AppMessages appMessages;
    @Autowired
    private AdminService adminService;
    @Autowired
    private MandantService mandantService;
    @Autowired
    CurrentUserBean user;
    private List<Role> roles;
    private List<User> users;
    private User selectedUser = null;
    private List<Mandant> mandanten;
    private Mandant selectedMandant;
    private List<Mandant> selectMandanten;
    private String password1;
    private String password2;
    private boolean existingUser = false;
    private boolean isNewlyCreatedMandant = false;

    public List<SelectItem> getAvailableRoles() {
        this.initRoles();
        return this.roles.stream().filter(role -> !"SuperUser".equalsIgnoreCase(role.getName())).map(role -> new SelectItem(role, role.getName())).collect(Collectors.toList());
    }

    private void initRoles() {
        if (this.roles == null) {
            this.roles = this.adminService.selectAllRoles();
        }
    }

    public void saveUser() {
        if (!this.existingUser && this.adminService.getUserByName(this.selectedUser.getUsername(), this.selectedUser.getMandantSedexId()) != null) {
            this.appMessages.addError("adminRole_username", "error.user.double.entry", new String[0]);
            return;
        }
        if (!this.password1.isEmpty()) {
            if (!this.password1.equals(this.password2)) {
                this.appMessages.addError("if_password1", "error.password.mismatch", new String[0]);
            } else {
                this.selectedUser.setNewPassword(this.password1);
                this.adminService.updateUser(this.selectedUser);
                this.selectedUser = null;
            }
        } else if (this.selectedUser.getPassword() != null) {
            this.adminService.updateUser(this.selectedUser);
            this.selectedUser = null;
        } else {
            this.appMessages.addError("if_password1", "error.password.empty", new String[0]);
        }
        this.password1 = null;
        this.password2 = null;
        this.refreshUsers();
    }

    public void persist() {
        boolean isExisted = false;
        if (this.isNewlyCreatedMandant) {
            for (Mandant m : this.getMandanten()) {
                if (!m.getSedexId().equals(this.selectedMandant.getSedexId())) continue;
                log.error("Newly created mandant has sedexId which exists already");
                isExisted = true;
                this.appMessages.addError("error", "admin.mandant.creation.existing.error", new String[0]);
            }
        }
        if (!isExisted) {
            this.mandantService.persist(this.selectedMandant);
            this.selectedMandant = null;
        }
        this.isNewlyCreatedMandant = false;
        this.refreshMandanten();
    }

    public void deleteUser(User user) {
        this.adminService.deleteUsers(List.of(user.getId()));
        this.refreshUsers();
    }

    public void setNewUser() {
        this.selectedUser = new User();
        this.selectedUser.setDefaultLanguage(Locale.getDefault().getLanguage());
        this.selectedUser.setMandant(this.user.getMandant());
        this.selectedUser.setRole(new ArrayList());
        this.existingUser = false;
    }

    public void setSelectedUser(User selectedUser) {
        this.existingUser = false;
        if (selectedUser != null) {
            this.existingUser = true;
            selectedUser.setRole(new ArrayList(selectedUser.getRole()));
        }
        this.selectedUser = selectedUser;
    }

    public void createNewMandant() {
        this.isNewlyCreatedMandant = true;
        this.selectedUser = new User();
        this.existingUser = false;
        this.selectedMandant = new Mandant();
    }

    public void cancelToCreateNewMandant() {
        this.selectedMandant = null;
        this.isNewlyCreatedMandant = false;
    }

    public void toggleActiveStateMandant() {
        if (this.selectMandanten != null) {
            try {
                List<String> ids = this.selectMandanten.stream().map(Mandant::getSedexId).toList();
                this.mandantService.toggleActiveStateMandanten(ids);
            }
            catch (InvalidMandantStateException ex) {
                this.appMessages.addError("error", "admin.error.noconfig", new String[]{ex.getName()});
            }
            this.refreshMandanten();
        }
    }

    public List<User> getUsers() {
        if (this.users != null) {
            return this.users;
        }
        return this.refreshUsers();
    }

    public List<User> refreshUsers() {
        this.users = this.adminService.selectAllUsers(this.user.getMandantSedexId());
        return this.users;
    }

    public List<Mandant> getMandanten() {
        if (this.mandanten != null) {
            return this.mandanten;
        }
        return this.refreshMandanten();
    }

    public List<Mandant> refreshMandanten() {
        this.selectMandanten = null;
        this.mandanten = this.mandantService.findAllAdmin();
        return this.mandanten;
    }

    public List<SelectItem> getSupportedLocales() {
        return List.of(new SelectItem((Object)"de", "Deutsch"), new SelectItem((Object)"fr", "Fran\u00e7ais"), new SelectItem((Object)"it", "Italiano"), new SelectItem((Object)"en", "English"));
    }

    @Generated
    public void setUsers(List<User> users) {
        this.users = users;
    }

    @Generated
    public User getSelectedUser() {
        return this.selectedUser;
    }

    @Generated
    public void setSelectedMandant(Mandant selectedMandant) {
        this.selectedMandant = selectedMandant;
    }

    @Generated
    public Mandant getSelectedMandant() {
        return this.selectedMandant;
    }

    @Generated
    public List<Mandant> getSelectMandanten() {
        return this.selectMandanten;
    }

    @Generated
    public void setSelectMandanten(List<Mandant> selectMandanten) {
        this.selectMandanten = selectMandanten;
    }

    @Generated
    public String getPassword1() {
        return this.password1;
    }

    @Generated
    public void setPassword1(String password1) {
        this.password1 = password1;
    }

    @Generated
    public String getPassword2() {
        return this.password2;
    }

    @Generated
    public void setPassword2(String password2) {
        this.password2 = password2;
    }
}

