/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.web;

import ch.admin.smclient.model.Mandant;
import ch.admin.smclient.service.MandantRepository;
import ch.admin.smclient.service.repository.DirectoryRepository;
import ch.admin.smclient.service.repository.FileRepository;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class ScreenLabelGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScreenLabelGenerator.class);
    @Autowired
    DirectoryRepository directoryRepository;
    @Autowired
    FileRepository fileRepository;
    @Autowired
    MandantRepository mandantRepository;

    @EventListener
    public void onApplicationEvent(ContextRefreshedEvent event) {
        try {
            log.info("Checking presence of label files");
            this.checkPresentsOfLabelFiles();
        }
        catch (Exception e) {
            log.warn("Could not verify the presence of label files: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void checkPresentsOfLabelFiles() throws IOException, TransformerException {
        List mandanten = this.mandantRepository.findAllActive();
        for (Mandant mandant : mandanten) {
            String sedexId = mandant.getSedexId();
            File dir = this.directoryRepository.getFileRepositoryLocation(sedexId, "xsd_xslt");
            if (!dir.exists()) {
                log.error("Directory {} does not exist for mandant {}", (Object)dir, (Object)sedexId);
                throw new FileNotFoundException("Directory " + dir + " does not exist for mandant " + sedexId);
            }
            if (!dir.isDirectory()) {
                log.error("Directory {} is not a directory for mandant {}", (Object)dir, (Object)sedexId);
                throw new FileNotFoundException("Directory " + dir + " is not a directory for mandant " + sedexId);
            }
            this.generateScreenLabels(dir);
        }
        Locale.setDefault(Locale.GERMAN);
    }

    public void updateCache() throws IOException, TransformerException {
        this.checkPresentsOfLabelFiles();
    }

    private void generateScreenLabels(File dir) throws TransformerException, FileNotFoundException {
        Collection files = FileUtils.listFiles((File)dir, (String[])new String[]{"properties"}, (boolean)true);
        if (files == null || files.isEmpty()) {
            log.debug("no screen label properties found so going to create them");
            for (String language : this.getSupportedLocales()) {
                files = FileUtils.listFiles((File)dir, (IOFileFilter)new WildcardFileFilter("*-language*" + language + ".xsl"), (IOFileFilter)TrueFileFilter.INSTANCE);
                this.generateScreenLabelFile(files, language);
            }
        }
    }

    List<String> getSupportedLocales() {
        return List.of("de", "fr", "it", "en");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateScreenLabelFile(Collection<File> files, String language) throws TransformerException, FileNotFoundException {
        TransformerFactory factory = TransformerFactory.newInstance();
        BufferedOutputStream bos = null;
        StreamSource xslt = new StreamSource(this.getClass().getResourceAsStream("/property-generation-xml.xsl"));
        Transformer transformer = factory.newTransformer(xslt);
        for (File xml : files) {
            try {
                String baseName = FilenameUtils.removeExtension((String)xml.getName());
                StreamSource source = new StreamSource(xml);
                String outputName = baseName.substring(0, baseName.lastIndexOf(45)) + language + ".properties";
                File output = new File(xml.getParent(), outputName);
                bos = new BufferedOutputStream(new FileOutputStream(output));
                StreamResult result = new StreamResult(bos);
                transformer.transform(source, result);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bos);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)bos);
        }
    }
}

