/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.monitoring;

import ch.admin.smclient.model.Mandant;
import ch.admin.smclient.service.MandantRepository;
import ch.admin.smclient.service.monitoring.MonitoringConfig;
import ch.admin.smclient.service.repository.DirectoryRepository;
import ch.admin.smclient.service.repository.FileRepository;
import ch.admin.smclient.service.repository.PropertyRepository;
import ch.admin.smclient2.monitoring.MonitoringSender;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="MonitoringSchedulerStarter")
public class SchedulerStarter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchedulerStarter.class);
    public static final String INTERVAL_KEY = "filechange.listener.interval";
    public static final Long HOURS_24 = 86400000L;
    @Autowired
    protected MonitoringSender monitoringSender;
    @Autowired
    FileRepository fileRepository;
    @Autowired
    DirectoryRepository directoryRepository;
    @Autowired
    PropertyRepository propertyRepository;
    @Autowired
    MandantRepository mandantRepository;
    @Autowired
    MonitoringConfig monitoringConfig;
    protected int interval;

    public void observe() throws IOException {
        List mandanten = this.mandantRepository.findAllActive();
        Date start = new Date(System.currentTimeMillis() + 5000L);
        for (Mandant mandant : mandanten) {
            this.interval = this.monitoringConfig.getMonitoringIntervalMinutes(mandant.getSedexId()) * 60;
            start.setTime(start.getTime() + Long.parseLong(System.getProperty("ch.admin.smclient.intervalBetweenJobs", "11000")));
            this.scheduleMonitoringMessage(start, mandant);
            this.scheduleEscalationUpdate(this.monitoringConfig, mandant, start);
            this.scheduleErrorNotificationUpdate(mandant, start);
        }
    }

    private void scheduleEscalationUpdate(MonitoringConfig monitoringConfig, Mandant mandant, Date start) {
    }

    private void scheduleErrorNotificationUpdate(Mandant mandant, Date start) {
    }

    private void scheduleMonitoringMessage(Date start, Mandant mandant) {
    }
}

