/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.monitoring;

import ch.admin.smclient.monitoring.model.MonitoringUser;
import ch.admin.smclient.monitoring.model.Organization;
import ch.admin.smclient.process.event.SendMailEvent;
import ch.admin.smclient.process.event.SendMailEventQueue;
import ch.admin.smclient.service.ProductVersion;
import ch.admin.smclient.service.monitoring.MessageGenerator;
import ch.admin.smclient.service.monitoring.MonitoringConfig;
import ch.admin.smclient.service.monitoring.MonitoringUserRepository;
import ch.admin.smclient.service.monitoring.OrganizationRepository;
import ch.admin.smclient.util.ServicesUtil;
import ch.admin.smclient2.monitoring.mail.EmailService;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class MonitoringSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MonitoringSender.class);
    public static final String COMPONENT_NAME = "monitoringSender";
    private static final String ESCALATION_TEMPLATE = "/monitoring/escalation-mail.xhtml";
    @Autowired
    SendMailEventQueue sendMailEventQueue;
    @Autowired
    private ProductVersion productVersion;
    @Autowired
    EmailService emailService;
    @Autowired
    MessageGenerator messageGenerator;
    @Autowired
    MonitoringConfig monitoringConfig;
    MonitoringUserRepository userRepository;

    @Async
    @Transactional
    public void update(JobExecutionContext context) {
        String sedexId = context.getJobDetail().getJobDataMap().getString("sedexId");
        try {
            MDC.put((String)"sedexId", (String)sedexId);
            int monitorBatchSize = this.monitoringConfig.getMonitorBatchSize(sedexId);
            Date triggerDate = this.monitoringConfig.getTriggerDate();
            MonitoringUserRepository userRepo = this.userRepository;
            List requiredUsers = userRepo.getUsersWithLastSendBefore(triggerDate, monitorBatchSize);
            for (MonitoringUser monitoringUser : requiredUsers) {
                File monitoringMessageZip = null;
                try {
                    File monitoringTempMessageZip = this.messageGenerator.createFile(monitoringUser);
                    File monitoringOutbox = this.monitoringConfig.getMonitoringOutbox(sedexId);
                    monitoringMessageZip = new File(monitoringOutbox, monitoringTempMessageZip.getName());
                    FileUtils.moveFile((File)monitoringTempMessageZip, (File)monitoringMessageZip);
                    FileUtils.deleteQuietly((File)monitoringTempMessageZip.getParentFile());
                    monitoringUser.setLastSend(new Date());
                    userRepo.persist(monitoringUser);
                }
                catch (Exception e) {
                    log.info("Unable to create file for user {0}, cause: {1}", (Object)monitoringUser, (Object)e.getMessage());
                    log.debug("Unable to create file for user {0}, cause: {1}", new Object[]{e, monitoringUser, e.getMessage()});
                    FileUtils.deleteQuietly((File)monitoringMessageZip);
                }
            }
            MDC.remove((String)"sedexId");
        }
        catch (Exception e) {
            log.error("unexpected error: {0}", (Object)e, (Object)e);
        }
    }

    public void execute(JobExecutionContext context) {
        String sedexId = context.getJobDetail().getJobDataMap().getString("sedexId");
        try {
            MDC.put((String)"sedexId", (String)sedexId);
            Date triggerDate = this.monitoringConfig.getEscalationDate();
            OrganizationRepository orgRepo = (OrganizationRepository)ServicesUtil.getComponent(OrganizationRepository.class);
            List orgs = orgRepo.findAll();
            for (Organization org : orgs) {
                List escalatedUsers = this.userRepository.getUsersWithLastSuccessBefore(triggerDate, org);
                if (escalatedUsers.isEmpty()) continue;
                Map escalationContext = this.createEscalationContext(org, escalatedUsers);
                try {
                    this.emailService.sendMessageAsynch(500L, ESCALATION_TEMPLATE, escalationContext);
                }
                catch (Exception e) {
                    log.info("Unable to send mail for org {0}, cause: {1}", (Object)org, (Object)e.getMessage());
                    log.debug("Unable to send mail for org {0}, cause: {1}", new Object[]{e, org, e.getMessage()});
                }
            }
            MDC.remove((String)"sedexId");
        }
        catch (Exception e) {
            log.error("unexpected error: {0}", (Object)e, (Object)e);
        }
    }

    public void execute2(JobExecutionContext context) {
        String sedexId = context.getJobDetail().getJobDataMap().getString("sedexId");
        try {
            MDC.put((String)"sedexId", (String)sedexId);
            SendMailEventQueue mailEventQueue = this.sendMailEventQueue;
            if (!mailEventQueue.isEmpty()) {
                log.info("#Monitoring# : tying to send EMAIL from event: creating email service");
                log.info("#Monitoring# : tying to send EMAIL from event: email service created");
                while (!mailEventQueue.isEmpty()) {
                    SendMailEvent mailEvent = mailEventQueue.poll();
                    try {
                        log.debug("#Monitoring# : try to send notification mail.");
                        this.emailService.sendMessageAsynch(mailEvent.getDelay(), mailEvent.getTemplatePath(), mailEvent.getContext());
                        log.info("#Monitoring# : tying to send EMAIL from event: email service called");
                    }
                    catch (Exception e) {
                        Object sendToUser = mailEvent.getContext().get("sendToUser");
                        log.info("Unable to send mail to {0}, cause: {1}", sendToUser, (Object)e.getMessage());
                        log.debug("Unable to send mail to {0}, cause: {1}", new Object[]{e, sendToUser, e.getMessage()});
                    }
                }
            }
            MDC.remove((String)"sedexId");
        }
        catch (Exception e) {
            log.error("unexpected error: {0}", (Object)e, (Object)e);
        }
    }

    private Map<String, Object> createEscalationContext(Organization org, List<MonitoringUser> escalatedUsers) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("productVersion", this.productVersion);
        context.put("organization", org);
        context.put("users", escalatedUsers);
        return context;
    }
}

