/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.smclient2.monitoring;

import ch.admin.smclient.monitoring.model.MonitoringUser;
import ch.admin.smclient.service.monitoring.MonitoringService;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class DashboardBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DashboardBean.class);
    public static final String COMPONENT_NAME = "dashboardBean";
    @Autowired
    private MonitoringService monitoringService;
    private int rowsPerPage = 10;
    private int scrollerPage = 1;
    private String logicSedexIdFilter;
    private String nameFilter;
    private String sedexStatusFilter;
    private String datetimePattern = "dd.MM.yyyy HH:mm";
    private String smcStatusFilter;
    private String organizationNameFilter;

    public List<MonitoringUser> getMonitoringUsers() {
        return this.monitoringService.findAllUsers();
    }

    public String getSedexStatusImage(MonitoringUser user) {
        return this.getStatusImage(user, user.isSedexStatus());
    }

    public String getSmcStatusImage(MonitoringUser user) {
        return this.getStatusImage(user, user.isSmcStatus());
    }

    public String getSedexStatusLabelKey(MonitoringUser user) {
        return this.getStatusLabelKey(user, user.isSedexStatus());
    }

    public String getSmcStatusLabelKey(MonitoringUser user) {
        return this.getStatusLabelKey(user, user.isSmcStatus());
    }

    private String getStatusImage(MonitoringUser user, boolean status) {
        String result = status ? "statusicon-green.gif" : "statusicon-red.gif";
        if (!user.isMonitored()) {
            result = "statusicon-grey.gif";
        }
        return result;
    }

    private String getStatusLabelKey(MonitoringUser user, boolean status) {
        String result = status ? "monitoring.status.success" : "monitoring.status.failed";
        if (!user.isMonitored()) {
            result = "monitoring.status.inactive";
        }
        return result;
    }

    @Generated
    public void setRowsPerPage(int rowsPerPage) {
        this.rowsPerPage = rowsPerPage;
    }

    @Generated
    public int getRowsPerPage() {
        return this.rowsPerPage;
    }

    @Generated
    public void setScrollerPage(int scrollerPage) {
        this.scrollerPage = scrollerPage;
    }

    @Generated
    public int getScrollerPage() {
        return this.scrollerPage;
    }

    @Generated
    public void setLogicSedexIdFilter(String logicSedexIdFilter) {
        this.logicSedexIdFilter = logicSedexIdFilter;
    }

    @Generated
    public String getLogicSedexIdFilter() {
        return this.logicSedexIdFilter;
    }

    @Generated
    public void setNameFilter(String nameFilter) {
        this.nameFilter = nameFilter;
    }

    @Generated
    public String getNameFilter() {
        return this.nameFilter;
    }

    @Generated
    public void setSedexStatusFilter(String sedexStatusFilter) {
        this.sedexStatusFilter = sedexStatusFilter;
    }

    @Generated
    public String getSedexStatusFilter() {
        return this.sedexStatusFilter;
    }

    @Generated
    public void setDatetimePattern(String datetimePattern) {
        this.datetimePattern = datetimePattern;
    }

    @Generated
    public String getDatetimePattern() {
        return this.datetimePattern;
    }

    @Generated
    public void setSmcStatusFilter(String smcStatusFilter) {
        this.smcStatusFilter = smcStatusFilter;
    }

    @Generated
    public String getSmcStatusFilter() {
        return this.smcStatusFilter;
    }

    @Generated
    public void setOrganizationNameFilter(String organizationNameFilter) {
        this.organizationNameFilter = organizationNameFilter;
    }

    @Generated
    public String getOrganizationNameFilter() {
        return this.organizationNameFilter;
    }
}

