<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common"
                xmlns:ms="urn:schemas-microsoft-com:xslt" xmlns:fo="http://www.w3.org/1999/XSL/Format" version="1.0">

    <xsl:param name="language" select="'it'"/>
    <xsl:variable name="langIgnoreCase"
                  select="translate($language,'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz')"/>
    <xsl:param name="currentDate"/>
    <xsl:param name="backgroundImage"/>
    <xsl:param name="Generator" select="'Viewgen'"/>
    <xsl:param name="Version" select="''"/>
    <xsl:param name="filename"/>

    <xsl:decimal-format name="decimal-format" decimal-separator="." grouping-separator="&#180;"
                        NaN=" "/>
    <xsl:decimal-format name="decimal-format-total" decimal-separator="." grouping-separator="&#180;"
                        NaN="0.00"/>
    <xsl:variable name="decimal-format-pattern"
                  select="string('###&#180;###&#180;###&#180;##0.00')"/>

    <xsl:decimal-format name="integer-format" decimal-separator="." grouping-separator="&#180;"
                        NaN="0"/>
    <xsl:variable name="integer-format-pattern"
                  select="string('0')"/>

    <xsl:variable name="dateFormat" select="'dd.MM.yy'"/>
    <xsl:variable name="dateFormatLong" select="'dd.MM.yyyy'"/>

    <xsl:variable name="microsoft" select="system-property('xsl:vendor')='Microsoft'"/>

    <xsl:template name="currentDate">
        <xsl:choose>
            <xsl:when test="$microsoft">
                <xsl:value-of select="$currentDate"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="date:format-date(date:date-time(), $dateFormat)"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="formatDate">
        <xsl:param name="date"/>
        <xsl:choose>
            <xsl:when test="$microsoft">
                <xsl:value-of select="ms:format-date($date, $dateFormat)"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="date:format-date($date, $dateFormat)"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="formatDateLong">
        <xsl:param name="date"/>
        <xsl:choose>
            <xsl:when test="$microsoft">
                <xsl:value-of select="ms:format-date($date, $dateFormatLong)"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="date:format-date($date, $dateFormatLong)"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="sum">
        <xsl:param name="values"/>
        <xsl:choose>
            <xsl:when test="$microsoft">
                <xsl:value-of select="sum(ms:node-set($values)/values/value)"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="sum(exsl:node-set($values)/values/value)"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="messageLookup">
        <xsl:param name="key"/>
        <xsl:value-of select="$messages/message[key=$key]/value[@lang=$langIgnoreCase]"/>
    </xsl:template>

    <xsl:template name="getSingleLineFooter">
        <xsl:variable name="xmlFile">
            <xsl:call-template name="substring-after-last">
                <xsl:with-param name="string" select="$filename"/>
                <xsl:with-param name="delimiter" select="'/'"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="namespace">
            <xsl:choose>
                <xsl:when test="namespace-uri(//*[local-name()='SalaryDeclaration']) = ''">
                    <xsl:value-of select="namespace-uri(//*[local-name()='GetResultFromDeclareSalaryResponse'])"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="namespace-uri(//*[local-name()='SalaryDeclaration'])"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <fo:block-container height="5mm" width="200mm">
            <fo:block text-align="center" font-size="5.5pt">
                [ swissdec / <xsl:value-of select="$TheXslName"/>&#160;
                <xsl:value-of select="$TheXslVersion"/>
                /
                <xsl:value-of select="$xmlFile"/>
                ;&#160;Src:&#160;
                <xsl:value-of select="$namespace"/>
                ,
                <xsl:value-of select="//*[local-name()='SalaryDeclaration']/@schemaVersion"/>
                ;&#160;
                <xsl:value-of select="$Generator"/>
                &#160;
                <xsl:value-of select="$Version"/>
                ]
            </fo:block>
        </fo:block-container>
    </xsl:template>

    <xsl:template name="substring-after-last">
        <xsl:param name="string"/>
        <xsl:param name="delimiter"/>
        <xsl:choose>
            <xsl:when test="contains($string, $delimiter)">
                <xsl:call-template name="substring-after-last">
                    <xsl:with-param name="string"
                                    select="substring-after($string, $delimiter)"/>
                    <xsl:with-param name="delimiter" select="$delimiter"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$string"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>
