<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:eCH-0007="http://www.ech.ch/xmlns/eCH-0007/3"
	xmlns:eCH-0010="http://www.ech.ch/xmlns/eCH-0010/3"
	xmlns:ssk-common="http://www.steuerkonferenz.ch/xmlns/ssk-common/1">
	
	<xsl:import href="ssk-common-1-1_fr.xsl"/>
	
	<!--
		Parameter receipt date to be passed in when creating the message layout.
		This must be a valid xs:date
	-->
	<xsl:param name="dateOfReceipt"></xsl:param>
	
	<!--
		The main template, defining page masters, sequence masters and page sequence
	-->
	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master margin="{$page-margins}" master-name="first-page">
					<xsl:attribute name="page-height">297mm</xsl:attribute>
					<xsl:attribute name="page-width">210mm</xsl:attribute>
					<fo:region-body region-name="page-body" margin-top="{$first-body-top-margin}" margin-bottom="{$body-bottom-margin}"/>
					<fo:region-before region-name="first-page-header" extent="{$first-header-height}"/>
					<fo:region-after region-name="page-footer" extent="{$footer-height}"/>
				</fo:simple-page-master>
				<fo:simple-page-master margin="{$page-margins}" master-name="other-pages">
					<xsl:attribute name="page-height">297mm</xsl:attribute>
					<xsl:attribute name="page-width">210mm</xsl:attribute>
					<fo:region-body region-name="page-body" margin-top="{$body-top-margin}" margin-bottom="{$body-bottom-margin}"/>
					<fo:region-before region-name="page-header" extent="{$header-height}"/>
					<fo:region-after region-name="page-footer" extent="{$footer-height}"/>
				</fo:simple-page-master>
				<fo:page-sequence-master master-name="pages-content">
					<fo:single-page-master-reference master-reference="first-page"/>
					<fo:repeatable-page-master-reference master-reference="other-pages"/>
				</fo:page-sequence-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="pages-content">
				<fo:static-content flow-name="page-header">
					<xsl:apply-templates select="//ssk-common:reportHeader" mode="page-header"/>
				</fo:static-content>
				<fo:static-content flow-name="page-footer">
					<xsl:apply-templates select="//ssk-common:reportHeader" mode="page-footer"/>
				</fo:static-content>
				<fo:flow flow-name="page-body">
					<xsl:apply-templates select="//ssk-common:reportHeader" mode="message-header-block"/>
					<xsl:apply-templates select="//ssk-common:reportHeader" mode="special-message"/>
					<xsl:apply-templates select="//ssk-common:reportHeader" mode="page-header"/>
					<fo:block background-color="{$grey-background}" font-family="{$font-family}">
						<fo:block background-color="white" margin-left="3mm" padding-left="4mm">
							<xsl:apply-templates select="//ssk-common:report"/>
						</fo:block>
					</fo:block>
					<fo:block id="pageCounter" keep-with-previous="always"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	
	<!--
		Fixed header block on page one
	-->
	<xsl:template match="ssk-common:reportHeader" mode="message-header-block">
		<fo:block background-color="{$grey-background}" space-after="1mm" font-family="{$font-family}">
			<fo:table table-layout="fixed" width="100%">
				<fo:table-column column-width="100%" column-number="1"/>
				<fo:table-body>
					<fo:table-row>
						<fo:table-cell column-number="1" display-align="center">
							<fo:block margin-left="7mm" margin-top="1mm" font-weight="bold">
								<xsl:value-of select="$ssk-common"/> | <xsl:value-of select="$ssk-common.action.11"/>
							</fo:block>
							<fo:block margin-left="7mm" margin-bottom="1mm" font-size="8pt">www.chm-steuern.ch</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</fo:table-body>
			</fo:table>
			<fo:block background-color="white" margin-top="3mm" margin-left="3mm">
				<fo:block margin-top="4mm" margin-left="4mm">
					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="{$header-left-column-width}" column-number="1"/>
						<fo:table-column column-width="{$header-right-column-width}" column-number="2"/>
						<fo:table-body>
							<fo:table-row>
								<!-- left column, show sender, recipient and local reference -->
								<fo:table-cell column-number="1" margin-left="0mm">
									<fo:table table-layout="fixed" width="100%" border-collapse="separate">
										<fo:table-column column-width="38mm" column-number="1"/>
										<fo:table-column column-width="47mm" column-number="2"/>
										<fo:table-body>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-common.senderId"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-sedex-id">
															<xsl:with-param name="id"><xsl:value-of select="ssk-common:senderId"/></xsl:with-param>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-common.recipientId"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:for-each select="ssk-common:recipientId">
															<xsl:if test="position() != 1"><xsl:text>, </xsl:text></xsl:if>
															<xsl:call-template name="decode-sedex-id">
																<xsl:with-param name="id"><xsl:value-of select="."/></xsl:with-param>
															</xsl:call-template>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</fo:table-cell>
								<!-- right column, shows other header details -->
								<fo:table-cell column-number="2" margin-left="0mm">
									<fo:table table-layout="fixed" width="100%" border-collapse="separate">
										<fo:table-column column-width="38mm" column-number="1"/>
										<fo:table-column column-width="47mm" column-number="2"/>
										<fo:table-body>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-common.action"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-action">
															<xsl:with-param name="value" select="ssk-common:action"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-common.originalSenderId"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-sedex-id">
															<xsl:with-param name="id" select="ssk-common:originalSenderId"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-common.initialMessageDate"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="format-date">
															<xsl:with-param name="value" select="ssk-common:initialMessageDate"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-common.ourBusinessReferenceID"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block><xsl:value-of select="ssk-common:ourBusinessReferenceID"/></fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-common.yourBusinessReferenceId"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block><xsl:value-of select="ssk-common:yourBusinessReferenceId"/></fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-common.pages"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block><fo:page-number-citation ref-id="pageCounter"/></fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:block>
			</fo:block>
		</fo:block>
	</xsl:template>
	
	<!--
		Conditional "Alert" if there is something special about this message
	-->
	<xsl:template match="ssk-common:reportHeader" mode="special-message">
		<xsl:variable name="is-test" select="(ssk-common:testDeliveryFlag = '1') or (ssk-common:testDeliveryFlag = 'true')"/>
		<xsl:variable name="is-priority" select="ssk-common:messagePriority > 0"/>
		<xsl:if test="$is-test or $is-priority">
			<fo:block margin-left="0mm" padding="1mm" padding-left="7mm" padding-right="0mm" background-color="{$grey-background}" space-after="1mm" font-family="{$font-family}" font-weight="bold">
				<xsl:if test="is-priority">
					<xsl:value-of select="concat($ssk-common.messagePriority, ': ')"/>
					<xsl:value-of select="ssk-common:messagePriority"/>
				</xsl:if>
				<xsl:if test="$is-test and $is-priority">
					<xsl:value-of select="' | '"/>
				</xsl:if>
				<xsl:if test="$is-test">
					<xsl:value-of select="concat(' ** ', $ssk-common.testDeliveryFlag, ' ** ')"/>
				</xsl:if>
			</fo:block>
		</xsl:if>
	</xsl:template>
	
	<!--
		Errortext for negative receipt or specialistFeedback
	-->
	<xsl:template match="ssk-common:errorText">
		<fo:table table-layout="fixed" width="100%" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$ssk-common.errorText"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block linefeed-treatment="preserve">
							<xsl:value-of select="."/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!--
		Errorcode for negative receipt
	-->
	<xsl:template match="ssk-common:errorCode">
		<xsl:call-template name="single-number-block">
			<xsl:with-param name="title" select="$ssk-common.errorCode"/>
			<xsl:with-param name="value" select="."/>
		</xsl:call-template>
	</xsl:template>
	
	<!--
		Hand on to children
	-->
	<xsl:template match="ssk-common:report | ssk-common:negativeReport | ssk-common:specialistFeedback">
		<xsl:apply-templates select="*"/>
	</xsl:template>
	
	<!--
		Page header, shows the message subject in a bar on first page and as header in subsequent pages.
	-->
	<xsl:template mode="page-header" match="ssk-common:reportHeader">
		<fo:table background-color="{$grey-background}" table-layout="fixed" width="100%">
			<fo:table-column column-width="3mm" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell height="7mm" column-number="2" display-align="center">
						<fo:block margin-left="4mm" font-family="{$font-family}" font-weight="bold" >
							<xsl:call-template name="decode-action">
								<xsl:with-param name="value" select="ssk-common:action"/>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell height="4mm" background-color="white" column-number="2">
						<fo:block/>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!--
		Page footer, shows page numbers and some info from message header.
	-->
	<xsl:template mode="page-footer" match="ssk-common:reportHeader">
		<fo:table table-layout="fixed" width="100%">
			<fo:table-column column-width="170mm" column-number="1"/>
			<fo:table-column column-width="15mm" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="footer">
						<fo:block font-family="{$font-family}">
							<xsl:value-of select="ssk-common:messageType"/>/<xsl:value-of select="ssk-common:subMessageType"/>
							| <xsl:value-of select="concat($ssk-common.messageId, ' ')"/>
							<xsl:value-of select="ssk-common:messageId"/>
							<xsl:if test="count(ssk-common:referenceMessageId) != 0">
								| <xsl:value-of select="concat($ssk-common.referenceMessageId, ' ')"/>
								<xsl:value-of select="ssk-common:referenceMessageId"/>
							</xsl:if>
							| <xsl:value-of select="concat($ssk-common.dateOfReceipt, ' ')"/> 
							<xsl:call-template name="format-date">
								<xsl:with-param name="value"><xsl:value-of select="$dateOfReceipt"/></xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="footer" text-align="end">
						<fo:block font-family="{$font-family}">
							<fo:page-number/>/<fo:page-number-citation ref-id="pageCounter"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
</xsl:stylesheet>